// MidiEvent.h: interface for the CMidiEvent class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MIDIEVENT_H__5C526A6F_AE86_4423_9DA3_9496FFA3A9E1__INCLUDED_)
#define AFX_MIDIEVENT_H__5C526A6F_AE86_4423_9DA3_9496FFA3A9E1__INCLUDED_

	enum MidiEventType {
		ShortMsg,
		SysexData
	};

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMidiEvent  
{
public:


private:
	LONGLONG timemarker;
	MidiEventType myType;
	CMidiEvent *nxtEvent;
	bool finalEvent;

public:
	char *SysexInfo;
	LONG sysexLen;
	LONG MidiMsg;

	CMidiEvent() {
		SysexInfo = NULL;
		nxtEvent = NULL;
		finalEvent = true;
	};
	~CMidiEvent() {};
	

	LONGLONG getTime(void) {
		return timemarker;
	}
	MidiEventType getType(void) {
		return myType;
	}
	CMidiEvent * Consume(void) {
		if (myType==SysexData) {
			if(SysexInfo!=NULL) free(SysexInfo);
		}
		
		return nxtEvent;
	}

	bool isFinal() {
		return finalEvent;
	}
	void ChainEvent(CMidiEvent *newEvent) {
		finalEvent = false;
		nxtEvent = newEvent;
	}

	void AssignSysex(char *Sysex, LONG len, LONGLONG setTime) {
		myType = SysexData;
		sysexLen = len;
		SysexInfo = Sysex;
		timemarker = setTime;
	}

	void AssignMsg(LONG Msg, LONGLONG setTime) {
		myType = ShortMsg;
		MidiMsg = Msg;
		timemarker = setTime;
	}





};

#endif // !defined(AFX_MIDIEVENT_H__5C526A6F_AE86_4423_9DA3_9496FFA3A9E1__INCLUDED_)
