/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __TIMIP_MIDITRACE_H_
#define __TIMIP_MIDITRACE_H_

#ifdef WIN32
#include "timip_win32.h"
#endif
#include "timip_mblock.h"
#include "timip_controls.h"

typedef struct _MidiTrace
{
    int offset;		/* sample offset */
    int flush_flag;	/* True while in timip_trace_flush() */

    void (* trace_loop_hook)(void);	/* Hook function for extension */

    /* Delayed event list  (The member is only access in miditrace.c) */
    struct _MidiTraceList *head;
    struct _MidiTraceList *tail;

    /* Memory buffer */
    struct _MidiTraceList *free_list;
    MBlockList pool;
} MidiTrace;

extern void timip_init_midi_trace(void);

extern void timip_push_midi_trace0(void (*f)(void));
extern void timip_push_midi_trace1(void (*f)(int), int arg1);
extern void timip_push_midi_trace2(void (*f)(int, int), int arg1, int arg2);
extern void timip_push_midi_trace_ce(void (*f)(CtlEvent *), CtlEvent *ce);
extern void timip_push_midi_time_vp(int32 start, void (*f)(void *), void *vp);

extern int32 timip_trace_loop(void);
extern void timip_trace_flush(void);
extern void timip_trace_offset(int offset);
extern void trace_nodelay(int nodelay);
extern void timip_set_trace_loop_hook(void (* f)(void));
extern int32 timip_current_trace_samples(void);
extern int32 timip_trace_wait_samples(void);

LIBTIMIPDLL_API extern MidiTrace timip_midi_trace;

#endif /* __TIMIP_MIDITRACE_H_ */
