/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


   common.h
*/

#ifndef __TIMIP_COMMON_H_
#define __TIMIP_COMMON_H_

#ifdef WIN32
#include "timip_win32.h"
#endif

#include "timip_sysdep.h"
#include "timip_url.h"
#include "timip_mblock.h"

LIBTIMIPDLL_API extern char *timip_program_name, timip_current_filename[];
LIBTIMIPDLL_API extern const char *timip_note_name[];

typedef struct {
  char *path;
  void *next;
} PathList;

struct timidity_file
{
    URL url;
    char *tmpname;
};

/* Noise modes for timip_open_file */
#define OF_SILENT	0
#define OF_NORMAL	1
#define OF_VERBOSE	2


extern void timip_add_to_pathlist(char *s);
extern void timip_clean_up_pathlist(void);
extern int timip_is_url_prefix(const char *name);
extern struct timidity_file *timip_open_file(char *name,
				       int decompress, int noise_mode);
extern struct timidity_file *timip_open_with_mem(char *mem, int32 memlen,
					   int noise_mode);
extern void timip_close_file(struct timidity_file *tf);
extern void skip(struct timidity_file *tf, size_t len);
extern char *timip_tf_gets(char *buff, int n, struct timidity_file *tf);
#define tf_getc(tf) (url_getc((tf)->url))
extern long timip_tf_read(void *buff, int32 size, int32 nitems,
		    struct timidity_file *tf);
extern long timip_tf_seek(struct timidity_file *tf, long offset, int whence);
extern long timip_tf_tell(struct timidity_file *tf);
extern int timip_int_rand(int n);	/* random [0..n-1] */
extern int timip_check_file_extension(char *filename, char *ext, int decompress);

extern void *timip_safe_malloc(size_t count);
extern void *timip_safe_realloc(void *old_ptr, size_t new_size);
extern void *timip_safe_large_malloc(size_t count);
extern char *timip_safe_strdup(const char *s);
extern void timip_free_ptr_list(void *ptr_list, int count);
extern int timip_string_to_7bit_range(const char *s, int *start, int *end);
extern char **timip_expand_file_archives(char **files, int *nfiles_in_out);
extern void timip_randomize_string_list(char **strlist, int nstr);
extern int timip_pathcmp(const char *path1, const char *path2, int ignore_case);
extern void timip_sort_pathname(char **files, int nfiles);
extern int  timip_load_table(char *file);
extern char *timip_pathsep_strrchr(const char *path);
extern char *timip_pathsep_strchr(const char *path);
extern int timip_str2mID(char *str);


/* code:
 * "EUC"	- Extended Unix Code
 * NULL		- Auto conversion
 * "JIS"	- Japanese Industrial Standard code
 * "SJIS"	- shift-JIS code
 */
extern void timip_code_convert(char *in, char *out, int outsiz,
			 char *in_code, char *out_code);

extern void timip_safe_exit(int status);

LIBTIMIPDLL_API extern char *timip_timidity_version;
LIBTIMIPDLL_API extern MBlockList timip_tmpbuffer;
LIBTIMIPDLL_API extern char *timip_output_text_code;

#endif /* __TIMIP_COMMON_H_ */
