/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.crimson.tree.XmlDocument;

public class xps2tms
extends JFrame
implements ActionListener {
    private static xps2tms frame;
    private JTextArea[] textArea;
    private JFileChooser chooser;
    private String xpsfilename;
    private String mapfilename;
    private String tmsfilename;
    private String avifilename;
    private String execfilename;
    private XmlDocument xdoc;
    private Integer window_px;
    private Integer window_py;
    private Integer window_sx;
    private Integer window_sy;
    private String defaultpath = null;

    public static void main(String[] args) {
        frame = new xps2tms();
        frame.setDefaultCloseOperation(3);
        ((Component)frame).setBounds(xps2tms.frame.window_px, xps2tms.frame.window_py, xps2tms.frame.window_sx, xps2tms.frame.window_sy);
        ((Component)frame).setVisible(true);
    }

    xps2tms() {
        super("nas(U)-TMS\u5909\u63db");
        this.loadPreferences();
        JButton openxps = new JButton("XPS\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc");
        openxps.setActionCommand("OpenXPS");
        openxps.addActionListener(this);
        JButton openmap = new JButton("MAP\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc");
        openmap.setActionCommand("OpenMAP");
        openmap.addActionListener(this);
        JButton maketms = new JButton("TMS\u306b\u5909\u63db");
        maketms.setActionCommand("MakeTMS");
        maketms.addActionListener(this);
        JButton savexps = new JButton("XPS\u4fdd\u5b58");
        savexps.setActionCommand("SaveXPS");
        savexps.addActionListener(this);
        JButton savemap = new JButton("MAP\u4fdd\u5b58");
        savemap.setActionCommand("SaveMAP");
        savemap.addActionListener(this);
        JButton savetms = new JButton("TMS\u4fdd\u5b58");
        savetms.setActionCommand("SaveTMS");
        savetms.addActionListener(this);
        JButton saveavi = new JButton("AVI\u4f5c\u6210");
        saveavi.setActionCommand("SaveAVI");
        saveavi.addActionListener(this);
        JButton end = new JButton("\u7d42\u4e86");
        end.setActionCommand("Exit");
        end.addActionListener(this);
        this.textArea = new JTextArea[3];
        int i = 0;
        while (i < 3) {
            this.textArea[i] = new JTextArea();
            this.textArea[i].setWrapStyleWord(false);
            this.textArea[i].setLineWrap(false);
            ++i;
        }
        JScrollPane[] scroll = new JScrollPane[3];
        int i2 = 0;
        while (i2 < 3) {
            scroll[i2] = new JScrollPane(this.textArea[i2]);
            scroll[i2].setVerticalScrollBarPolicy(22);
            scroll[i2].setPreferredSize(new Dimension(500, 250));
            ++i2;
        }
        JPanel panel = new JPanel();
        panel.add(openxps);
        panel.add(openmap);
        panel.add(maketms);
        JPanel panel2 = new JPanel();
        panel2.add(savexps);
        panel2.add(savemap);
        panel2.add(savetms);
        panel2.add(saveavi);
        panel2.add(end);
        String[] tabtext = new String[]{"XPS(ShiftJIS)", "MAP(ShiftJIS)", "TMS(UTF-8)"};
        String[] tips = new String[]{"XPS\u30d5\u30a1\u30a4\u30eb\u306e\u4e2d\u8eab", "MAP\u30d5\u30a1\u30a4\u30eb\u306e\u4e2d\u8eab", "\u4f5c\u6210\u3057\u305fTMS\u30d5\u30a1\u30a4\u30eb"};
        JTabbedPane tabbedPane = new JTabbedPane(1);
        int i3 = 0;
        while (i3 < tabtext.length) {
            tabbedPane.addTab(tabtext[i3], null, scroll[i3], tips[i3]);
            ++i3;
        }
        Container cnt = this.getContentPane();
        cnt.add((Component)panel, "North");
        cnt.add((Component)tabbedPane, "Center");
        cnt.add((Component)panel2, "South");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPreferences() {
        Preferences prefs = Preferences.userRoot().node("nekora/xps2tms");
        this.window_px = new Integer(prefs.getInt("pointx", 10));
        this.window_py = new Integer(prefs.getInt("pointy", 10));
        this.window_sx = new Integer(prefs.getInt("sizex", 790));
        this.window_sy = new Integer(prefs.getInt("sizey", 470));
        this.defaultpath = prefs.get("defaultpath", null);
        this.execfilename = prefs.get("execfilename", "tms2avi.exe");
    }

    private void savePreferences() {
        Preferences prefs = Preferences.userRoot().node("nekora/xps2tms");
        Rectangle re = this.getBounds();
        this.window_px = new Integer(re.x);
        this.window_py = new Integer(re.y);
        this.window_sx = new Integer(re.width);
        this.window_sy = new Integer(re.height);
        prefs.put("pointx", this.window_px.toString());
        prefs.put("pointy", this.window_py.toString());
        prefs.put("sizex", this.window_sx.toString());
        prefs.put("sizey", this.window_sy.toString());
        if (this.defaultpath != null) {
            prefs.put("defaultpath", this.defaultpath);
        }
        if (this.execfilename != null) {
            prefs.put("execfilename", this.execfilename);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand() == "OpenXPS") {
            this.OpenXPS();
        } else if (ae.getActionCommand() == "OpenMAP") {
            this.OpenMAP();
        } else if (ae.getActionCommand() == "MakeTMS") {
            this.convert();
        } else if (ae.getActionCommand() == "SaveXPS") {
            this.SaveXPS();
        } else if (ae.getActionCommand() == "SaveMAP") {
            this.SaveMAP();
        } else if (ae.getActionCommand() == "Exit") {
            this.setExtendedState(0);
            this.savePreferences();
            System.exit(0);
        } else if (ae.getActionCommand() == "SaveAVI") {
            this.SaveAVI();
        } else if (ae.getActionCommand() == "SaveTMS") {
            this.SaveTMS();
        }
    }

    private void OpenXPS() {
        this.chooser = this.defaultpath != null ? new JFileChooser(this.defaultpath) : new JFileChooser();
        FileExtFilter filter = new FileExtFilter();
        filter.addExtension("xps");
        filter.setDescription("nas-(U)-XPS");
        this.chooser.setFileFilter(filter);
        int returnVal = this.chooser.showOpenDialog(this);
        try {
            if (returnVal == 0) {
                this.xpsfilename = this.chooser.getSelectedFile().getPath();
                File file = this.chooser.getSelectedFile();
                FileReader fr = new FileReader(file);
                this.textArea[0].read(fr, null);
                frame.setTitle(file.getAbsolutePath());
                fr.close();
                this.defaultpath = this.xpsfilename;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void OpenMAP() {
        this.chooser = this.defaultpath != null ? new JFileChooser(this.defaultpath) : new JFileChooser();
        FileExtFilter filter = new FileExtFilter();
        filter.addExtension("map");
        filter.setDescription("nas(U)-MAP");
        this.chooser.setFileFilter(filter);
        int returnVal = this.chooser.showOpenDialog(this);
        try {
            if (returnVal == 0) {
                this.mapfilename = this.chooser.getSelectedFile().getPath();
                File file = this.chooser.getSelectedFile();
                FileReader fr = new FileReader(file);
                this.textArea[1].read(fr, null);
                frame.setTitle(file.getAbsolutePath());
                ((Reader)fr).close();
                this.defaultpath = this.mapfilename;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void SaveXPS() {
        String xpstext = this.textArea[0].getText();
        if (xpstext == null || xpstext.length() <= 0) {
            return;
        }
        this.chooser = this.defaultpath != null ? new JFileChooser(this.defaultpath) : new JFileChooser();
        FileExtFilter filter = new FileExtFilter();
        filter.addExtension("xps");
        filter.setDescription("Timesheet");
        this.chooser.setFileFilter(filter);
        int returnVal = this.chooser.showSaveDialog(this);
        try {
            if (returnVal == 0) {
                this.xpsfilename = this.chooser.getSelectedFile().getPath();
                if (this.xpsfilename.indexOf(".xps") < 0) {
                    this.xpsfilename = String.valueOf(this.xpsfilename) + ".xps";
                }
                File newXML = new File(this.xpsfilename);
                FileOutputStream os = new FileOutputStream(newXML);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
                out.write(xpstext);
                ((Writer)out).flush();
                ((Writer)out).close();
                os.flush();
                os.close();
                this.defaultpath = this.xpsfilename;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void SaveMAP() {
        String maptext = this.textArea[1].getText();
        if (maptext == null || maptext.length() <= 0) {
            return;
        }
        this.chooser = this.defaultpath != null ? new JFileChooser(this.defaultpath) : new JFileChooser();
        FileExtFilter filter = new FileExtFilter();
        filter.addExtension("map");
        filter.setDescription("Map");
        this.chooser.setFileFilter(filter);
        int returnVal = this.chooser.showSaveDialog(this);
        try {
            if (returnVal == 0) {
                this.mapfilename = this.chooser.getSelectedFile().getPath();
                if (this.mapfilename.indexOf(".map") < 0) {
                    this.mapfilename = String.valueOf(this.mapfilename) + ".map";
                }
                File newXML = new File(this.mapfilename);
                FileOutputStream os = new FileOutputStream(newXML);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
                out.write(maptext);
                ((Writer)out).flush();
                ((Writer)out).close();
                os.flush();
                os.close();
                this.defaultpath = this.mapfilename;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void SaveAVI() {
        block8: {
            System.out.println("SaveAVI");
            if (this.xdoc == null && !this.convert()) {
                return;
            }
            this.chooser = this.defaultpath != null ? new JFileChooser(this.defaultpath) : new JFileChooser();
            FileExtFilter filter = new FileExtFilter();
            filter.addExtension("avi");
            filter.setDescription("\u6620\u50cf\u30d5\u30a1\u30a4\u30eb");
            this.chooser.setFileFilter(filter);
            int returnVal = this.chooser.showSaveDialog(this);
            try {
                if (returnVal != 0) break block8;
                this.avifilename = this.chooser.getSelectedFile().getPath();
                if (this.avifilename.indexOf(".avi") < 0) {
                    this.avifilename = String.valueOf(this.avifilename) + ".avi";
                }
                this.tmsfilename = String.valueOf(this.avifilename.substring(0, this.avifilename.indexOf(".avi"))) + ".xml";
                System.out.println("SaveAVI avi=" + this.avifilename + " tms=" + this.tmsfilename);
                File newXML = new File(this.tmsfilename);
                FileOutputStream os = new FileOutputStream(newXML);
                this.xdoc.write((OutputStream)os);
                os.flush();
                os.close();
                String[] cmdline = new String[]{this.execfilename != null ? this.execfilename : "tms2avi.exe", this.tmsfilename};
                Runtime rtm = Runtime.getRuntime();
                while (true) {
                    try {
                        rtm.exec(cmdline);
                    }
                    catch (Exception rtx) {
                        rtx.printStackTrace();
                        this.chooser = this.execfilename != null ? new JFileChooser(this.execfilename) : new JFileChooser();
                        filter = new FileExtFilter();
                        filter.addExtension("exe");
                        filter.setDescription("tms2avi\u5b9f\u884c\u30d5\u30a1\u30a4\u30eb");
                        this.chooser.setFileFilter(filter);
                        returnVal = this.chooser.showOpenDialog(this);
                        if (returnVal == 0) {
                            this.execfilename = this.chooser.getSelectedFile().getPath();
                            this.savePreferences();
                            cmdline[0] = this.execfilename;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void SaveTMS() {
        if (this.xdoc == null && !this.convert()) {
            return;
        }
        this.chooser = this.defaultpath != null ? new JFileChooser(this.defaultpath) : new JFileChooser();
        FileExtFilter filter = new FileExtFilter();
        filter.addExtension("tms");
        filter.addExtension("xml");
        filter.setDescription("TiMe Sheet");
        this.chooser.setFileFilter(filter);
        int returnVal = this.chooser.showSaveDialog(this);
        try {
            if (returnVal == 0) {
                this.tmsfilename = this.chooser.getSelectedFile().getPath();
                if (this.tmsfilename.indexOf(".xml") < 0 && this.tmsfilename.indexOf(".tms") < 0) {
                    this.tmsfilename = String.valueOf(this.tmsfilename) + ".tms";
                }
                File newXML = new File(this.tmsfilename);
                FileOutputStream os = new FileOutputStream(newXML);
                this.xdoc.write((OutputStream)os);
                os.flush();
                os.close();
                this.defaultpath = this.tmsfilename;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean convert() {
        boolean ret = false;
        String xps = this.textArea[0].getText();
        String map = this.textArea[1].getText();
        if (xps != null && map != null && xps.length() > 0 && map.length() > 0) {
            makeDom tms = new makeDom();
            this.xdoc = null;
            try {
                tms.init();
                this.xdoc = (XmlDocument)tms.exec(xps, map);
                if (this.xdoc != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    this.xdoc.write((OutputStream)bos);
                    this.textArea[2].setText(bos.toString("UTF-8"));
                    ret = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.xdoc = null;
            }
        }
        return ret;
    }
}

