<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * ʸ󤬿ͤȤɾǤͤϰǤ뤫򸡾
 * 
 * @package    tima
 * @subpackage tima_Validator
 * @version    SVN: $Id: Range.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Validator_Range extends Validator_AbstractValidator
{

    /**
     * ʸ󤬿ͤȤɾǤͤϰǤ뤫򸡾
     *
     * PHPηѴεưθơѹϥ㥹ȤǤϤʤ׻̤
     * - (float)"0x12" => 0
     * - ("0x12" + 0.0) => 18.0
     * 
     * $paramsפͤư
     * - Ǿ͡ʻ꤬ʤС0ס
     * - ͡ʻ꤬ʤС0ס
     * 
     * @param  string     $attribute
     * @param  array|null $params
     * @return boolean
     * @access protected
     * @see    Validator_Numeric::doFunction()
     */
    function doFunction($attribute, $params)
    {
        $min = 0.0;
        $max = 0.0;
        if (($param = array_shift($params)) !== null) {
            $min = ($param + 0.0);
        }
        if (($param = array_shift($params)) !== null) {
            $max = ($param + 0.0);
        }

        $numeric = &$this->getFunction('numeric');
        if (($numeric !== null) && !$numeric->doFunction($attribute, null)) {
            return false;
        }
        $value = ($attribute + 0.0);

        return (($value >= $min) && ($value <= $max));
    }
}
