/*
 * Decompiled with CFR 0.152.
 */
package jp.thunderclacker.svnmail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SVNMailSender {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("svn-mailsender");
    private boolean logging = true;
    private String repository = "";
    private String revision = "";
    private PrintWriter writer = null;

    public static void main(String[] args) {
        SVNMailSender svnMailSender = new SVNMailSender(args);
        svnMailSender.sendCommitMail();
    }

    public SVNMailSender(String[] args) {
        this.repository = args[0];
        this.revision = args[1];
        try {
            String logging = this.getProperty("logging");
            if (logging.equalsIgnoreCase("true")) {
                this.logging = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCommitMail() {
        try {
            try {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(this.repository) + "/mail/svncommit.log", true)));
                this.log("------------------ SVNMailSender ------------------");
                Properties mailprop = new Properties();
                mailprop.put("mail.smtp.host", this.getProperty("server.smtp"));
                Session session = Session.getDefaultInstance(mailprop, null);
                MimeMessage message = new MimeMessage(session);
                String mailTo = this.getProperty("mail.to");
                this.log("To: " + mailTo);
                message.setRecipients(MimeMessage.RecipientType.TO, InternetAddress.parse(mailTo, true));
                String mailFrom = this.getProperty("mail.from");
                this.log("From: " + mailFrom);
                InternetAddress objFrm = new InternetAddress(mailFrom);
                message.setFrom(objFrm);
                String mailReplyTo = this.getProperty("mail.replyto");
                this.log("Reply-To: " + mailReplyTo);
                message.setReplyTo(InternetAddress.parse(mailReplyTo, true));
                String subject = this.getSubject();
                this.log("Subject: " + subject);
                message.setSubject(subject, "ISO-2022-JP");
                String text = this.getText();
                this.log("Text: " + text);
                message.setText(text, "ISO-2022-JP");
                Transport.send(message);
                this.log("--------------------------------------------------\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.log(sw.toString());
            }
        }
        finally {
            this.writer.close();
            this.writer = null;
        }
    }

    private String getText() throws IOException {
        StringBuffer msg = new StringBuffer();
        String tracHome = this.getProperty("trac.home");
        String upddate = new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date());
        String author = this.execCommand("svnlook author " + this.repository + " -r " + this.revision);
        String log = this.execCommand("svnlook log " + this.repository + " -r " + this.revision);
        String changed = this.execCommand("svnlook changed " + this.repository + " -r " + this.revision);
        msg.append("\n\u3053\u306e\u30e1\u30fc\u30eb\u306fSubversion\u304b\u3089\u306e\u30b3\u30df\u30c3\u30c8\u901a\u77e5\u30e1\u30fc\u30eb\u3067\u3059\u3002\n");
        msg.append("\n============================================");
        msg.append("\n Repository: ").append(this.repository);
        msg.append("\n   Revision: Rev.").append(this.revision);
        msg.append("\n   Commiter: ").append(author);
        if (!tracHome.equals("")) {
            msg.append("\n   Trac-URL: ").append(tracHome).append("/changeset/").append(this.revision);
        }
        msg.append("\n       Date: ").append(upddate);
        msg.append("\n============================================");
        msg.append("\nLog Message:\n").append(log);
        msg.append("\n");
        msg.append("\nChanged:\n").append(changed);
        msg.append("\n");
        msg.append("\n---");
        msg.append("\nReply-To: ").append(this.getProperty("mail.replyto"));
        return msg.toString();
    }

    private String getSubject() throws IOException {
        String changed = this.execCommand("svnlook changed " + this.repository + " -r " + this.revision);
        String firstLine = changed.split("\n")[0];
        String[] tmp = firstLine.split("/");
        String moduleName = "";
        moduleName = tmp.length == 1 ? String.valueOf(tmp[0]) + "/" : (tmp.length == 2 ? String.valueOf(tmp[1]) + "/" : String.valueOf(tmp[1]) + "/" + tmp[2] + "/");
        String prefix = this.getProperty("subject.prefix");
        String subject = String.valueOf(prefix) + "Subversion commit to \"" + moduleName + "\"";
        return subject;
    }

    private String execCommand(String command) throws IOException {
        String line;
        Process process = Runtime.getRuntime().exec(command);
        InputStream is = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer buf = new StringBuffer("");
        while ((line = br.readLine()) != null) {
            buf.append(line).append("\n");
        }
        buf.delete(buf.length() - 1, buf.length());
        return buf.toString();
    }

    private String getProperty(String key) {
        try {
            String res = RESOURCE.getString(key);
            if (res != null) {
                return res.trim();
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return "";
    }

    private void log(String msg) {
        if (!this.logging) {
            return;
        }
        try {
            this.writer.println(msg);
            this.writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

