#!/usr/bin/perl
#------------------------------------------------------------------------------
#    ThreadPlus, simply forum CGI.
#    Copyright (C) 2012,2013 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

# ----- data functions -----
sub _get_newcommentid {
    my $threadid = shift;
    my @recs = _get_threaddata($threadid);
    if (scalar(@recs) == 1) { return 1; } # コメント0件
    my $lastrec = pop @recs;
    my @fields = split(/,/, $lastrec);
    $fields[0]++;
    return $fields[0];
}

sub _get_threadtitle {
    my $threadid = shift;
    my @recs = _get_threaddata($threadid);
    my $threadrec = shift @recs;
    my @fields = split(/,/, $threadrec);
    $fields[2] =~ s/enc_conma/,/g;
    return $fields[2];
}

sub _get_threaddata {
    my $threadid = shift;
    my @datarec = ();
    my $datafile = get_data_dir() . "/thread_$threadid.data";
    if (-f $datafile) {
        open my $datafh, '<', $datafile;
        while (my $data = <$datafh>) {
            chomp($data);
            if ($data ne '') {
                push @datarec, $data;
            }
        }
        close $datafh;
    }
    return @datarec;
}

sub _update_threaddata {
    my ($threadid, @datarec) = @_;
    my $datafile = get_data_dir() . "/thread_$threadid.data";
    open my $datafh, '>', $datafile;
    flock $datafh, LOCK_EX;
    foreach my $rec (@datarec) {
        print {$datafh} "$rec\n";
    }
    flock $datafh, LOCK_UN;
    close $datafh;
    chmod 0766, $datafile;
}

sub _get_threadid {
    my $threadid = 0;
    my $threadidfile = get_data_dir() . "/threadid.data";
#    _logger("_get_threadid : threadidfile = $threadidfile");   # for debug
    if (-f $threadidfile) {
        open my $idfh, '<', $threadidfile;
        my $data = <$idfh>;
        chomp $data;
        if ($data ne '') {
            $threadid = $data;
        }
        close $idfh;
    }
#    _logger("_get_threadid : threadid = $threadid");   # for debug
    return $threadid;
}

sub _update_threadid {
    my $threadid = shift;
    my $threadidfile = get_data_dir() . "/threadid.data";
    open my $idfh, '>', $threadidfile;
    flock $idfh, LOCK_EX;
    print {$idfh} "$threadid\n";
    flock $idfh, LOCK_UN;
    close $idfh;
}

sub _get_update_items {
#    _logger("_get_update_items");   # for debug
    my $datafile = get_data_dir() . "/update.data";
    my @items = ();
    if (-f $datafile) {
        open my $infh, '<', $datafile;
        while (my $data = <$infh>) {
            chomp $data;
            if ($data ne '') {
                push @items, $data;
            }
        }
        close $infh;
    }
    return @items;
}

sub _update_update_items {
    my @items = @_;
    my $datafile = get_data_dir() . "/update.data";
    open my $outfh, '>', $datafile;
    flock $outfh, LOCK_EX;
    foreach my $data (@items) {
        print {$outfh} "$data\n";
    }
    flock $outfh, LOCK_UN;
    close $outfh;
    chmod 0766, $datafile;
}

sub _add_update {
    my $threadid = shift;
    my @items = _get_update_items();
    @items = grep { !/\A$threadid\z/ } @items;
    unshift @items, $threadid;
    my $item_num = get_list_number();
    if (scalar(@items) > $item_num) {
        @items = @items[0..$item_num];
    }
    _update_update_items(@items);
}

sub _delete_update {
    my $threadid = shift;
    my @items = _get_update_items();
    @items = grep { !/\A$threadid\z/ } @items;
    _update_update_items(@items);
}

# ----- blacklist functions -----
sub _get_blacklist {
    my @itemlist = ();
    my $blacklist = get_spam_dir() . "/blacklist.txt";
    if (-f $blacklist) {
        open my $bfh, '<', $blacklist;
        while (my $rec = <$bfh>) {
            chomp($rec);
            next if ($rec eq '');
            push @itemlist, $rec;
        }
        close $bfh;
    }
    return @itemlist;
}

sub _check_blacklist {
    my $text = shift;
    my @itemlist = _get_blacklist();
    foreach my $item (@itemlist) {
        if ($text =~ /$item/) { return 1; } # hit
    }
    return 0;
}

sub _write_spam {
    my $ipaddr = shift;
    my $body = shift;
    $body =~ s/,/enc_conma/g;
    $body =~ s/\r?\n/enc_crlf/g;
#    _logger("_write_spam - ipaddr:$ipaddr");   # for debug
    my $postdate = _get_datetime();
    my $spamfile = get_spam_dir() . "/spamdata.txt";
    open my $spamfh, '>>', $spamfile;
    print {$spamfh} "$ipaddr,$postdate,$body\n";
    close $spamfh;
    chmod 0766, $spamfile;
}

# ----- util functions -----

sub _pass_check {
    my ($device, $cgi) = @_;

    my $sid = '';
    if (get_pass() ne '') {
        my $sessionid = $cgi->cookie(get_cookie_name());

        my $uid = $ENV{'REMOTE_ADDR'};
        if ($device eq 'mobile') {
            $sessionid = $cgi->param('s');
            $uid = _get_uid();
            $sid = $sessionid;
        }

        if (defined $sessionid && $sessionid ne '') {
            my $sessionfile = get_session_dir() . "/$sessionid.txt";
            if (-f $sessionfile) {
                open my $sessionfh, '<', $sessionfile;
                my $data = <$sessionfh>;
                chomp($data);
                my ($sdevice, $suid) = split(/,/, $data);
                close $sessionfh;
                if (($device ne $sdevice) || ($uid ne $suid)) {
                    print "Location: ./pass.cgi", "\n\n";
                    exit;
                }
            }
            else {
                print "Location: ./pass.cgi", "\n\n";
                exit;
            }
        }
        else {
            print "Location: ./pass.cgi", "\n\n";
            exit;
        }
    }

    return $sid;
}

# 個体識別番号の取得
sub _get_uid {
    my $ua = $ENV{'HTTP_USER_AGENT'};
    my $uid = '';
    if ($ua =~ /\ADoCoMo/) {
        $uid = $ENV{'HTTP_X_DCMGUID'};
    }
    elsif ($ua =~ /\AUP.Browser|\AKDDI/) { # au
        $uid = $ENV{'HTTP_X_UP_SUBNO'};
    }
    elsif ($ua =~ /\AJ-PHONE|\AVodafone|\ASoftBank/) {
        $uid = $ENV{'HTTP_X_JPHONE_UID'};
    }

    return $uid;
}

sub _mailto {
    my ($subject, $from, $body, @addrlist) = @_;

    my $sendmail_path = get_sendmail_path();
    $subject = Encode::encode('MIME-Header-ISO_2022_JP', $subject);
    foreach my $mailaddr (@addrlist) {
        my $message = <<"END_MESSAGE";
From: $from
To: $mailaddr
Subject: $subject
Mime-Version: 1.0
Content-Type: text/plain; charset=iso-2022-jp
Content-Transfer-Encoding: 7bit

$body
END_MESSAGE

        Encode::from_to($message, 'utf8', '7bit-jis');

        open my $mailh, "| $sendmail_path -t -oi $mailaddr";
        print {$mailh} $message;
        close $mailh;
    }
}

# URLからコンテンツのタイトルと引用文を取得
sub _get_quote {
    my $url = shift;

    use LWP::Simple;
    my $content = LWP::Simple::get($url);

#    _logger("_get_quote - before content:$content");   # for debug
    # UTF-8に変換
    $content = _convert_utf8($content);
#    _logger("_get_quote - after content:$content");   # for debug

    my $quote = '';
    my $pattern = "<meta.*name=\"description\".*content=\"(.+)?\".*?>";
    if ($content =~ m/$pattern/i) {
        $quote = $1;
    }
#    _logger("_get_quote - quote:$quote");   # for debug

    $content =~ s/\r?\n//g;
    $pattern = "<title.*?>(.*)</title>";
    my $title = '';
    if($content =~ m/$pattern/i) {
        $title = $1;
    }

    return ($title, $quote);
}

# 文字エンコードが不明な文字列をUTF-8に変換
sub _convert_utf8 {
    my ($src) = @_;
    $src = decode('Guess', $src) unless (Encode::is_utf8($src));
    $src = Encode::encode_utf8($src);
    return $src;
}

sub _url_convert {
    my $str = shift;

    if ($str =~ m/http:\/\/www\.youtube\.com\/watch\?v=([-_a-zA-Z0-9]+).*/i) {
        my $vid = $1;
        $str =~ s/(http:\/\/www\.youtube\.com\/watch.*)/<iframe width="480" height="360" src="http:\/\/www.youtube.com\/embed\/$vid?rel=0" frameborder="0" allowfullscreen><\/iframe>/g;
    }
    elsif ($str =~ m/http:\/\/youtu\.be\/([-_a-zA-Z0-9]+)/i) {
        my $vid = $1;
        $str =~ s/(http:\/\/youtu\.be\/[-_a-zA-Z0-9]+)/<iframe width="480" height="360" src="http:\/\/www.youtube.com\/embed\/$vid?rel=0" frameborder="0" allowfullscreen><\/iframe>/g;
    }
    else {
        my $pattern = "s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+\$,%#]+";
        my $imgpattern = "s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+\$,%#]+[.](jpg|jpeg|gif|png)";
        $str =~ s/($pattern)/<a href="$1" target="_blank">$1<\/a>/ig;
        $str =~ s/>($imgpattern)</><img src="$1"><\/img></ig;
    }

    return $str;
}

sub _get_datetime {
    my ($lsec, $lmin, $lhour, $lday, $lmon, $lyear) = localtime(time);
    $lyear += 1900;
    $lmon++;
    if ($lmon < 10) { $lmon = '0' . $lmon; }
    if ($lday < 10) { $lday = '0' . $lday; }
    if ($lhour < 10) { $lhour = '0' . $lhour; }
    if ($lmin < 10) { $lmin = '0' . $lmin; }
    if ($lsec < 10) { $lsec = '0' . $lsec; }
    my $fmtdatetime = "$lyear/$lmon/$lday $lhour:$lmin:$lsec";
    return $fmtdatetime;
}

sub _logger {
    my $logtext = shift;
    my $logdate = _get_datetime();
    my $logfile = get_log_dir() . "/debug.log";
    open my $logfh, '>>', $logfile;
    print {$logfh} "$logdate,$logtext\n";
    close $logfh;
    chmod 0766, $logfile;
}

sub _access_log {
    my ($threadid, $device) = @_;

#    _logger("_access_log - threadid:$threadid");   # for debug
    my $logdate = _get_datetime();
    my $year = substr($logdate, 0, 4);
    my $month = substr($logdate, 5, 2);
    my $day = substr($logdate, 8, 2);

    my $ipaddr = $ENV{'REMOTE_ADDR'};
    my $language = $ENV{'HTTP_ACCEPT_LANGUAGE'};
    my $agent = $ENV{'HTTP_USER_AGENT'};
    my $uri = $ENV{'REQUEST_URI'};

    my $logfile = get_log_dir() . "/access_" . "$year$month$day.log";
#    _logger("_access_log - logfile:$logfile");   # for debug
    open my $logfh, '>>', $logfile;
    print {$logfh} "$threadid,$device,$logdate,$ipaddr,$language,$agent,$uri\n";
    close $logfh;
    chmod 0766, $logfile;
}

sub _error {
    my ($device) = @_;
    my $charset = 'utf-8';
    if ($device eq 'mobile') { 
        $charset = 'shift_jis';
    }
    my $title = '500 Internal Server Error';
    my $template = HTML::Template->new(filename => get_tmpl_dir() . '/error.tmpl');
    $template->param(TITLE => $title);
    $template->param(CHARSET => $charset);
    print "Status: 500 Internal Server Error\n";
    print "Content-Type: text/html\n\n", $template->output;
    exit;
}

sub _tag_invalidate {
    my $text = shift;
    $text =~ s/&/&amp;/g if defined($text);
    $text =~ s/"/&quot;/g if defined($text);
    $text =~ s/</&lt;/g if defined($text);
    $text =~ s/>/&gt;/g if defined($text);
    return $text;
}

1;
