#!/usr/bin/perl
#------------------------------------------------------------------------------
#    ThreadPlus, simply forum CGI.
#    Copyright (C) 2012,2013 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------
use strict;
use warnings;

use CGI;
use Encode;

require "config.cgi";
require "subs.cgi";

_output_sitemap();

exit;

sub _output_sitemap {

    my $siteurl = get_site_url();
    my $itemlist = <<"END_ITEM";
   <url>
    <loc>$siteurl</loc>
    <changefreq>daily</changefreq>
    <priority>0.8</priority>
   </url>
END_ITEM

    my $dir = get_data_dir() . "/*.data";
    my @files = <${dir}>;

    foreach my $filepath (@files) {
        my $threadid = '';
        my $pattern = ".*/thread_([0-9]+)[.]data";
        if ($filepath =~ m/$pattern/i) {
            $threadid = $1;
        }
        next if ($threadid eq '');

        my $itemurl = $siteurl . "bbs.cgi?a=view&amp;func=thread&amp;threadid=$threadid";
        $itemlist .= <<"END_ITEM";
   <url>
    <loc>$itemurl</loc>
    <changefreq>daily</changefreq>
    <priority>0.7</priority>
   </url>
END_ITEM
    }

    my $sitemap = <<"END_SITEMAP";
<?xml version="1.0" encoding="UTF-8"?>
  <urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
   $itemlist
  </urlset>
END_SITEMAP

    $sitemap =~ s/\$ITEMLIST\$/$itemlist/g;

    print "Content-Type: text/xml\n\n";
    print $sitemap;
}

