#!/usr/bin/perl
#------------------------------------------------------------------------------
#    ThreadPlus, simply forum CGI.
#    Copyright (C) 2012,2013 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------
use strict;
use warnings;

use CGI;
use Encode;

use HTML::Template;

require "config.cgi";
require "subs.cgi";

# ユーザーエージェントから携帯かどうかを判定
my $device = 'pc';
my $ua = $ENV{'HTTP_USER_AGENT'};
if (defined $ua && $ua =~ /\ADoCoMo|\AUP.Browser|\AKDDI|\AJ-PHONE|\AVodafone|\ASoftBank/) {
    $device = 'mobile';
}

my $cgi = CGI->new();

# パスワードが設定されてる場合はチェック
my $sid = _pass_check($device, $cgi);

_view_index();

exit;

sub _view_index {

#    _logger("_view_index - sid:$sid");   # for debug

    my @updateitems = _get_update_items();
    my @thread_data = ();
    foreach my $threadid (@updateitems) {
        my @datarecs = _get_threaddata($threadid);
        last if (!scalar(@datarecs));
        my ($id, $datetime, $subject, $username, $mailaddr, $body, $ipaddr) = split(/,/, $datarecs[0]);
        $subject  =~ s/enc_conma/,/g;
        my $number = scalar(@datarecs) - 1;
        my %row_data;
        $row_data{THREADID} = $threadid;
        $row_data{SUBJECT} = $subject;
        $row_data{NUMBER} = $number;
        $row_data{SID} = $sid;
        push @thread_data, \%row_data;
        last if (scalar(@thread_data) >= get_line_number());
    }

    my %accesslist = ();

    my $logdate = _get_datetime();
    my $year = substr($logdate, 0, 4);
    my $month = substr($logdate, 5, 2);
    my $day = substr($logdate, 8, 2);
    my $logfile = get_log_dir() . "/access_" . "$year$month$day.log";

    if (-f $logfile) {
        open my $infh, '<', $logfile;
        while (my $data = <$infh>) {
            chomp $data;
            next if ($data eq '');

            my ($threadid, $device, $accessdate, $ipaddr, $language, $agent) = split(/,/, $data);
            next if ($agent =~ m/bot/i);
            next if ($agent =~ m/spider/i);
            next if ($agent =~ m/Apache-HttpClient/i);
            next if ($agent =~ m/crawler/i);
            next if ($agent =~ m/Antenna/i);
            next if ($agent =~ m/Mediapartners/i);

            if (!(exists $accesslist{$threadid})) {
                $accesslist{$threadid} = 0;
            }
            $accesslist{$threadid} = $accesslist{$threadid} + 1;
        }
        close $infh;
    }
    
    # アクセスの多い順にソートして表示
    my @ranking_data = ();
    foreach (sort {$accesslist{$b} <=> $accesslist{$a}} keys %accesslist) {
        my $threadid = $_;
        my @datarecs = _get_threaddata($threadid);
        last if (!scalar(@datarecs));
        my ($id, $datetime, $subject, $username, $mailaddr, $body, $ipaddr) = split(/,/, $datarecs[0]);
        $subject  =~ s/enc_conma/,/g;
        my $number = scalar(@datarecs) - 1;
        my %row_data;
        $row_data{THREADID} = $threadid;
        $row_data{SUBJECT} = $subject;
        $row_data{NUMBER} = $number;
        $row_data{PV} = $accesslist{$_};
        $row_data{SID} = $sid;
        push @ranking_data, \%row_data;
        last if (scalar(@ranking_data) >= get_line_number());
    }

    my $template = HTML::Template->new(filename => get_tmpl_dir() . '/index.tmpl');

    $template->param(SITETITLE => get_site_title());
    $template->param(SUBTITLE => get_sub_title());
    $template->param(SITEURL => get_site_url());
    $template->param(THREAD_NUM => scalar(@thread_data));
    $template->param(THREAD_LIST => \@thread_data);
    $template->param(RANKING_NUM => scalar(@ranking_data));
    $template->param(RANKING_LIST => \@ranking_data);
    $template->param(SESSIONID => $sid);
    if ($device eq 'mobile') {
        $template->param(CHARSET => 'SHIFT_JIS');
    }
    else {
        $template->param(CHARSET => 'UTF-8');
    }

    my $pagesource = $template->output;
    if ($device eq 'mobile') {
        Encode::from_to($pagesource, 'utf8', 'shiftjis'); # シフトJISに変換
    }
    print "Content-Type: text/html\n\n", $pagesource;
}

