#!/usr/bin/perl
#------------------------------------------------------------------------------
#    ThreadPlus, simply forum CGI.
#    Copyright (C) 2012 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------
use strict;
use warnings;

use CGI;
use Encode;

use HTML::Template;
use Time::Local;

require "config.cgi";
require "subs.cgi";

_output_rss();

exit;

sub _output_rss {
    my @updateitems = _get_update_items();

    my $sitetitle = get_site_title();
    my $siteurl = get_site_url();
    my $pubdate = _local_datetime();
    my $itemlist = '';

    my $count = 0;
    foreach my $threadid (@updateitems) {
        last if ($count >= get_line_number());
        my @datarecs = _get_threaddata($threadid);
        last if (!scalar(@datarecs));
        my ($id, $datetime, $subject, $username, $mailaddr, $body, $ipaddr) = split(/,/, $datarecs[0]);
        $subject  =~ s/enc_conma/,/g;
        $mailaddr =~ s/enc_conma/,/g;
        $username =~ s/enc_conma/,/g;
        $body     =~ s/enc_conma/,/g;
        $body     =~ s/enc_crlf/<br \/>/g;

        my $pattern = "s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+";
        $body =~ s/($pattern)/<a href="$1" target="_blank">$1<\/a>/ig;
        my $picpattern = "s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+[.](jpg|jpeg|gif|png)";
        $body =~ s/>($picpattern)</><img src="$1"><\/img></ig;

        $subject = _tag_invalidate($subject);

        if ($username eq '') {
            $username = "[" . get_anonymous() . "]";
        }
        $body .= "<p>Posted by <b>$username</b> at $datetime</p>";

        my $number = scalar(@datarecs) - 1;
        $body .= "<p><a href=\"" . $siteurl . "bbs.cgi?a=view&func=thread&threadid=$threadid#comment\">$number件のコメント</a></p>";
        $body = _tag_invalidate($body);

        my $itemurl = $siteurl . "bbs.cgi?a=view&amp;func=thread&amp;threadid=$threadid";
        my $rfc822 = _format_rfc822($datetime);

        $itemlist .= <<"END_ITEM";
  <item>
    <title>$subject</title>
    <description>$body</description>
    <link>$itemurl</link>
    <pubDate>$rfc822</pubDate>
  </item>
END_ITEM

        $count++;
    }

    my $rss2 = <<"END_RSS2";
<?xml version="1.0" encoding="UTF-8" ?>
<rss version="2.0">
 <channel>
  <title>$sitetitle</title>
  <link>$siteurl</link>
  <description></description>
  <lastBuildDate>$pubdate</lastBuildDate>
  <pubDate>$pubdate</pubDate>
  <docs>http://blogs.law.harvard.edu/tech/rss</docs>
  <generator>ThreadPlus 1.1</generator>
$itemlist
 </channel>
</rss>
END_RSS2

    print "Content-Type: text/xml\n\n";
    print $rss2;
}

# 日時を変換 YYYY/MM/DD HH:NN:SS -> RFC 822
sub _format_rfc822 {
    my $ymdhms = shift;

    my ($year, $month, $day) = (substr($ymdhms, 0, 4), substr($ymdhms, 5, 2), substr($ymdhms, 8, 2));
    my ($hour, $minute, $second) = (substr($ymdhms, 11, 2), substr($ymdhms, 14, 2), substr($ymdhms, 17, 2));

    my $formated_date = '';
    my @weeks = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
    my @months = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
    my ($wday) = (localtime(timelocal(0, 0, 0, $day, $month - 1, $year - 1900)))[6];  # 曜日を求める
    $wday = $weeks[$wday];
    my $mon = $months[$month - 1];
    $formated_date = "$wday, $day $mon $year $hour:$minute:$second +0900";

    return $formated_date;
}

# ローカル日時の取得
sub _local_datetime {

    my ($sec, $min, $hour, $mday, $mon, $year) = (localtime(time))[0..5];
    $mon++;
    $year += 1900;

    if ($sec < 10)  { $sec = '0' . $sec; }
    if ($min < 10)  { $min = '0' . $min; }
    if ($hour < 10) { $hour = '0' . $hour; }
    if ($mday < 10) { $mday = '0' . $mday; }
    if ($mon < 10)  { $mon = '0' . $mon; }

    my @weeks = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
    my @months = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
    my ($wday) = (localtime(timelocal(0, 0, 0, $mday, $mon - 1, $year - 1900)))[6];   # 曜日を求める
    $wday = $weeks[$wday];
    $mon = $months[$mon - 1];
    my $formated_date = "$wday, $mday $mon $year $hour:$min:$sec +0900";

    return $formated_date;
}

