#!/usr/bin/perl
#------------------------------------------------------------------------------
#    ThreadPlus, simply forum CGI.
#    Copyright (C) 2012 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------
use strict;
use warnings;

use CGI;
use Encode;

use HTML::Template;

require "config.cgi";
require "subs.cgi";

# ユーザーエージェントから携帯かどうかを判定
my $ismobile = 0;
my $ua = $ENV{'HTTP_USER_AGENT'};
if ($ua =~ /\ADoCoMo|\AUP.Browser|\AKDDI|\AJ-PHONE|\AVodafone|\ASoftBank/) {
    $ismobile = 1;
}
#$ismobile = 0;   # for debug

my @updateitems = _get_update_items();
_view_index(@updateitems);

exit;

sub _view_index {
    my @updateitems = @_;

    my @thread_data = ();
    foreach my $threadid (@updateitems) {
        my @datarecs = _get_threaddata($threadid);
        last if (!scalar(@datarecs));
        my ($id, $datetime, $subject, $username, $mailaddr, $body, $ipaddr) = split(/,/, $datarecs[0]);
        $subject  =~ s/enc_conma/,/g;
        my $number = scalar(@datarecs) - 1;
        my %row_data;
        $row_data{THREADID} = $threadid;
        $row_data{SUBJECT} = $subject;
        $row_data{NUMBER} = $number;
        push @thread_data, \%row_data;
        last if (scalar(@thread_data) >= get_line_number());
    }

    my $template = '';
    if ($ismobile) {
        $template = HTML::Template->new(filename => get_tmpl_dir() . '/index_m.tmpl');
    }
    else {
        $template = HTML::Template->new(filename => get_tmpl_dir() . '/index.tmpl');
    }

    $template->param(SITETITLE => get_site_title());
    $template->param(SUBTITLE => get_sub_title());
    $template->param(SITEURL => get_site_url());
    $template->param(THREAD_NUM => scalar(@thread_data));
    $template->param(THREAD_LIST => \@thread_data);

    my $pagesource = $template->output;
    if ($ismobile) {
        Encode::from_to($pagesource, 'utf8', 'shiftjis'); # シフトJISに変換
    }
    print "Content-Type: text/html\n\n", $pagesource;
}

