<?php
/*----------------------------------------------------

   TwDatabase  Wikiѥǡ١ץ饰 ݴ 饹

    ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.


   Public᥽å
   饹ϰʲΥ᥽åɤɬפ


     initialize()     ǡ١νơ֥

     self_check()     ǡ١μʿ

     load(&$wikidata_object,$wikiname,$namespace,$mode)
                      оݥǡ

     load_header(&$wikidata_object,$wikiname,$namespace,$mode)
                      оݥǡإåΤߥ

     check_exist($wikiname,$namespace)
                      оݥڡ¸ߤƤ뤫å

     save(&$page_object) 
                      Ϥ줿ǡ¸

     delete_page(&$page_object)
                      оݥڡ

     get_recent_change_list($number)
                      ǶιꥹȤ
             
     add_recent_change_list($pagename,$namespace,$timestamp=0)
                      ǶιꥹȤɲä

     gettime_recent_change()
                      ǤǶιUNIXॹפ

     get_page_list($namespace="",$search_type="target_level_only")
                      о֤̾ΥڡꥹȤ

     get_namespace_list($namespace="",$search_type="target_level_only")
                      оְ̾ʲѤ֥̾ꥹȤ

     get_page_tree_list($namespace="",$search_level="-1")
                      ڡǡPageTreeStructure֥ȤΥĥ꡼¤

     get_history_list($pagename,$namespace)
                     оݥڡꥹȡtimeͤΥꥹȤ

     load_history_data(&$wikidata_object,$wikiname,$namespace,$timestamp)
                      оǡ

     grep($word,$namespace="",$search_type="search")
                      оʸʸ

     make_namespace(&$namespace_data_object)
                      ֤̾

     delete_namespace($namespace)
                      ֤̾

     load_namespace(&$namespace_data_object,$namespace)
                     о֤̾ξNamespace饹֥Ȥɤ߹

     check_exist_namespace($namespace)
                     о֤̾¸ߤƤ뤫å



   private᥽å

     check_save(&$save_data_obj)
                      оݥǡֲǽå

     get_child_list( &$tree_obj,$search_level )
                      get_page_tree_listѺƵؿ
     
------------------------------------------------------*/

require_once "Wiki/PageData.php";
require_once "Wiki/NamespaceData.php";
require_once "Wiki/WikiCommonLib.php";

class TwDatabase
{

var $history_flag;
var $config;

/*----------------------------------------------------

  쥯饹ۥ󥹥ȥ饯

------------------------------------------------------*/
function TwDatabase( &$config )
{
	$this->config      = &$config;
	$this->history_flag= $config->data['history_flag'];
}
//-----------------------------------------------------

/*----------------------------------------------------

 initialize()  ǡ١νơ֥
   return true or false

------------------------------------------------------*/
function initialize()
{
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

 self_check()  ǡ١μʿ
  return  error_code or ok

------------------------------------------------------*/
function self_check()
{
	return "class_error";
}
//-----------------------------------------------------


/*----------------------------------------------------

  load(&$wikidata_object,$wikiname,$namespace,$mode)  оݥǡ
    
    $wikidata_object : ɤ߹PageData֥
    $wikiname   wikiname
    $namespace  ̾
    $mode       ư⡼ɤλ
       search = ֤̾ޤƥʥǥեȡ
       target_level_only = о֤̾Τߥ

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load(&$wikidata_object,$wikiname,$namespace,$mode="search")
{
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  load_header(&$wikidata_object,$wikiname,$namespace,$mode)  оݥǡإåΤߥ
    
    $wikidata_object : ɤ߹WikiData֥
    $wikiname   wikiname
    $namespace  ̾
    $mode       ư⡼ɤλ
       search = ֤̾ޤƥʥǥեȡ
       target_level_only = о֤̾Τߥ

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_header(&$wikidata_object,$wikiname,$namespace,$mode="search")
{
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

   check_save(&$save_data_obj)  оݥǡֲǽå

   $save_data  WikiData֥
   return      "ok"       = ֲǽ  
                 "modifyed" = ̤οʹ֤˽줿

------------------------------------------------------*/
function check_save(&$save_data_obj)
{
	$target_data_object = new PageData();
	if(! $this->load_header($target_data_object,$save_data_obj->data['name'],$save_data_obj->data['name_space'],"target_level_only")){
		return "ok";
	}
	
	if($target_data_object->data['last_modify'] != "" && 
	   $save_data_obj->data['last_modify'] != $target_data_object->data['last_modify'])
	{
		return "modifyed";
	}
	
	return "ok";
}
//-----------------------------------------------------


/*----------------------------------------------------

  check_exist($wikiname,$namespace)
       оݥڡ¸ߤƤ뤫å
      
  return : "hit" = ¸ߤ
           "not_found" = ¸ߤʤ
           "hit_upper_namespace" = ̤֤̾¸ߤƤ

------------------------------------------------------*/
function check_exist($wikiname,$namespace)
{
	return "not_found";
}
//-----------------------------------------------------


/*----------------------------------------------------

   save(&$page_object)  Ϥ줿ǡ¸
   
   $page_object  ¸PageData֥
   return       "ok" = 
                  "modifyed" = ̤οʹ֤˽줿
                  "error"    = ͽ̥顼

------------------------------------------------------*/
function save(&$page_object)
{
	return "error";
}
//-----------------------------------------------------


/*----------------------------------------------------

  delete_page(&$page_object)
       оݥڡ
      
  return : "ok" = 
           "not_found" = ¸ߤʤ
           "modifyed"  = ̤οʹ֤˽줿
           "error"     = ͽ̥顼

------------------------------------------------------*/
function delete_page(&$page_object)
{
	return "error";
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_recent_change_list($number)  ǶιꥹȤ
  
  $number ɬפʥꥹȤο
  return եΥǡΣ
  
  $data[n]['pagename']  = ڡ̾
  $data[n]['namespace'] = ڡ¸ߤ̾
  $data[n]['timestamp'] = UNIXॹ

------------------------------------------------------*/
function get_recent_change_list($number)
{
	return array();
}
//-----------------------------------------------------

/*----------------------------------------------------

  add_recent_change_list($pagename,$namespace,$timestamp=0)
     ǶιꥹȤɲä

  return  "ok" = 
            "error" = 

------------------------------------------------------*/
function add_recent_change_list($pagename,$namespace,$timestamp=0)
{
	return "error";
}
//-----------------------------------------------------

/*----------------------------------------------------

  gettime_recent_change() ǤǶιUNIXॹפ

  return UNIXॹ

------------------------------------------------------*/
function gettime_recent_change()
{
	return "";
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_page_list($namespace="",$search_type="search")
     о֤̾ΥڡꥹȤ

   $namespace  оݤˤʤ̾
   $search_type  õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ
       search_index = ǥåڡΤߡĲLV򥵡

   return $keysort줿PageData֥Ȥäϥå

------------------------------------------------------*/
function get_page_list($namespace="",$search_type="search")
{
	return array();
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_namespace_list($namespace="",$search_type="search")
     оְ̾ʲѤ֥̾ꥹȤ

   $namespace  оݤˤʤ̾
   $search_type  õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ
       search_index = ǥåڡΤߡĲLV򥵡

   return sort줿֤̾ä

------------------------------------------------------*/
function get_namespace_list($namespace="",$search_type="search")
{
	return array();
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_page_tree_list($namespace="",$search_level="-1")
     ڡǡPageTreeStructure֥ȤΥĥ꡼¤

------------------------------------------------------*/
function &get_page_tree_list($namespace="",$search_level="-1")
{
	$root_data = new PageTreeStructure();
	$root_data->is_namespace = true;
	
	if( !$this->load_namespace($root_data->namespace_data,$namespace) )
	{
		return array();
	}
	
	$root_data->children_list = &$this->get_child_list( $root_data,$search_level );
	
	return $root_data;
}

//////////////////////////////////////////
// ҥΡɤ֤
function &get_child_list( &$tree_obj,$search_level )
{
	if( $search_level == 0 || !$tree_obj->is_namespace)
	{
		return array();
	}
	
	$children_list  = array();
	$order_count    = 0;

	$page_data_list = $this->get_page_list( $tree_obj->namespace_data->data['name'],"target_level_only");
	reset($page_data_list);
	while(list($key_name,$value) = each($page_data_list))
	{
		$children_list[$order_count] = new PageTreeStructure();
		$children_list[$order_count]->order    = $order_count;
		$children_list[$order_count]->parent_ref = &$tree_obj;
		$children_list[$order_count]->pagedata = $value;
		$children_list[$order_count]->depth    = $tree_obj->depth + 1;
		$order_count++;
	}
	
	$namespace_list = $this->get_namespace_list($tree_obj->namespace_data->data['name'],"target_level_only");
	for( $i=0;$i<count($namespace_list);$i++ )
	{
		$children_list[$order_count] = new PageTreeStructure();
		$children_list[$order_count]->order    = $order_count;
		$children_list[$order_count]->parent_ref = &$tree_obj;
		$children_list[$order_count]->depth      = $tree_obj->depth + 1;

		if( $this->load_namespace($children_list[$order_count]->namespace_data,$namespace_list[$i]) )
		{
			$children_list[$order_count]->is_namespace    = true;
			$children_list[$order_count]->children_list   = &$this->get_child_list( $children_list[$order_count],$search_level-1 );
		}
		$order_count++;

	}
	
	$tree_obj->children_count = $order_count;
	return $children_list;
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_history_list($pagename,$namespace)
    оݥڡꥹȡtimeͤΥꥹȤ

  $wikiname   wikiname
  $namespace  ̾
  return      array timeͤΥꥹ

------------------------------------------------------*/
function get_history_list($pagename,$namespace)
{
	return array();
}
//-----------------------------------------------------


/*----------------------------------------------------

  load_history_data(&$wikidata_object,$wikiname,$namespace,$timestamp)  оǡ
    
    $wikidata_object : ɤ߹PageData֥
    $wikiname   wikiname
    $namespace  ̾
    $target_time time
    
   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_history_data(&$wikidata_object,$wikiname,$namespace,$timestamp)
{
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  grep($word,$namespace="",$search_type="search") оʸʸ

    $word        
    $namespace   ̾֡ʸоݤꤹ
    $search_type õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ

   return        array("pagename"=>ڡ̾,"namespace"=>̾,
                         "number"=>Կ,"text"=>ʸեƥȤΰ)
                   
                   Ȥ

------------------------------------------------------*/
function grep($word,$namespace="",$search_type="search")
{
	return array();
}
//-----------------------------------------------------

/*----------------------------------------------------

  make_namespace(&$namespace_data_object) ֤̾

   $namespace_data_object NamespaceData饹֥
   
   return       true  : 
                  false : 

------------------------------------------------------*/
function make_namespace(&$namespace_data_object)
{
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

  delete_namespace($namespace) ֤̾

   $namespace о̾
   
   return       true  : 
                  false : 

------------------------------------------------------*/
function delete_namespace($namespace)
{
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  load_namespace(&$namespace_data_object,$namespace)
    о֤̾ξNamespace饹֥Ȥɤ߹

    $namespace_data_object : ɤ߹Namespace֥
    $namespace  ̾

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_namespace(&$namespace_data_object,$namespace)
{
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  check_exist_namespace($namespace)
       о֤̾¸ߤƤ뤫å
      
  return : "hit" = ¸ߤ
           "not_found" = ¸ߤʤ

------------------------------------------------------*/
function check_exist_namespace($namespace)
{
	return "not_found";
}
//-----------------------------------------------------


}
//-----------------------------------------------------



/*----------------------------------------------------

  ĥ꡼ꥹȥǡ饹

------------------------------------------------------*/
class PageTreeStructure
{

var $parent_ref;
var $is_namespace;
var $pagedata;
var $namespace_data;
var $children_list;
var $depth;
var $order;
var $children_count;

//////////////////////////////////////////
// 󥹥ȥ饯
function PageTreeStructure()
{
	$this->clear();
}

//////////////////////////////////////////
// 
function clear()
{
	$this->parent_ref     = NULL;
	$this->children_list  = array();
	$this->is_namespace   = false;
	$this->pagedata       = new PageData();
	$this->namespace_data = new NamespaceData();
	$this->depth          = 0;
	$this->order          = 0;
	$this->children_count = 0;
}

}
//-----------------------------------------------------


?>
