<?php
/*----------------------------------------------------

  FileControlLibClass For Common
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

class FileControlLib
{

/*----------------------------------------------------

  make_dir($target_dir,$permission_code)  оݥǥ쥯ȥ

------------------------------------------------------*/
function make_dir($target_dir,$permission_code)
{
	if(!is_dir($target_dir)){
	
		$dir_array = split("/",preg_replace("/^\.?\//","",$target_dir));
		$temp_dir_name = "./";
		
		for($i=0;$i<count($dir_array);$i++){
			$temp_dir_name .= $dir_array[$i];
			if(!is_dir($temp_dir_name)){
				if(!mkdir($temp_dir_name,$permission_code)){return false;}
			}
			$temp_dir_name .= "/";
		}
	}
	return true;

}
//-----------------------------------------------------


/*----------------------------------------------------

 delete_dir($target_dir)  оݥǥ쥯ȥե뤴Ⱥ

------------------------------------------------------*/
function delete_dir($target_dir)
{
	if(is_dir($target_dir))
	{
		if($dir_handle = opendir($target_dir))
		{
			while( false != ($filename = readdir($dir_handle)) )
			{
				if($filename != "." && $filename != "..")
				{
					$full_filename = $target_dir ."/" . $filename;
					if(is_dir($full_filename))
					{
						if( !FileControlLib::delete_dir($full_filename) )
						{
							return false;
						}
					}
					else
					{
						if( !unlink($full_filename) )
						{
							return false;
						}
					}
				}
				
			}
		}
		return rmdir( $target_dir );
	}
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

  search_dir($target_dir,$search_level=-1)
    ǥ쥯ȥ򸡺ƥեꥹȤ֤

------------------------------------------------------*/
function search_dir($target_dir,$search_level=-1)
{
	$file_list = array();
	if(is_dir($target_dir)){
		if($dir_handle = opendir($target_dir)){
			while(false != ($filename = readdir($dir_handle))){
				if($filename != "." && $filename != ".."){
					$full_filename = $target_dir ."/" . $filename;
					if(is_dir($full_filename)){
						if($search_level != 0){
							$file_list = array_merge($file_list,FileControlLib::search_dir($full_filename,$search_level-1));
						}
					}
					else{
						$file_list[] = $full_filename;
					}
				}
			}
		closedir($dir_handle);
		}
	}
	return $file_list;
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_dir_list($target_dir,$search_level=-1)
    ǥ쥯ȥ򸡺ƥǥ쥯ȥꥹȤ֤

------------------------------------------------------*/
function get_dir_list($target_dir,$search_level=-1)
{
	$file_list = array();
	if(is_dir($target_dir)){
		if($dir_handle = opendir($target_dir)){
			while(false != ($filename = readdir($dir_handle))){
				if($filename != "." && $filename != ".."){
					$full_filename = $target_dir ."/" . $filename;
					if(is_dir($full_filename)){
						$file_list[] = $full_filename;
						if($search_level != 0){
							$file_list = array_merge($file_list,FileControlLib::get_dir_list($full_filename,$search_level-1));
						}
					}
				}
			}
		closedir($dir_handle);
		}
	}
	return $file_list;
}
//-----------------------------------------------------


/*----------------------------------------------------

  clear_target_dir($target_dir,$sub_dir_flag)
    ǥ쥯ȥ򸡺ƥǥ쥯ȥե륵֥ǥ쥯ȥꤴȺ

  return true or false

------------------------------------------------------*/
function clear_target_dir($target_dir,$sub_dir_flag=0)
{
	if(is_dir($target_dir)){
		if($dir_handle = opendir($target_dir)){
			while(false != ($filename = readdir($dir_handle))){
				if($filename != "." && $filename != ".."){
					$full_filename = $target_dir ."/" . $filename;
					if(is_dir($full_filename)){
						if(!FileControlLib::clear_target_dir($full_filename,1)){
							return false;
						}
					}
					else{
						if(!unlink($full_filename)){
							return false;
						}
					}
				}
			}
		closedir($dir_handle);
		if($sub_dir_flag != 0){
			if(!rmdir($target_dir)){
				return false;
			}
		}
		return true;
		}
	}
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  create_file( $filename, $stream )
    оݥե$stream񤭹
     оݥե¸ߥǥ쥯ȥФ񤭹߸ɬס
  
  $filename ե̾
  $stream   񤭹ǡȥ꡼
  
  return true or false

------------------------------------------------------*/
function create_file( $filename, $stream )
{
	if( !file_exists($filename) )
	{
		if($fp = fopen($filename,"w"))
		{
			if( !flock($fp,LOCK_EX) )
			{
				fclose($fp);
				return false;
			}
			
			if( fwrite($fp,$stream) )
			{
				flock($fp,LOCK_UN);
				fclose($fp);
				return true;
			}
			flock($fp,LOCK_UN);
			fclose($fp);
		}
	}
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  load_target_file( $filename, &$stream )
    оݥե$streamɤ߹
  
  $filename ե̾
  $stream   ɹǡȥ꡼
  
  return true or false

------------------------------------------------------*/
function load_target_file( $filename, &$stream  )
{
	if($fp = fopen($filename,"r"))
	{
		$stream = fread( $fp,filesize($filename) );
		return true;
	}
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

  target_file_update( $filename, $stream )
    оݥե$streamǥåץǡ
     оݥե¸ߥǥ쥯ȥФ񤭹߸ɬס
  
  $filename ե̾
  $stream   񤭹ǡȥ꡼
  
  return true or false

------------------------------------------------------*/
function target_file_update( $filename, $stream )
{
	if( $fp = fopen($filename .".tmp","w") )
	{
		if( !flock($fp,LOCK_EX) ){return false;}
		
		if( !fwrite($fp,$stream) )
		{
			flock($fp,LOCK_UN);
			fclose($fp);
			return false;
		}
		
		flock($fp,LOCK_UN);
		fclose($fp);
		for($i=0;$i<3;$i++)
		{
			if(copy($filename .".tmp",$filename))
			{
				unlink($filename .".tmp");
				return true;
			}
		}
	}
	return false;
}
//-----------------------------------------------------


}
//-----------------------------------------------------
?>
