--
--
--
drop database thread_wiki;
create database thread_wiki;

\c thread_wiki

--print "name_space";
create table name_space (
  id		serial			primary key,
  name		  varchar(255),
  parent_id   integer,
  tw_owner    varchar(255),
  tw_group    varchar(255),
  last_modify integer,
  full_name   varchar(255),
  update	  timestamp,

  CONSTRAINT ns_parent_id_fk FOREIGN KEY(parent_id)
    REFERENCES name_space(id)
	ON DELETE CASCADE
	ON UPDATE CASCADE
);

--print "page";
create table page (
  id			serial			primary key,
  name			varchar(255),
  name_space	integer,
  tw_owner		varchar(255),
  tw_group		varchar(255),
  last_modify   integer,
  body  		text,
  update		timestamp,

  CONSTRAINT pa_name_space_fk FOREIGN KEY(name_space)
    REFERENCES name_space(id)
    ON DELETE CASCADE
    ON UPDATE CASCADE
);

--print "history_page";
create table history_page (
) inherits (page);

--print "user_type";
create table user_type (
  name	varchar(255) primary key
);


--print "permission";
create table permission (
  page_id		integer,
  permit_action varchar(255),
  user_type		varchar(255),

/*
  CONSTRAINT pe_page_id_fk FOREIGN KEY(page_id)
    REFERENCES page(id)
    ON DELETE CASCADE
    ON UPDATE CASCADE
  ,
*/
  CONSTRAINT pe_user_type_fk FOREIGN KEY(user_type)
    REFERENCES user_type(name)
    ON DELETE CASCADE
    ON UPDATE CASCADE
);

--print "namespace_permission";
create table namespace_permission (
  namespace_id  integer,
  permit_action varchar(255),
  user_type		varchar(255),

  CONSTRAINT nsp_namespace_id_fk FOREIGN KEY(namespace_id)
    REFERENCES name_space(id)
    ON DELETE CASCADE
    ON UPDATE CASCADE
  ,
  CONSTRAINT nsp_user_type_fk FOREIGN KEY(user_type)
    REFERENCES user_type(name)
    ON DELETE CASCADE
    ON UPDATE CASCADE
);


grant all on page to www;
grant all on history_page to www;
grant all on name_space to www;
grant all on user_type to www;
grant all on permission to www;
grant all on namespace_permission to www;
grant all on page_id_seq to www;
grant all on name_space_id_seq to www;

--
-- insert area
--
insert into name_space (name, full_name, update)
values('', '', CURRENT_TIMESTAMP);

insert into user_type (name)
values('login_user');
insert into user_type (name)
values('guest_user');
insert into user_type (name)
values('group');

insert into namespace_permission(namespace_id, permit_action, user_type)
values(1,'read', 'login_user');
insert into namespace_permission(namespace_id, permit_action, user_type)
values(1,'write','login_user');
insert into namespace_permission(namespace_id, permit_action, user_type)
values(1,'plugin','login_user');
insert into namespace_permission(namespace_id, permit_action, user_type)
values(1,'read','guest_user');
insert into namespace_permission(namespace_id, permit_action, user_type)
values(1,'read','group');
