<?php
/*----------------------------------------------------

  Diary.plugin.phpThreadWikiPlugin
   Copyright(C) 2004 by FLATz Co , LTd.
$Header: /home/cvsroot/thread_wiki/plugin/Diary.plugin.php,v 1.5 2004/05/26 07:45:32 nasu Exp $
  
  Release note
  
  ThreadWiki's Support
    thread_wiki@flatz.jp
    http://wiki.flatz.jp
  
         Ρޥ롦POST
  ǽ       ơɽԤ
  ƤӽФ #Diary(MODE,NAMESPACE,NUM);
  
               MODE  ư⡼ɻʾάFORMɽ
                (form, list, recent, calendar)
               NAMESPACE : 򰷤֤̾λ
               NUM : ɽ(MODEˤäƤϻꤷƤ̵ΤΤ)
               
------------------------------------------------------*/
require_once("Wiki/PluginBase.php");
require_once( 'Smarty/Smarty.class.php' );

class Diary extends PluginBase
{

var $html;      // Ѵ줿HTML
var $smarty;    // Smarty

var $tpl_form;    // եƥץ졼
var $tpl_page;    // ɽƥץ졼
var $tpl_list;    // ꥹȥƥץ졼
var $tpl_article; // ƥץ졼

/*----------------------------------------------------

  Diary(&$core,&$config,&$wiki_db)󥹥ȥ饯

------------------------------------------------------*/
function Diary(&$core,&$config,&$wiki_db)
{
	parent::PluginBase($core,$config,$wiki_db);

    $this->smarty               = new Smarty();
    $this->smarty->template_dir = $config->get('resource_dir') . "/diary/";

	$this->tpl_form    = "form.tpl";
	$this->tpl_page    = "page.tpl";
	$this->tpl_list    = "list.tpl";
	$this->tpl_article = "article.tpl";

	$this->html     = "";
}
//-----------------------------------------------------

/*----------------------------------------------------

  public runtime_function(
    $line_number
    &$row_line_array
    $argument_array
    &$page_data
  ) : String HTML

------------------------------------------------------*/
function runtime_function(
  $line_number, &$row_line_array, $argument_array, &$page_data
){
	//
	//  & 
	//
	switch(strtolower($argument_array[0])){
	case "calendar":
		$ym = date("Ym");
		if(isset($argument_array[1]))
			$ns = trim($argument_array[1], " /");
		$result = $this->read_calendar($ym, $ns);
		break;
	case "list":
		$ns = "";
		if(isset($argument_array[1]))
			$ns = trim($argument_array[1], " /");
		$num = -1;
		if($argument_array[2] > 0)
			$num = $argument_array[2];
		$result = $this->read_list($num, $ns);
		break;
	case "recent":
		$ns = "";
		if(isset($argument_array[1]))
			$ns = trim($argument_array[1], " /");
		$num = -1;
		if($argument_array[2] > 0)
			$num = $argument_array[2];
		$result = $this->read_recent($num, $ns);
		break;
	case "form":
	default:
		$ns = "";
		if(isset($argument_array[1]))
			$ns = trim($argument_array[1], " /");
		$result = $this->read_form($ns, $page_data->data['name'], $page_data->data['name_space']);
		break;
	}

	//
	// 
	//

	if(!$result){
		return "Runtime Error!\n";
	}

	return $this->html;
}
//-----------------------------------------------------

/*----------------------------------------------------

  post_handler_function( $page_data, &$post_data_array )

------------------------------------------------------*/
function post_handler_function( $page_data, $post_data_array ){
	// POSTǡΥå
	if($post_data_array['name_space'] == ""){
	}
	if($post_data_array['body'] == ""){
	}

	// ȥ(ڡ̾)μ
	$title = sprintf("%04d-%02d-%02d",
	           $post_data_array['year'],
	           $post_data_array['month'],
	           $post_data_array['day']
	         );
	if(!preg_match("/^\d{4}-\d{2}-\d{2}$/", $title)){
		$title = date("Y-m-d");
	}

	$this->smarty->assign('TITLE', $post_data_array['pg']);
	$this->smarty->assign('BODY', $post_data_array['body']);
	$body .= $this->smarty->fetch( $this->tpl_article );

	// ǡ
	$result = $this->write_page($post_data_array['ns'], $title, $body);
	if($result){
		//$post_data_array['pg'] = $title;
		return "ok";
	}
	else{
		return "error";
	}
	// return "modifyed" ɤޤ
}
//-----------------------------------------------------

/*----------------------------------------------------

  private read_recent_list (
    in $num : Integer ɤ߹൭ο
    in $namespace : String
  ) : Bool
  ǿɤ߹

------------------------------------------------------*/
function read_list( $num, $namespace ){
	$html = "";
	$list = $this->wiki_db->get_recent_change_list($num, $namespace);

	// ֥̾ڡϤƤʬٵ
	$noname_cnt = 0;
	foreach($list as $row){
		if($row['pagename']==""){
			$noname_cnt++;
		}
	}
	if(!empty($noname_cnt)){
		$list = $this->wiki_db->get_recent_change_list($num+$noname_cnt, $namespace);
	}

	if(!is_array($list))
		$list = array();
	foreach($list as $row){
		if($row['pagename']=="")
			continue;
		$wiki_link = WikiCommonLib::make_wikiname_html($row['pagename'],$row);

		$this->smarty->assign('LINK', $wiki_link);

		// եHTMLɤ߹
		$this->html .= $this->smarty->fetch( $this->tpl_list );
	}
	$this->html .= $html;
	
	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private read_recent (
    in $num : Integer ɤ߹൭ο
    in $namespace : String
  ) : Bool
  ǿɤ߹

------------------------------------------------------*/
function read_recent( $num, $namespace ){
	//롼к
	static $already_included_page = array();
	if($already_included_page[$namespace]) {
		$this->html = "Error: a loop will arise!<br>";
		return true;
	}
	else {
		$already_included_page[$namespace]= true;
	}

	// ǿΥꥹɤ߹
	$list = $this->wiki_db->get_recent_change_list($num, $namespace);

	// ֥̾ڡϤƤʬٵ
	$noname_cnt = 0;
	foreach($list as $row){
		if($row['pagename']==""){
			$noname_cnt++;
		}
	}
	if(!empty($noname_cnt)){
		$list = $this->wiki_db->get_recent_change_list($num+$noname_cnt, $namespace);
	}

	// ο֤
	foreach($list as $row){
		if($row['pagename']=="")
			continue;
		$this->read_page($namespace, $row['pagename']);
	}

	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private read_page (
    in $namespace : String
    in $pagename  : String
  ) : Bool
  ǡɤ߹

------------------------------------------------------*/
function read_page( $namespace, $pagename ) {
	// ֤̾ȥڡ̾ǡɤ߹
	$request = array(
	  "pg" => $pagename,
	  "ns" => $namespace
	);
	$page_data = new PageData;
	if($this->wiki_db->load(
	     $page_data, $pagename, $namespace, "target_level_only"
	   )
	){
		// #Comment()ڡǰ褦ѹ
		/*
		  򤷤ʤ#Comment()ID
		*/
		for($cnt=0;$cnt<count($page_data->data['body']);$cnt++){
			if( preg_match(
			      "/^#Comment\(([^,]*),?([^,]*),?([^)]*)\)/i",
			      $page_data->data['body'][$cnt],
			      $matches
			    )
			){
				// ܤ#CommentʬΤIDꥻåȽԤ褦ˤ
				$page_data->data['body'][$cnt] = "#Comment({$matches[1]},{$matches[2]},-1);";
				break;
			}
		}

		// HTMLѿ
    	$main  = join( "\n",
		  $this->core->display_manager->wiki_renderer->process($page_data)
		);

		$wiki_data = array(
		  "pagename"  => $page_data->data['name'],
		  "namespace" => $page_data->data['name_space'],
		);
		$wiki_link = WikiCommonLib::make_wikiname_html($page_data->data['name'],$wiki_data);

		$edit_pg = urlencode($page_data->data['name']);
		$edit_ns = urlencode($page_data->data['name_space']);
		$edit_link = "<a href=\"{$_SERVER[PHP_SELF]}?md=edit&pg={$edit_pg}&ns={$edit_ns}\">-edit</a>";

		// ڡɤ߹
		$this->smarty->assign('PAGENAME', $wiki_link);
		$this->smarty->assign('EDIT', $edit_link);
		$this->smarty->assign('BODY', $main);
		$this->html .= $this->smarty->fetch( $this->tpl_page );
	}
	else{
		$html = "<!-- No Diary -->";
	}
	$this->html .= $html;
	return true;

}
//-----------------------------------------------------

/*----------------------------------------------------

  private read_form (
    $namespace : String ƵǼ̾
    $current_pg : plugin¹Ԥ褦ȤƤڡ
    $current_ns : plugin¹Ԥ褦ȤƤ̾
  ) : Bool
  եɤ߹

------------------------------------------------------*/
function read_form( $namespace, $current_pg, $current_ns ){
	if($namespace==""){
		return false;
	}

	$date_html = $this->get_date_form_html();

	$this->smarty->assign('SELF',$_SERVER['PHP_SELF']);
	$this->smarty->assign('CURRENT_PG',$current_pg);
	$this->smarty->assign('CURRENT_NS',$current_ns);
	$this->smarty->assign('NAMESPACE', $namespace);
	$this->smarty->assign('TITLE', $date_html);

	// եHTMLɤ߹
    $this->html = $this->smarty->fetch( $this->tpl_form );
	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private read_calendar (
    $date : YYYYMM
    $namespace : 
  ) : Bool
  ɤ߹

------------------------------------------------------*/
function read_calendar($date, $namespace){
	$add_html = "";
	$dummy = array("#Calendar({$date},{$namespace})");
	$this->plugin_manager->call_runtime_function(0,$dummy, $add_html, $page_data);
	$this->html = join("<br>\n",$add_html);
	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private write_page (
    $namespace
    $title
    $body
  ) : Bool
  ǡν񤭹
------------------------------------------------------*/
function write_page( $namespace, $title, $body ) {
	// 
	
	// ǡϿ
	$page_data = new PageData;
	if($this->get_pagedata($page_data, $namespace, $title)){
		$page_data->data['body'] = array_merge($page_data->data['body'],preg_split("/\r?\n/", $body));
		//$page_data->data['last_modify'] = WikiCommonLib::get_microtime();
	}
	else{
		$page_data->data['name_space'] = $namespace;
		$page_data->data['name'] = $title;
		$page_data->data['body'] = preg_split("/\r?\n/", $body);
		$page_data->data['last_modify'] = WikiCommonLib::get_microtime();

        $page_data->data['owner'] = $this->core->auth->user_data->user_name;
        $page_data->data['permit_group'] =
		  $this->config->get('default_group_user_permission');
        $page_data->data['permit_other'] =
		  $this->config->get('default_other_user_permission');
        $page_data->data['permit_guest'] =
		  $this->config->get('guest_user_auth_for_user_page');
	}

	// Ǹ˥Ĥ
	$page_data->data['body'][] = "#Comment(,textarea,)";

	if($this->wiki_db->save($page_data) == "ok"){
		return true;
	}
	else{
		return false;
	}
}
//-----------------------------------------------------

/*----------------------------------------------------

  private get_pagedata (
	$page_data : PageData
    $namespace : String
    $pagename  : String
  ) : Bool true/false Ʊ̾ڡ¸ߤ/¸ߤʤ
  ȥ(ڡ̾)

------------------------------------------------------*/
function get_pagedata( &$page_data, $namespace, $pagename ){
	if($this->wiki_db->check_exist($pagename, $namespace) == "hit"){
		$this->wiki_db->load(
		  $page_data, $pagename, $namespace, "target_level_only");
		return true;
	}

	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private get_date_form_html (
    $year :
    $month :
    $day :
    $year_name :
    $month_name :
    $day_name :
  ) : String

------------------------------------------------------*/
function get_date_form_html(
  $timestamp=0,
  $year_name="year", $month_name="month", $day_name="day"
){
	// ս
	if(empty($timestamp)){
		$timestamp = time();
	}
	$date = getdate($timestamp);

	// HTML
	$html = "";

	// ǯ
	$html .= "<select name=\"{$year_name}\">\n";
	for($cnt=$date['year']-1;$cnt<=$date['year']+1;$cnt++){
		if($cnt == $date['year'])
			$html .= "<option selected>{$cnt}</option>\n";
		else
			$html .= "<option>{$cnt}</option>\n";
	}
	$html .= "</select>/\n";

	// 
	$html .= "<select name=\"{$month_name}\">\n";
	for($cnt=1;$cnt<=12;$cnt++){
		if($cnt == $date['mon'])
			$html .= "<option selected>{$cnt}</option>\n";
		else
			$html .= "<option>{$cnt}</option>\n";
	}
	$html .= "</select>/\n";

	// 
	$html .= "<select name=\"{$day_name}\">\n";
	for($cnt=1;$cnt<=31;$cnt++){
		if($cnt == $date['mday'])
			$html .= "<option selected>{$cnt}</option>\n";
		else
			$html .= "<option>{$cnt}</option>\n";
	}
	$html .= "</select>\n";

	return $html;
}
//-----------------------------------------------------

/*----------------------------------------------------
------------------------------------------------------*/
//-----------------------------------------------------
}
?>
