<?php
/*----------------------------------------------------

  AuthClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/UserData.php' );
require_once( 'Wiki/GroupData.php' );
require_once( 'Wiki/PageData.php' );
require_once( 'Wiki/NamespaceData.php' );


class Auth
{

var $config;
var $plugin_manager;
var $tw_db;
var $auth_db;
var $auth_flag;
var $use_plugin_list;
var $user_permission;
var $guest_permission;
var $guest_user_auth_for_guest_page;
var $guest_user_auth_for_user_page;
var $user_data;

//////////////////////////////////////////
// 󥹥ȥ饯
function Auth( &$config ,&$plugin_manager )
{
	$this->config          = &$config;
	$this->plugin_manager  = &$plugin_manager;
	$this->auth_flag       = $config->get( 'user_auth' );
	$this->tw_db           = &$plugin_manager->wiki_db;
	
	if($this->auth_flag != "on"){return;}
	
	session_name('wiki_auth');
	session_start();
	$this->user_data = $_SESSION['user_data'];
	if(!$this->user_data)
	{
		$this->user_data = new UserData();
	}
	
	$this->use_plugin_list  = split(",",$config->get( 'use_plugin_list' ));
	$this->user_permission  = $config->get( 'user_permission' );
	$this->guest_permission = $config->get( 'guest_permission' );
	$this->guest_user_auth_for_guest_page = $config->get( 'guest_user_auth_for_guest_page' );
	$this->guest_user_auth_for_user_page  = $config->get( 'guest_user_auth_for_user_page' );
	
	$auth_db_plugin_name = $config->get( 'auth_db_plugin_name' );
	if( $this->plugin_manager->load_plugin( $auth_db_plugin_name ) )
	{
		$this->auth_db = new $auth_db_plugin_name( $config );
	}
}

//////////////////////////////////////////
// å
function login( $user_name ,$user_password )
{
	if( $this->auth_flag != "on" ){return false;}

	$target_user_data = new UserData();
	
	if($this->auth_db->get_user_data($user_name,$target_user_data))
	{
		if(md5($user_password) == $target_user_data->password_hash)
		{
			$this->user_data = $target_user_data;
			$_SESSION['user_data'] = $target_user_data;
			return true;
		}
	}
	return false;
}

//////////////////////////////////////////
// 
function logout()
{
	$this->user_data = array();
	$_SESSION['user_data'] = array();
	return true;
}

//////////////////////////////////////////
// оݥڡǧڥå
function check_target_page_permission( &$target_page,$check_mode="read" )
{
	// ǧڤԤΤå
	if( $this->auth_flag != "on" ){return true;}
	
	// Ը¥å
	if( $this->user_data->admin_flag == true ){return true;}
	
	
	// ڡѡߥåå
	if( !$this->proc_check_permission($check_mode,$target_page) )
	{
		return false;
	}
	elseif($check_mode == "plugin")
	{
		$check_mode = write;
	}
	
	// ֥̾ѡߥåå
	$namespace_data = new NamespaceData();
	if( $this->tw_db->load_namespace($namespace_data,$target_page->data['name_space']) )
	{
		if( $this->proc_check_permission($check_mode,$namespace_data) )
		{
			return true;
		}
	}
	return false;
}

//////////////////////////////////////////
// PageDataNamespaceData֥Ȥ򸡺
function proc_check_permission( $check_mode,$target_data_obj )
{
	// ʡʤ̵
	if( $this->user_data->user_name != "" && $this->user_data->user_name == $target_data_obj->data['owner'] )
	{
		return true;
	}
	
	// ȥ桼ǤΥå
	if( preg_match("/$check_mode/",$target_data_obj->data['permit_guest']) )
	{
		return true;
	}
	
	if( $this->user_data->user_name != "" )
	{
		// ¾桼ǤΥå
		if( preg_match("/$check_mode/",$target_data_obj->data['permit_other']) )
		{
			return ture;
		}
		elseif($target_data_obj->data['group'] != "")
		{
			// 롼פΥå
			$group_data = new GroupData();
			if( $this->auth_db->get_group_data( $target_data_obj->data['group'] ,$group_data) )
			{
				$result = $group_data->check_user_in_group( $this->user_data->user_name );
				if($result == "ok_admin")
				{
					return true;
				}
				elseif($result == "ok" && 
				       preg_match("/$check_mode/",$target_data_obj->data['permit_group']) )
				{
					return true;
				}
			}
		}
	}
}




//////////////////////////////////////////
// о˴ؤǧ
function check_user_operation_permission( $mode="write" )
{
	// ǧڤԤΤå
	if( $this->auth_flag != "on" ){return true;}
	
	// Ը¥å
	if( $this->user_data->admin_flag == true ){return true;}
	
	
	if( $this->user_data->user_name != "" )
	{
		// 桼ʤ
		if( preg_match("/$mode/",$this->user_permission) )
		{
			return true;
		}
	}
	else
	{
		// Ȥʤ
		if( preg_match("/$mode/",$this->guest_permission) )
		{
			return true;
		}
	}
	return false;
}


}


?>
