<?php
/*----------------------------------------------------

  UserManagerClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.
    
------------------------------------------------------*/

require_once( 'Wiki/UserData.php' );

class UserManager
{

var $auth;
var $auth_db;
var $config;

//////////////////////////////////////////
// 󥹥ȥ饯
function UserManager( &$config ,&$auth )
{
	$this->config  = &$config;
	$this->auth    = &$auth;
	$this->auth_db = &$auth->auth_db;
}

//////////////////////////////////////////
// ưå
function check_initial_start()
{
	$user_name_list = $this->auth_db->get_user_name_list();
	if( count($user_name_list) == 0 )
	{
		return true;
	}
	else
	{
		return false;
	}
}

//////////////////////////////////////////
// 桼ɲý
function add_user( $user_id ,$user_pass ,$admin_flag=false )
{
	$user_data = new UserData();
	
	$user_data->user_name     = $user_id;
	$user_data->password_hash = md5( $user_pass );
	$user_data->admin_flag    = ($admin_flag == true)? "on" : "off";
	
	return $this->auth_db->add_user( $user_data );
}

//////////////////////////////////////////
// оݥ桼
function delete_user( $user_id )
{
	$target_data = $this->get_user_data( $user_id );
	
	if( $user_data->admin_flag ){ return false; }
	return $this->auth_db->delete_user( $user_id );
}


//////////////////////////////////////////
// 桼ѹ
function modify_user_data( $user_id,$user_pass,&$new_user_data )
{
	$user_data = $new_user_data;
	$user_data->user_name     = $user_id;
	$user_data->password_hash = md5( $user_pass );
	
	return $this->auth_db->modify_user_data( $user_id,$user_data );
}



//////////////////////////////////////////
// 桼ǡꥹȤ
function get_user_data_list( $offset=0,$limit=-1 )
{
	$user_name_list = $this->auth_db->get_user_name_list();
	
	if( $limit == -1 ){ $limit = count($user_name_list); }
	
	$user_data_list = array();
	
	for( $i=$offset;$i<$limit;$i++ )
	{
		$user_data = new UserData();
		if( $this->auth_db->get_user_data($user_name_list[$i],$user_data) )
		{
			array_push( $user_data_list,$user_data );
		}
	}
	
	return $user_data_list;
}

//////////////////////////////////////////
// 桼ǡ
function get_user_data( $name )
{
	$user_data = new UserData();
	if( $this->auth_db->get_user_data( $name,$user_data) )
	{
		return $user_data;
	}
	return false;
}


}

?>
