<?
/*----------------------------------------------------

  SystemMenuRendererClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Smarty/Smarty.class.php' );

class SystemMenuRenderer
{

var $config;
var $smarty;

//////////////////////////////////////////
// 󥹥ȥ饯
function SystemMenuRenderer( &$config )
{
	$this->config = &$config;
	$this->smarty = new Smarty();
	$this->smarty->template_dir = $config->get('resource_dir');
	$this->smarty->assign('MY_URL',$_SERVER['PHP_SELF']);
	$this->smarty->assign('RESOURCE_DIR_PATH',$config->get('resource_dir_url'));
}


//////////////////////////////////////////
// ڡե
function page_create_form($form_value,$message="")
{
	$this->smarty->assign( 'FORM',$form_value );
	$this->smarty->assign( 'NS_SELECT_LIST',$form_value['NS_SELECT_LIST'] );
	$this->smarty->assign( 'MSG',$message );
	return $this->smarty->fetch( 'create_form.tpl' );
}

//////////////////////////////////////////
// ڡԽե
function page_edit_form($form_value,$message="")
{
	$data = array();
	$data['PG'] = urlencode($form_value['PAGE_NAME']);
	$data['NS'] = urlencode($form_value['NAME_SPACE']);
	
	$this->smarty->assign( 'FORM',$form_value );
	$this->smarty->assign( 'DATA',$data );
	$this->smarty->assign( 'MSG',$message );
	return $this->smarty->fetch( 'edit_form.tpl' );
}

//////////////////////////////////////////
// 桼ɽ
function user_list( $user_list_data,$message="" )
{
	$this->smarty->assign( 'USER_LIST',$user_list_data );
	$this->smarty->assign( 'MSG',$message );
	return $this->smarty->fetch( 'user_list.tpl' );
}

//////////////////////////////////////////
// 桼ɲåե
function user_add_form($message="")
{
	$this->smarty->assign('MSG',$message);
	return $this->smarty->fetch( 'user_add_form.tpl' );
}

//////////////////////////////////////////
// 桼Խե
function user_edit_form( $user_data,$message="" )
{
	$this->smarty->assign('MSG',$message);
	$this->smarty->assign('USER_DATA',$user_data);
	return $this->smarty->fetch( 'user_edit_form.tpl' );
}

//////////////////////////////////////////
// 桼Խե
function user_delete_form( $user_data,$message="" )
{
	$this->smarty->assign('MSG',$message);
	$this->smarty->assign('USER_DATA',$user_data);
	return $this->smarty->fetch( 'user_delete_form.tpl' );
}

//////////////////////////////////////////
// ե
function login_form($login_page,$login_namespace,$login_mode,$message="")
{
	$this->smarty->assign('MSG',$message);
	$this->smarty->assign('MD',$login_mode);
	$this->smarty->assign('PG',$login_page);
	$this->smarty->assign('NS',$login_namespace);
	return $this->smarty->fetch( 'login_form.tpl' );
}

//////////////////////////////////////////
// åץɥե
function upload_form($filelist,$message="")
{
	$this->smarty->assign('FILE_LIST',$filelist);
	$this->smarty->assign('TARGET_DIR_URL',$this->config->get('file_upload_dir_url'));
	$this->smarty->assign('MSG',$message);
	return $this->smarty->fetch( 'upload_form.tpl' );
}

//////////////////////////////////////////
// ե
function search_form($namespace_list,$word="")
{
	$this->smarty->assign( 'NS_SELECT_LIST',$namespace_list );
	$this->smarty->assign( 'WORD',$word );
	return $this->smarty->fetch( 'search_form.tpl' );
}

//////////////////////////////////////////
// ѡߥåѹե
function permission_form( $page_data_obj,$mode="page" )
{
	$this->smarty->assign( 'PAGENAME',$page_data_obj->data['name'] );
	$this->smarty->assign( 'OWNER',$page_data_obj->data['owner'] );
	$this->smarty->assign( 'GROUP',$this->split_permission_data( $page_data_obj->data['permit_group']) );
	$this->smarty->assign( 'OTHER',$this->split_permission_data( $page_data_obj->data['permit_other']) );
	$this->smarty->assign( 'GUEST',$this->split_permission_data( $page_data_obj->data['permit_guest']) );
	
	if( $mode == "page" )
	{
		$this->smarty->assign( 'NAMESPACE',$page_data_obj->data['name_space'] );
		return $this->smarty->fetch( 'permission_form.tpl' );
	}
	else
	{
		$this->smarty->assign( 'NAMESPACE',$page_data_obj->data['name'] );
		return $this->smarty->fetch( 'namespace_permission_form.tpl' );
	}
	
}

//////////////////////////////////////////
// ץå
function split_permission_data( $permission_str )
{
	$permission_data = array();
	
	if( preg_match("/read/",$permission_str) )
	{
		$permission_data['read'] = true;
	}
	if( preg_match("/write/",$permission_str) )
	{
		$permission_data['write'] = true;
	}
	if( preg_match("/plugin/",$permission_str) )
	{
		$permission_data['plugin'] = true;
	}
	if( preg_match("/list/",$permission_str) )
	{
		$permission_data['list'] = true;
	}
	
	return $permission_data;
}

//////////////////////////////////////////
// ǧ
function delete_dialog_form( $page_data_obj,$namespace_flag=false )
{
	$this->smarty->assign( 'PAGENAME',$page_data_obj->data['name'] );
	
	$this->smarty->assign( 'OWNER',$page_data_obj->data['owner'] );
	
	
	if( !$namespace_flag )
	{
		$this->smarty->assign( 'NAMESPACE',$page_data_obj->data['name_space'] );
		$this->smarty->assign( 'PG_MODE',"on" );
	}
	else
	{
		$this->smarty->assign( 'NAMESPACE',$page_data_obj->data['name'] );
	}
	return $this->smarty->fetch( 'delete_dialog_form.tpl' );

}

}

?>
