<?php
/*----------------------------------------------------

  TwCoreClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/WikiCommonLib.php' );
require_once( 'Wiki/PluginManager.php' );
require_once( 'Wiki/WikiDisplayManager.php'  );
require_once( 'Wiki/Auth.php' );
require_once( 'Wiki/MessageManager.php' );

//define(DEBUG,1);

class TwCore
{

var $config;
var $plugin_manager;
var $tw_db;
var $auth;
var $display_manager;
var $message_manager;
var $process_status;

//////////////////////////////////////////
// 󥹥ȥ饯
function TwCore(&$config_obj)
{
	$this->config = &$config_obj;
}


//////////////////////////////////////////
// 
function initialize(&$error_message)
{
	// å꥽ޥ͡
	$this->message_manager = new MessageManager( $this->config );
	
	if(! $this->message_manager->load() )
	{
		array_push($error_message,"Resource file load error.");
		return false;
	}
	
	//ץ饰ޥ͡㡼
	$this->plugin_manager = new PluginManager( $this,$this->config );
	
	// DB³
	if( !$this->plugin_manager->database_connection_initialize() )
	{
		array_push($error_message,$this->message_manager->get('ERROR_DB_INITIALIZE').$this->config->get('db_plugin_name'));
		return false;
	}
	$this->tw_db = $this->plugin_manager->wiki_db;
	
	
	// ǧڥ饹
	$this->auth = new Auth( $this->config , $this->plugin_manager );
	
	
	// ǥץ쥤ޥ͡
	$this->display_manager = new WikiDisplayManager( $this,$this->config,$this->plugin_manager,$this->message_manager,$this->auth );
	
	return true;
}


//////////////////////////////////////////
// ¹
function run(&$error_message)
{
	$this->process_status = array();
	$request_array = $_REQUEST;
	$request_array['ns'] = WikiCommonLib::convert_slashes($request_array['ns']);
	$request_array['pg'] = WikiCommonLib::convert_slashes($request_array['pg']);
	
	$mode = "";
	if( !$this->system_mode_switch($error_message,$request_array,$mode) )
	{
		array_push($error_message,"System Manager Exception");
		return false;
	}
	
	
	$html = $this->display_manager->render( $mode,$request_array );
	if( $html )
	{
		$this->output( $html );
		return true;
	}
	else
	{
		array_push($error_message,"Unknown Exception");
		return false;
	}
}

//////////////////////////////////////////
// ʬ
function system_mode_switch( &$error_message,&$request_data,&$mode )
{
	$mode = $this->process_status['mode'] = $request_data['md'];
	switch( $mode )
	{
		case('login'):
			$this->process_login( $request_data,$mode );
			return true;

		case('logout'):
			$this->process_logout( $request_data );
			return true;
		
		case('system'):
			$this->process_system_manager( &$request_data );
			return false;
	}
	return true;

}

//////////////////////////////////////////
// 
function output( $body )
{
	if($this->auth->auth_flag == "on")
	{
		session_write_close();
	}
	
	header("Content-Type: text/html; charset=EUC-JP");
	if(defined(DEBUG)){
		$this->tw_db->db_obj->get_count();
	}
	print( $body );
	
	exit;
}

//////////////////////////////////////////
// 
function process_login( &$post_data,&$mode )
{
	$this->auth->login( $post_data['id'],$post_data['password'] );
	$mode = $this->process_status['mode'] = $post_data['login_md'];
}

//////////////////////////////////////////
// Ƚ
function process_logout( &$post_data )
{
	if ($this->auth->logout() )
	{
		$mode = $post_data['login_md'];
	}
}


//////////////////////////////////////////
// åɽ
function print_message($message,$message_title)
{
	$this->output( $this->display_manager->call_smarty($message,$message_title) );
}



//////////////////////////////////////////
// ƥ
function process_system_manager( &$postdata )
{
	require_once( 'Wiki/UserManager.php' );
	require_once( 'Wiki/SystemMenuRenderer.php' );
	
	$user_manager    = new UserManager( $this->config , $this->auth );
	$system_renderer = new SystemMenuRenderer( $this->config );
	
	$html  = "";
	$title = $this->message_manager->get( 'TITLE_SYSTEM_MANAGER' );
	$sub_mode = $postdata['smd'];
	
	// ưå
	if( $this->check_initial_start(
	      $user_manager, $system_renderer, $postdata, $sub_mode, $html )
	){
		$this->print_message( $html ,$title );
		exit; // ĤˤäƤʤ
	}
	
	// system Фܺ¤Υå
	if( !$this->auth->check_user_operation_permission("system") )
	{
		$html = $this->display_manager->render_login_page($page_name,$name_space,"system");
		$this->output($html);
		exit; // ĤˤäƤʤ
	}
	
	// 
	switch( $sub_mode )
	{
	case( 'user_add_post'):
		$html = $this->add_user($user_manager, $system_renderer, $postdata);
		break;
	
	case( 'target_edit_post' ):
		$html = $this->edit_user($user_manager, $system_renderer, $postdata);
		break;

	case('target_delete_post'):
		$html = $this->delete_user($user_manager, $system_renderer, $postdata);
		break;

	case( 'target' ):
		list( $target_mode,$target_name ) = $this->get_target( $postdata );
		if($user_data = $user_manager->get_user_data($target_name))
		{
			if( $target_mode == "edit" )
			{
				$html = $system_renderer->user_edit_form($user_data);
			}
			else
			{
				$html = $system_renderer->user_delete_form($user_data);
			}
		}
		break;

	default:
		$html = $this->get_html_for_system_user_list($user_manager, $system_renderer, 'MESSAGE_USER_ADD_FORM');
		break;
	}
	$this->print_message( $html ,$title );
	exit; // ˤäƤޤ
}

//////////////////////////////////////////
// POSTͤо
function get_target( &$postdata )
{
	while( list($key_name,$value )= each($postdata) )
	{
		if( $value )
		{
			if( preg_match("/^edit_(.+)$/",$key_name,$match) )
			{
				return array("edit",$match[1]);
			}
			elseif( preg_match("/^delete_(.+)$/",$key_name,$match) )
			{
				return array("delete",$match[1]);
			}
		}
	}
	return array("","");
}

//////////////////////////////////////////
// 桼ޥ͡㡼νưå
function check_initial_start(
  $user_manager, $system_renderer, $postdata, $sub_mode, &$html
){
	if( $result = $user_manager->check_initial_start() )
	{
		switch( $sub_mode )
		{
		case( 'user_add_post'):
			if( $postdata['password'] == "")
			{
				$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_EMPTY') );
			}
			elseif( $postdata['password'] == $postdata['password_confirm'])
			{
				if( $user_manager->add_user($postdata['id'] ,$postdata['password'], true) )
				{
					$html  = $this->message_manager->get( 'MESSAGE_ADMIN_USER_ADD' );
				}
				else
				{
					$html  = $this->message_manager->get( 'ERROR_USER_ADD_FAIL' );
				}
			}
			else{
				$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_TYPO') );
			}
			break;
		
		
		case( 'user_add' ):
		default:
			$html = $system_renderer->user_add_form( $this->message_manager->get('MESSAGE_INITIAL_START') );
			break;
		
		}
	}
	return $result;
}

// memo:
// 鲼Ȥƥˤ桼ط
// TwCoreɤФۤ褤ΤǤϡ
//////////////////////////////////////////
// 桼ɲý
function add_user( $user_manager, $system_renderer, $postdata )
{
	$html = "";
	if( $postdata['password'] == "")
	{
		$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_EMPTY') );
	}
	elseif( $postdata['password'] == $postdata['password_confirm'])
	{
		if( $user_manager->add_user($postdata['id'] ,$postdata['password'],false) )
		{
			$html = $this->get_html_for_system_user_list($user_manager, $system_renderer, 'MESSAGE_USER_ADD');
		}
		else
		{
			$html = $system_renderer->user_add_form( $this->message_manager->get( 'ERROR_USER_ADD_FAIL' ) );
		}
	}
	else{
		$html = $system_renderer->user_add_form( $this->message_manager->get('ERROR_PASSWORD_TYPO') );
	}
	return $html;
}

//////////////////////////////////////////
// 桼Խ
function edit_user( $user_manager, $system_renderer, $postdata )
{
	$html = "";
	$old_data = $user_manager->get_user_data($postdata['id']);
	if( $postdata['password'] != "" )
	{
		if($postdata['password'] == $postdata['password_confirm'])
		{
			if($user_manager->modify_user_data($postdata['id'],$postdata['password'],$old_data))
			{
				$html = $this->get_html_for_system_user_list($user_manager, $system_renderer, 'MESSAGE_USER_ADD');
			}
			else
			{
				$html  = $this->message_manager->get( 'ERROR_USER_ADD_FAIL' );
			}
		}
		else
		{
			$html = $system_renderer->user_edit_form( $old_data,$this->message_manager->get('ERROR_PASSWORD_TYPO') );
		}
	}
	else{
		$html = $system_renderer->user_edit_form($old_data);
	}
	return $html;
}

//////////////////////////////////////////
// 桼
function delete_user( $user_manager, $system_renderer, $postdata )
{
	$html = "";
	if( $user_manager->delete_user($postdata['id']) )
	{
		$html = $this->get_html_for_system_user_list($user_manager, $system_renderer, 'MESSAGE_USER_DELETE');
	}
	else
	{
		$html = $this->get_html_for_system_user_list($user_manager, $system_renderer, 'ERROR_USER_DELETE_FAIL');
	}
	return $html;
}

//////////////////////////////////////////
// ƥ¦ǥ桼ꥹȤHTML
function get_html_for_system_user_list( $user_manager, $system_renderer, $message )
{
	$html = "";
	$user_data_list = $user_manager->get_user_data_list();
	$html = $system_renderer->user_add_form($this->message_manager->get($message));
	$html .= $system_renderer->user_list($user_data_list);
	return $html;
}

}
/*
$Id$
*/
?>
