/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionUtils {

	public static Object invokeMethod(final Method method, final Object obj,
			final Object... args) {

		try {

			setAccessible(method);

			return method.invoke(obj, args);

		} catch (final Exception ex) {
			throw new RuntimeException(ex);
		}
	}

	public static void setAccessible(final AccessibleObject ao) {

		if (!ao.isAccessible()) {
			AccessController.doPrivileged(new PrivilegedAction<Object>() {
				public Object run() {
					ao.setAccessible(true);
					return null;
				}
			});
		}

	}

	public static Method getMethodRecursive(final Class<?> clazz,
			final String methodName, final Class<?>... parameterTypes) {
		final Method m = getMethod(clazz, methodName, parameterTypes);
		if (m != null)
			return m;

		final Class<?> superclazz = clazz.getSuperclass();
		if (superclazz == null)
			return null;

		return getMethodRecursive(superclazz, methodName, parameterTypes);
	}

	public static Method getMethod(final Class<?> clazz,
			final String methodName, final Class<?>... parameterTypes) {
		try {
			return clazz.getDeclaredMethod(methodName, parameterTypes);
		} catch (final NoSuchMethodException e) {
			return null;
		}
	}

	public static boolean isCollectionClass(final Class<?> clazz) {

		if (clazz == null)
			return false;

		if (clazz.isAssignableFrom(Collection.class)
				|| clazz.isAssignableFrom(List.class)
				|| clazz.isAssignableFrom(Set.class)
				|| clazz.isAssignableFrom(Map.class)) {
			return true;
		}

		for (final Class<?> c : clazz.getInterfaces()) {
			if (c.isAssignableFrom(Collection.class)
					|| c.isAssignableFrom(List.class)
					|| c.isAssignableFrom(Set.class)
					|| c.isAssignableFrom(Map.class)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isArray(final Class<?> clazz) {
		if (clazz == null)
			return false;
		return clazz.isArray();
	}

	public static boolean isGraph(Class<?> clazz) {
		if (isArray(clazz))
			return true;
		if (isCollectionClass(clazz))
			return true;
		return false;
	}

}
