/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core.meta.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import net.sf.thirdi.validation.core.meta.ConstraintIndexable;

public class IndexComparator implements Comparator<ConstraintIndexable> {

	private static IndexComparator comp = new IndexComparator();

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(ConstraintIndexable left, ConstraintIndexable right) {

		if (left.getIndex() == right.getIndex()) {
			return 0;
		} else {
			if (left.getIndex() > right.getIndex()) {
				return -1;
			} else {
				return 1;
			}
		}
	}

	public static void sort(List<? extends ConstraintIndexable> list) {
		if (comp == null)
			comp = new IndexComparator();
		Collections.sort(list, comp);
	}

}
