/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core;

import net.sf.thirdi.validation.message.MessageEditorImpl;
import net.sf.thirdi.validation.spec.ConstraintFactory;
import net.sf.thirdi.validation.spec.MessageEditor;
import net.sf.thirdi.validation.spec.Validator;
import net.sf.thirdi.validation.spec.ValidatorFactory;

public class TIValidatorFactory implements ValidatorFactory {

	private MessageEditor messageresolver;

	private static final ThreadLocal<Validator> THREAD_LOCAL_CONTEXT = new ThreadLocal<Validator>();

	private ConstraintFactory constraintfactory;

	@SuppressWarnings("unused")
	private TIValidatorFactory() {
	}

	TIValidatorFactory(MessageEditor messageresolver,
			ConstraintFactory constraintfactory) {

		this.messageresolver = messageresolver;
		this.constraintfactory = constraintfactory;
	}

	public MessageEditor getMessageResolver() {
		if (messageresolver == null)
			messageresolver = new MessageEditorImpl();
		return messageresolver;
	}

	public Validator getValidator() {
		return getThreadLocalContext();
	}

	public Validator getValidator(MessageEditor messageresolver) {
		return new TIValidator(messageresolver, this.constraintfactory);
	}

	private synchronized Validator getThreadLocalContext() {

		Validator validator = THREAD_LOCAL_CONTEXT.get();

		if (validator != null) {
			return validator;
		} else {
			validator = new TIValidator(this.messageresolver,
					this.constraintfactory);
			THREAD_LOCAL_CONTEXT.set(validator);
			return THREAD_LOCAL_CONTEXT.get();
		}
	}

}
