/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core;

import java.util.Set;

import net.sf.thirdi.validation.spec.ConstraintDescriptor;
import net.sf.thirdi.validation.spec.ConstraintViolation;

public class TIConstraintViolation<T> implements ConstraintViolation<T> {

	private final String message;

	private final T rootBean;

	private final Object leafBean;
	private final Object value;
	private final String propertyPath;
	private final Class<T> beanClass;
	private final Set<String> groups;
	private final ConstraintDescriptor constraintDescriptor;

	@SuppressWarnings("unchecked")
	public TIConstraintViolation(String message, T rootBean, Object leafBean,
			Class beanClass, String propertyPath, Object value,
			Set<String> groups, ConstraintDescriptor constraintDescriptor) {
		this.message = message;
		this.rootBean = rootBean;
		this.beanClass = beanClass;
		this.propertyPath = propertyPath;
		this.leafBean = leafBean;
		this.value = value;
		this.groups = groups;
		this.constraintDescriptor = constraintDescriptor;
	}

	public Class<T> getBeanClass() {
		return this.beanClass;
	}

	public ConstraintDescriptor getConstraintDescriptor() {
		return this.constraintDescriptor;
	}

	public Set<String> getGroups() {
		return this.groups;
	}

	public Object getInvalidValue() {
		return this.value;
	}

	public Object getLeafBean() {
		return this.leafBean;
	}

	public String getMessage() {
		return message;
	}

	public String getPropertyPath() {
		return this.propertyPath;
	}

	public T getRootBean() {
		return this.rootBean;
	}
}
