/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintFactory;

public class TIConstraintFactory implements ConstraintFactory {

	private static Map<String, Constraint<?>> pool = new ConcurrentHashMap<String, Constraint<?>>();

	@SuppressWarnings("unchecked")
	public <T extends Constraint<?>> T getInstance(Class<T> constraintClass) {

		try {
			if (pool.containsKey(constraintClass.getName())) {
				Constraint c = pool.get(constraintClass.getName());
				if (c == null) {
					c = constraintClass.newInstance();
					pool.put(constraintClass.getName(), c);
				}
				return (T) c;

			} else {

				Constraint c = constraintClass.newInstance();
				pool.put(constraintClass.getName(), c);

				return (T) c;
			}

		} catch (Exception e) {
			throw new IllegalArgumentException(e);
		}
	}

}
