/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.type.impl
 * t@C  (file name)    FClobType.java
 */
package net.sf.thirdi.jdbc.type.impl;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;

import net.sf.thirdi.jdbc.type.AbstractType;

/**
 * <i>Tv(abstract)</i>F Clob킷NXłB @.
 * <p>
 * Clob킷NXłB
 * 
 * 
 * @author kensir0u
 * @version 1.0
 * @since JDK 5.0
 * 
 */
public class ClobType extends AbstractType {
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * net.sf.thirdi.jdbc.type.AbstractType#getResultsetData(java.sql.ResultSet,
	 * java.lang.String)
	 */
	@Override
	public Object getResultsetData(ResultSet rs, String columnName)
			throws SQLException {
		return rs.getClob(columnName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * net.sf.thirdi.jdbc.type.Type#getResultsetDataToString(java.sql.ResultSet,
	 * java.lang.String)
	 */
	@Override
	public String getResultsetDataToString(ResultSet rs, String columnName)
			throws SQLException {

		Clob clob = rs.getClob(columnName);
		if (clob != null) {
			try {
				StringBuffer sb = new StringBuffer((int) clob.length());
				Reader reader = clob.getCharacterStream();
				char ac[] = new char[4096];
				while(true) {
					int i;
					if ((i = reader.read(ac, 0, ac.length)) == -1)
						break;
					if (i > 0)
						sb.append(ac, 0, i);
				} 
				return sb.toString();
			} catch (IOException e) {
				return "";
			}
		} else {
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetData(java.sql.ResultSet, int)
	 */
	@Override
	public Object getResultsetData(ResultSet rs, int columnIndex)
			throws SQLException {
		return rs.getClob(columnIndex);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetDataToString(java.sql.ResultSet, int)
	 */
	@Override
	public String getResultsetDataToString(ResultSet rs, int columnIndex)
			throws SQLException {
		Clob clob = rs.getClob(columnIndex);
		if (clob != null) {
			try {
				StringBuffer sb = new StringBuffer((int) clob.length());
				Reader reader = clob.getCharacterStream();
				char ac[] = new char[4096];
				while(true) {
					int i;
					if ((i = reader.read(ac, 0, ac.length)) == -1)
						break;
					if (i > 0)
						sb.append(ac, 0, i);
				} 
				return sb.toString();
			} catch (IOException e) {
				return "";
			}
		} else {
			return "";
		}
	}
}