/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.meta
 * t@C  (file name)    FBeanDescGather.java
 */
package net.sf.thirdi.jdbc.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

import net.sf.thirdi.jdbc.annotation.Column;
import net.sf.thirdi.jdbc.exception.IgnoreColumnException;

/**
 * <i>Tv(abstract)</i>F NXW @.
 * <p>
 * NXWB
 * 
 * 
 * @author kensir0u
 * @version 1.0
 * @since JDK 5.0
 * 
 */
public class BeanDescGather {

	private static Map<Class<?>, BeanDesc> pool = new ConcurrentHashMap<Class<?>, BeanDesc>();

	public synchronized static BeanDesc getherBeanDesc(Class<?> beanclass) {

		if (beanclass == null)
			// TODO message move to property file.
			throw new IllegalArgumentException("bean class must not be null.");

		if (beanclass.getName().startsWith("java"))
			// TODO message move to property file.
			throw new IllegalArgumentException(
					"bean class must not be belong to java package.");

		if (!pool.containsKey(beanclass)) {
			return gathering(beanclass);
		} else {
			return pool.get(beanclass);
		}

	}

	private static BeanDesc gathering(Class<?> beanclass) {

		BeanDesc beandesc = _gathering(beanclass);

		if (!pool.containsKey(beanclass)) {
			pool.put(beanclass, (BeanDesc) beandesc);
		}
		return pool.get(beanclass);
	}

	private static BeanDesc _gathering(Class<?> beanclass) {

		BeanDesc beandesc = new BeanDesc(beanclass);

		if (beanclass.getSuperclass() != null
				&& !beanclass.getSuperclass().getName().startsWith("java")) {
			beandesc.setSuperbeandesc(_gathering(beanclass.getSuperclass()));
		}

		processField(beandesc);

		processProperty(beandesc);

		beandesc.setList(getElementList(beandesc));

		return beandesc;
	}

	private static List<ElementDesc> getElementList(BeanDesc beandesc) {
		List<ElementDesc> list = new LinkedList<ElementDesc>();

		for (Iterator<Entry<String, ElementDesc>> iter = beandesc.getNameMap()
				.entrySet().iterator(); iter.hasNext();) {
			Entry<String, ElementDesc> entry = iter.next();
			list.add(entry.getValue());
		}

		IndexComparator.sort(list);

		return list;
	}

	private static void processField(BeanDesc beandesc) {

		Class<?> beanclass = beandesc.getBeanclass();

		Field[] fields = beanclass.getFields();

		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			ElementDesc elementdesc = createElementDesc(field, beandesc
					.isIncludeType());
			if (elementdesc != null) {
				if (!beandesc.getNameMap().containsKey(elementdesc.getName())) {
					beandesc.getNameMap().put(elementdesc.getName(),
							elementdesc);
				}
			}
		}
	}

	private static ElementDesc createElementDesc(Field field,
			boolean isIncludeType) {

		if (field.isEnumConstant() || field.isSynthetic())
			return null;

		if (isIncludeType) {
			if (field.isAnnotationPresent(Column.class)) {
				Column column = field.getAnnotation(Column.class);
				if (column.exclude())
					return null;
				return processFieldDesc(field, column);
			} else {
				return null;
			}
		} else {
			if (field.isAnnotationPresent(Column.class)) {
				Column column = field.getAnnotation(Column.class);
				if (column.exclude())
					return null;
				return processFieldDesc(field, column);
			} else {
				return processFieldDesc(field, null);
			}
		}

	}

	private static ElementDesc processFieldDesc(Field field, Column column) {
		FieldDesc desc = new FieldDesc();
		desc.setField(field);
		desc.setFieldName(field.getName());
		desc.setType(field.getType());
		if (column == null) {
			desc.setName(field.getName().toUpperCase());
		} else {
			if (column.alias() != null && !"".equals(column.alias())) {
				desc.setName(column.alias().toUpperCase());
			} else {
				if (column.name() != null && !"".equals(column.name())) {
					desc.setName(column.name().toUpperCase());
				} else {
					desc.setName(field.getName().toUpperCase());
				}
			}
			desc.setIndex(column.index());
		}

		return desc;
	}

	private static void processProperty(BeanDesc beandesc) {
		Class<?> beanclass = beandesc.getBeanclass();

		Method[] methods = beanclass.getMethods();

		for (int i = 0; i < methods.length; i++) {
			Method method = methods[i];
			if (isSetter(method)) {
				ElementDesc elementdesc = createElementDesc(method, beandesc
						.isIncludeType());
				if (elementdesc != null) {
					if (!beandesc.getNameMap().containsKey(
							elementdesc.getName())) {
						beandesc.getNameMap().put(elementdesc.getName(),
								elementdesc);
					}
				}
			}
		}
	}

	private static boolean isSetter(Method method) {

		if (method.getName().startsWith("set")) {
			if (method.getParameterTypes().length == 1) {
				if (method.getName().length() > 3) {
					return true;
				}
			}
		}
		if (method.isAnnotationPresent(Column.class)) {
			// TODO message move to property file.
			throw new IgnoreColumnException(
					"This method has 'Column' annotation is ignored.");
		}

		return false;
	}

	private static ElementDesc createElementDesc(Method method,
			boolean isIncludeType) {

		if (method.isSynthetic() || method.isBridge() || method.isVarArgs())
			return null;

		if (isIncludeType) {
			if (method.isAnnotationPresent(Column.class)) {
				Column column = method.getAnnotation(Column.class);
				if (column.exclude())
					return null;
				return processPropertyDesc(method, column);
			} else {
				return null;
			}
		} else {
			if (method.isAnnotationPresent(Column.class)) {
				Column column = method.getAnnotation(Column.class);
				if (column.exclude())
					return null;
				return processPropertyDesc(method, column);
			} else {

				return processPropertyDesc(method, null);
			}
		}

	}

	private static ElementDesc processPropertyDesc(Method method, Column column) {
		PropertyDesc desc = new PropertyDesc();
		desc.setMethod(method);
		desc.setPropertyName(method.getName());
		desc.setType(method.getParameterTypes()[0]);
		if (column == null) {
			desc.setName(method.getName().substring(3).toUpperCase());
		} else {
			if (column.alias() != null && !"".equals(column.alias())) {
				desc.setName(column.alias().toUpperCase());
			} else {
				if (column.name() != null && !"".equals(column.name())) {
					desc.setName(column.name().toUpperCase());
				} else {
					desc.setName(method.getName().substring(3).toUpperCase());
				}
			}
			desc.setIndex(column.index());
		}

		return desc;
	}

}
