/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/14
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.impl
 * t@C  (file name)    FCSVInfoImpl.java
 */
package net.sf.thirdi.jdbc.impl;

import net.sf.thirdi.jdbc.CSVFormatInfo;
import net.sf.thirdi.jdbc.CSVFormatMode;
import net.sf.thirdi.jdbc.CSVHeaderInfo;
import net.sf.thirdi.jdbc.CSVInfo;

/**
 * <i>Tv(abstract)</i>F CSVInfo
 *@.<p>
 * CSVInfo<BR>
 * {@link net.sf.thirdi.jdbc.CSVInfo}
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
class CSVInfoImpl implements CSVInfo{
	
	private boolean addHeaderColumn = true;
	
	private CSVFormatMode mode = CSVFormatMode.ORIGINAL;
	
	private CSVHeaderInfo headerinfo ;
	
	private CSVFormatInfo formatinfo;
		
	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#isAddHeaderColumn()
	 */
	@Override
	public boolean isAddHeaderColumn() {
		return this.addHeaderColumn;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#getFormatMode()
	 */
	@Override
	public CSVFormatMode getFormatMode() {
		return this.mode;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setFormtMode(net.sf.thirdi.jdbc.CSVFormatMode)
	 */
	@Override
	public void setFormtMode(CSVFormatMode mode) {
		this.mode = mode;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#getCSVFormatInfo()
	 */
	@Override
	public CSVFormatInfo getCSVFormatInfo() {
		return this.formatinfo;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#getCSVHeaderInfo()
	 */
	@Override
	public CSVHeaderInfo getCSVHeaderInfo() {
		return this.headerinfo;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setAddHeaderColumn(boolean)
	 */
	@Override
	public void setAddHeaderColumn(boolean flag) {
		this.addHeaderColumn = flag;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setCSVFormatInfo(net.sf.thirdi.jdbc.CSVFormatInfo)
	 */
	@Override
	public void setCSVFormatInfo(CSVFormatInfo formatinfo)
			throws IllegalArgumentException {
		if (formatinfo == null)
			// TODO message move to property file.
			throw new IllegalArgumentException("formatinfo must not be null.");
		
		this.formatinfo = formatinfo;
		
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setCSVHeaderInfo(net.sf.thirdi.jdbc.CSVHeaderInfo)
	 */
	@Override
	public void setCSVHeaderInfo(CSVHeaderInfo headerinfo)
			throws IllegalArgumentException {
		if (headerinfo == null)
			// TODO message move to property file.
			throw new IllegalArgumentException("headerinfo must not be null.");
		
		this.headerinfo = headerinfo;
		
	}
}
