/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/10
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.annotation
 * t@C  (file name)    FColumn.java
 */
package net.sf.thirdi.jdbc.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * <i>Tv(abstract)</i>F oChΏۂ̃tB[hE\bhɑ΂Ame[V
 *@.<p>
 * oChΏۂ̃tB[hEZb^[\bhɕt邽߂̃Ame[V<BR>
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
@Target({METHOD,FIELD})
@Retention(RUNTIME)
public @interface Column {
	
	String name();
	
	boolean unique() default false;
	
	boolean nullable() default false;
	
	boolean insertable() default false;
	
	boolean updatable() default false;
	
	String columnDefinition() default "";
	
	String table() default "";
	
	int length() default -1;
	
	int precision() default -1;
	
	int scale() default -1;
	
	/** GCAXݒ肵܂B
	 */
	String alias() default "";
	
	int index() default Short.MIN_VALUE;
	/** oChΏۊOƂ܂B*/
	boolean exclude() default false;

}
