/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/16
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc
 * t@C  (file name)    FCSVHeaderInfo.java
 */
package net.sf.thirdi.jdbc;

import java.util.NoSuchElementException;

/**
 * <i>Tv(abstract)</i>F CSVwb_[
 *@.<p>
 * CSVwb_[
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public interface CSVHeaderInfo {
	
	/**
	 * 
	 * <i>Tv(abstract)</i>F wb_[̕^CvԂ
	 * .<p>
	 * wb_[̃^CvԂB
	 *@
	 * @return@^Cv
	 */
	MappingLetterType getMappingLetterType();
	
	/**
	 * 
	 * <i>Tv(abstract)</i>Fwb_[̕^Cvݒ肷B
	 * .<p>
	 * wb_[̕^Cvݒ肷B
	 *@
	 * @param type@wb_[^Cv
	 */
	void setMappingLetterType(MappingLetterType type);
	
	/**
	 * <i>Tv(abstract)</i>F CSVJԂB
	 * .<p>
	 * wʒuCSVJԂB<BR>
	 * CfbNX͂Pn܂܂B<BR>
	 * Base index from 1.<BR>
	 * {@link net.sf.thirdi.jdbc.CSVColumn}
	 *@
	 * @param index Jʒu
	 * @return CSVJ
	 * @throws IndexOutOfBoundsException
	 */
	public CSVColumn getCSVColumn(int index) throws IndexOutOfBoundsException;
	
	/**
	 * <i>Tv(abstract)</i>F CSVJԂB
	 * .<p>
	 * wĴCSVJԂB<BR>
	 * {@link net.sf.thirdi.jdbc.CSVColumn}
	 *@
	 * @param columnName
	 * @return@CSVColumnIuWFNg
	 * @throws NoSuchElementException
	 */
	public CSVColumn getCSVColumn(String columnName) throws NoSuchElementException;
	
	/**
	 * <i>Tv(abstract)</i>F CSVJݒ肷B
	 * .<p>
	 * wʒuCSVJݒ肷B<BR>
	 * CfbNX͂Pn܂܂B<BR>
	 * Base index from 1.<BR>
	 * {@link net.sf.thirdi.jdbc.CSVColumn}
	 *@
	 * @param index@Jʒu
	 * @param column@{@link net.sf.thirdi.jdbc.CSVColumn}IuWFNg
	 * @throws IllegalArgumentException
	 * @throws NegativeArraySizeException
	 * @throws IndexOutOfBoundsException
	 */
	public void setCSVColumn(int index,CSVColumn column) throws IllegalArgumentException,NegativeArraySizeException,IndexOutOfBoundsException;
	
	/**
	 * <i>Tv(abstract)</i>F CSVJݒ肷B
	 * .<p>
	 * wĴCSVJݒ肷B<BR>
	 * {@link net.sf.thirdi.jdbc.CSVColumn}
	 *@
	 * @param columnName@J
	 * @param column@{@link net.sf.thirdi.jdbc.CSVColumn}IuWFNg
	 * @throws IllegalArgumentException
	 * @throws NoSuchElementException
	 */
	public void setCSVColumn(String columnName,CSVColumn column)throws IllegalArgumentException,NoSuchElementException;
	
	
	/**
	 * <i>Tv(abstract)</i>F JԋpB
	 * .<p>
	 * JԋpB
	 *@
	 * @return@J
	 */
	public int getColumnCount();
	
}
