/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/12
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc
 * t@C  (file name)    FSQLMapper.java
 */
package net.sf.thirdi.jdbc.util;

import java.io.Writer;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;

import net.sf.thirdi.jdbc.BeanDecorater;
import net.sf.thirdi.jdbc.CSVConverter;
import net.sf.thirdi.jdbc.CSVInfo;
import net.sf.thirdi.jdbc.MappingLetterType;
import net.sf.thirdi.jdbc.ORMapper;
import net.sf.thirdi.jdbc.impl.CSVConverterImpl;
import net.sf.thirdi.jdbc.impl.ORMapperImpl;

/**
 * <i>Tv(abstract)</i>F Data}bp[i[eBeB[j
 *@.<p>
 * Data}bp[
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public final class DataMapper {
	
	private static ORMapper orm = new ORMapperImpl();
	
	private static CSVConverter csv = new CSVConverterImpl();

	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}PBeanɃ}bsO܂B
	 * .<p>
	 *  {@link java.sql.ResultSet}PBeanɃ}bsO܂B
	 *@
	 * @param rs  {@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @return@}bsOBeanIuWFNg
	 */
	public static <T> T mapRow(ResultSet rs,Class<T> clazz){
		return orm.mapRow(rs, clazz);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @return@Bean}bsOList
	 */
	public static <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz){
		return orm.mapRowList(rs, clazz);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 *@R[hJEg̎w肪ł܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @param maxcount@R[hől
	 * @return@Bean}bsOList
	 */
	public static <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz,long maxcount){
		return orm.mapRowList(rs, clazz, maxcount);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * f[^oChBeanListɊi[OɃfR[^[Ă΂܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @param beandecorater@fR[^[
	 * @return@Bean}bsOList
	 */
	public static <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz, BeanDecorater beandecorater){
		return orm.mapRowList(rs, clazz, beandecorater);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	@* {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * @f[^oChBeanListɊi[OɃfR[^[Ă΂܂B
	 *  R[hJEg̎w肪ł܂B
	 *@
	 * @param rs@{java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @param beandecorater@fR[^[
	 * @param maxcount@R[hJEgől
	 * @return@Bean}bsOList
	 */
	public static <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz, BeanDecorater beandecorater,long maxcount){
		return orm.mapRowList(rs, clazz, beandecorater, maxcount);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}JKEYMapɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[܂B
	 *@J̓IWi̕Ŋi[܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @return@R[h}bsOMapIuWFNg
	 */
	public static Map<String,?> toMap(ResultSet rs){
		return orm.toMap(rs);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}JKEYMapɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[܂B
	 * J͑啶Aw\łB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param type@^Cv
	 * @return@R[h}bsOMapIuWFNg
	 */
	public static Map<String,?> toMap(ResultSet rs,MappingLetterType type){
		return orm.toMap(rs,type);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public static List<Map<String,?>> toMapList(ResultSet rs){
		return orm.toMapList(rs);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 *@ListɊi[郌R[h̍őlw肷邱Ƃł܂B@
	 *
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param maxcount@R[hől
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public static List<Map<String,?>> toMapList(ResultSet rs,long maxcount){
		return orm.toMapList(rs,maxcount);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 *@ListɊi[郌R[h̃J啶AƎw肷邱Ƃł܂B@
	 *
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param type@^Cv
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public static List<Map<String,?>> toMapList(ResultSet rs,MappingLetterType type){
		return orm.toMapList(rs,type);
	}
	
	/**
	 * <i>Tv(static)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 *@ListɊi[郌R[h̃J啶AƎw肷邱Ƃł܂B
	 * ListɊi[郌R[h̍őlw肷邱Ƃł܂B@@
	 *
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param type@^Cv
	 * @param  maxcount@R[hől
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public static List<Map<String,?>> toMapList(ResultSet rs,MappingLetterType type,long maxcount){
		return orm.toMapList(rs, type,maxcount);
	}
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 *  {@link java.sql.ResultSet}CSVɃRo[gB<BR>
	 *  WWriterԋpB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param info@{@link net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @param maxcount@ő匏
	 * @return@Ro[g̕WWriter
	 */
	public static Writer toCSV(ResultSet rs,CSVInfo info,long maxcount){
		return csv.toCSV(rs, info, maxcount);
	}
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * {@link java.sql.ResultSet}CSVɃRo[gB<BR>
	 * WWriterԋpB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param info@info@{@link net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @return@Ro[g̕WWriter
	 */
	public static Writer toCSV(ResultSet rs,CSVInfo info){
		return csv.toCSV(rs, info);
	}
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * {@link java.sql.ResultSet}CSVɃRo[gB<BR>
	 * WWriterԋpB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @return@Ro[g̕WWriter
	 */
	public static Writer toCSV(ResultSet rs){
		return csv.toCSV(rs);
	}
	
	/**
	 * <i>Tv(abstract)</i>F w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param info@info@{net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @param maxcount@ő匏
	 * @param writer@w肵Writer
	 * @return@Ro[g̎w肵Writer
	 */
	public static <T extends Writer> T toCSV(ResultSet rs,CSVInfo info,long maxcount, T writer){
		return csv.toCSV(rs, info,  maxcount,  writer);
	}
	
	/**
	 * <i>Tv(abstract)</i>F w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param info@info@{@link net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @param writer@w肵Writer
	 * @return@Ro[g̎w肵Writer
	 */
	public static <T extends Writer> T toCSV(ResultSet rs,CSVInfo info, T writer){
		return csv.toCSV(rs, info,   writer);
	}
	
	/**
	 * <i>Tv(abstract)</i>F w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param writer@w肵Writer
	 * @return@Ro[g̎w肵Writer
	 */
	public static <T extends Writer> T toCSV(ResultSet rs, T writer){
		return csv.toCSV(rs,  writer);
		
	}
	
	/**
	 * <i>Tv(abstract)</i>F CSVInfo쐬B
	 * .<p>
	 * CSVInfo쐬B
	 *@
	 * @return@CSVInfo
	 */
	public static  CSVInfo createCSVInfo(){
		return csv.createCSVInfo();
	}
	
}
