/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/12
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.typeresolver.impl
 * t@C  (file name)    FDefaultTypeResolver.java
 */
package net.sf.thirdi.jdbc.typeresolver.impl;

import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

import net.sf.thirdi.jdbc.type.Type;
import net.sf.thirdi.jdbc.type.impl.ArrayType;
import net.sf.thirdi.jdbc.type.impl.BigDecimalType;
import net.sf.thirdi.jdbc.type.impl.BlobType;
import net.sf.thirdi.jdbc.type.impl.BooleanType;
import net.sf.thirdi.jdbc.type.impl.BytesType;
import net.sf.thirdi.jdbc.type.impl.ClobType;
import net.sf.thirdi.jdbc.type.impl.DateType;
import net.sf.thirdi.jdbc.type.impl.DoubleType;
import net.sf.thirdi.jdbc.type.impl.FloatType;
import net.sf.thirdi.jdbc.type.impl.IntegerType;
import net.sf.thirdi.jdbc.type.impl.LongType;
import net.sf.thirdi.jdbc.type.impl.ObjectType;
import net.sf.thirdi.jdbc.type.impl.RefType;
import net.sf.thirdi.jdbc.type.impl.StringType;
import net.sf.thirdi.jdbc.type.impl.StructType;
import net.sf.thirdi.jdbc.type.impl.TimeType;
import net.sf.thirdi.jdbc.type.impl.TimestampType;
import net.sf.thirdi.jdbc.typeresolver.SQLTypeResolver;

/**
 * <i>Tv(abstract)</i>F ftHg^Cv
 *@.<p>
 * ftHg^Cv
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class DefaultSQLTypeResolver implements SQLTypeResolver{

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.typeresolver.TypeResolver#getTypes()
	 */
	@Override
	public Map<Integer, Type> getTypes() {
		Map<Integer,Type> types = new HashMap<Integer,Type>();
		
//		CHAR String
//		VARCHAR String
//		LONGVARCHAR String
//		NUMERIC java.math.BigDecimal
//		DECIMAL java.math.BigDecimal
//		BIT Boolean
//		TINYINT Integer
//	    SMALLINT Integer
//	    INTEGER Integer 
//	    BIGINT Long 
//	    REAL Float 
//	    FLOAT Double 
//	    DOUBLE Double 
//	    BINARY byte[] 
//	    VARBINARY byte[] 
//	    LONGVARBINARY byte[] 
//	    DATE java.sql.Date 
//	    TIME java.sql.Time 
//	    TIMESTAMP java.sql.Timestamp 
//	    DISTINCT ̌^̃IuWFNg^
//		CLOB Clob
//		BLOB Blob
//		ARRAY Array
//		STRUCT Struct ܂ SQLData
//		REF Ref
//		JAVA_OBJECT  Java NX
		
		
		types.put(Types.CHAR, new StringType());
		types.put(Types.VARCHAR, new StringType());
		types.put(Types.LONGNVARCHAR, new StringType());
		types.put(Types.NUMERIC, new BigDecimalType());
		types.put(Types.DECIMAL, new BigDecimalType());
		
		types.put(Types.BIT, new BooleanType());
		
		types.put(Types.TINYINT, new IntegerType());
		types.put(Types.SMALLINT, new IntegerType());
		types.put(Types.INTEGER, new IntegerType());
		
		types.put(Types.BIGINT, new LongType());
		types.put(Types.REAL, new FloatType());
		types.put(Types.FLOAT, new DoubleType());
		
		
		types.put(Types.BINARY, new BytesType());
		types.put(Types.VARBINARY, new BytesType());
		
		types.put(Types.LONGVARBINARY, new BytesType());
		
		types.put(Types.DATE, new DateType());
		
		types.put(Types.TIME, new TimeType());
		types.put(Types.TIMESTAMP, new TimestampType());
		types.put(Types.DISTINCT, new ObjectType());
		types.put(Types.CLOB, new ClobType());
		
		types.put(Types.BLOB, new BlobType());
		types.put(Types.ARRAY, new ArrayType());
		types.put(Types.STRUCT, new StructType());
		
		types.put(Types.REF, new RefType());
		types.put(Types.JAVA_OBJECT, new ObjectType());
	
		return types;
	}

}
