/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/12
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc
 * t@C  (file name)    FTypeManager.java
 */
package net.sf.thirdi.jdbc.typeresolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import net.sf.thirdi.jdbc.exception.NotFoundTypeResolverException;
import net.sf.thirdi.jdbc.type.Type;
import net.sf.thirdi.jdbc.typeresolver.impl.DefaultTypeResolver;

/**
 * <i>Tv(abstract)</i>F Type}l[W[ @.
 * <p>
 * Type}l[W[
 * 
 * 
 * @author kensir0u
 * @version 1.0
 * @since JDK 5.0
 * 
 */
public class TypeManager {

	public static Map<Class<?>, Type> getTypes() {

		TypeResolver typeresolver = getFindTypeResolver();
		
		if (typeresolver == null) return getDefaultTypeResolver().getTypes();

		Map<Class<?>, Type> types = typeresolver.getTypes();

		return mergeTypes(types, getDefaultTypeResolver().getTypes());
	}

	private static Map<Class<?>, Type> mergeTypes(Map<Class<?>, Type> types,
			Map<Class<?>, Type> defaulttypes) {

		if (types == null) {
			return defaulttypes;
		} else {
			for (Iterator<Entry<Class<?>, Type>> iterator = defaulttypes
					.entrySet().iterator(); iterator.hasNext();) {
				Entry<Class<?>, Type> entry = iterator.next();
				if (!types.containsKey(entry.getKey())) {
					types.put(entry.getKey(), entry.getValue());
				}
			}
			return types;
		}
	}

	private static TypeResolver getDefaultTypeResolver() {
		return new DefaultTypeResolver();
	}

	private static final String SERVICES_FILE = "META-INF/services/"
			+ TypeResolver.class.getName();

	private static TypeResolver getFindTypeResolver() {
		ClassLoader classloader = Thread.currentThread()
				.getContextClassLoader();
		if (classloader == null) {
			classloader = TypeResolver.class.getClassLoader();
		}

		String name = null;
		try {
			Enumeration<URL> providerDefinitions = classloader
					.getResources(SERVICES_FILE);
			while (providerDefinitions.hasMoreElements()) {
				URL url = providerDefinitions.nextElement();
				InputStream stream = url.openStream();
				try {
					BufferedReader reader = new BufferedReader(
							new InputStreamReader(stream), 100);
					name = reader.readLine();
					while (name != null) {
						name = name.trim();
						if (!name.startsWith("#")) {
							final Class<?> providerClass = loadClass(name,
									TypeResolver.class);
							if (isInstantiate(providerClass)) {
								return createInstance(providerClass);
							}

						}
						name = reader.readLine();
					}
				} finally {
					stream.close();
				}
			}
		} catch (IOException e) {
			throw new NotFoundTypeResolverException(e);
		} catch (ClassNotFoundException e) {
			throw new NotFoundTypeResolverException(e);
		}
		return getDefaultTypeResolver();

	}

	private static TypeResolver createInstance(Class<?> typeresolvername) {
		try {
			return (TypeResolver) typeresolvername.newInstance();
		} catch (InstantiationException e) {
			throw new NotFoundTypeResolverException(e);
		} catch (IllegalAccessException e) {
			throw new NotFoundTypeResolverException(e);
		}
	}

	private static boolean isInstantiate(Class<?> typeresolvername) {
		try {
			typeresolvername.newInstance();
			return true;
		} catch (Exception ignore) {
			return false;
		}
	}

	private static Class<?> loadClass(String name, Class<?> caller)
			throws ClassNotFoundException {
		try {
			ClassLoader loader = Thread.currentThread().getContextClassLoader();
			if (loader != null) {
				return loader.loadClass(name);
			}
		} catch (ClassNotFoundException e) {
			if (caller == null) {
				throw e;
			}
		}
		return Class.forName(name, true, caller.getClassLoader());
	}
}
