/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.type.impl
 * t@C  (file name)    FShortType.java
 */
package net.sf.thirdi.jdbc.type.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import net.sf.thirdi.jdbc.type.AbstractType;

/**
 * <i>Tv(abstract)</i>F Long킷NXłB
 *@.<p>
 * Long킷NXłB
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class LongType extends AbstractType{
	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.AbstractType#getResultsetData(java.sql.ResultSet, java.lang.String)
	 */
	@Override
	public Object getResultsetData(ResultSet rs, String columnName) throws SQLException{
		return rs.getLong(columnName);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetDataToString(java.sql.ResultSet, java.lang.String)
	 */
	@Override
	public String getResultsetDataToString(ResultSet rs, String columnName)
			throws SQLException {
		return String.valueOf(rs.getLong(columnName));
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetData(java.sql.ResultSet, int)
	 */
	@Override
	public Object getResultsetData(ResultSet rs, int columnIndex)
			throws SQLException {
		return rs.getLong(columnIndex);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetDataToString(java.sql.ResultSet, int)
	 */
	@Override
	public String getResultsetDataToString(ResultSet rs, int columnIndex)
			throws SQLException {
		return String.valueOf(rs.getLong(columnIndex));
	}
}