/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/12
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.impl
 * t@C  (file name)    FORMapperImpl.java
 */
package net.sf.thirdi.jdbc.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import net.sf.thirdi.jdbc.BeanDecorateHandler;
import net.sf.thirdi.jdbc.BeanDecorater;
import net.sf.thirdi.jdbc.MappingLetterType;
import net.sf.thirdi.jdbc.ORMapper;
import net.sf.thirdi.jdbc.exception.NotInstantiationException;
import net.sf.thirdi.jdbc.exception.SQLRuntimeException;
import net.sf.thirdi.jdbc.meta.BeanDesc;
import net.sf.thirdi.jdbc.meta.BeanDescGather;
import net.sf.thirdi.jdbc.meta.ElementDesc;
import net.sf.thirdi.jdbc.type.Type;
import net.sf.thirdi.jdbc.typeresolver.TypeManager;

/**
 * <i>Tv(abstract)</i>F OR}bp[ @.
 * <p>
 * 
 *  OR}bp[ 
 * 
 * @author kensir0u
 * @version 1.0
 * @since JDK 5.0
 * 
 */
public class ORMapperImpl implements ORMapper {

	private static Map<Class<?>, Type> types = TypeManager.getTypes();

	private static BeanDecorater beandecorater = new DefaultBeanDecorater();
	
	private static final Long DEFAULT_MAXCOUNT = Long.MAX_VALUE;
	
	private static final MappingLetterType DEFAULT_MAPPINGLETTERTYPE = MappingLetterType.ORIGINAL_LETTER;
	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.thirdi.jdbc.ORMapper#mapRow(java.sql.ResultSet,
	 * java.lang.Class)
	 */
	@Override
	public <T> T mapRow(ResultSet rs, Class<T> clazz) {

		if (clazz == null)
			// TODO message move to property file.
			throw new NullPointerException("bean class must not be null.");
		
		if (!isInstance(clazz))
			// TODO message move to property file.
			throw new NotInstantiationException(
					"bean class can not create the instance. ");

		BeanDesc beandesc = BeanDescGather.getherBeanDesc(clazz);

		T bean = instance(clazz);

		return _mapRow(rs, bean, beandesc);

	}

	private <T> T _mapRow(ResultSet rs, T bean, BeanDesc beandesc) {

		try {
			ResultSetMetaData rsmd = rs.getMetaData();

			int count = rsmd.getColumnCount();

			if (rs.isBeforeFirst())
				rs.next();

			for (int i = 0; i < count; i++) {

				String columnName = rsmd.getColumnLabel(i + 1);
				if (beandesc.getNameMap().containsKey(columnName.toUpperCase())) {
					ElementDesc elementdesc = beandesc.getNameMap().get(
							columnName.toUpperCase());

					Type type = types.get(elementdesc.getType());

					if (type != null) {
						type.set(rs, bean, elementdesc, columnName);
					}
				}
			}
		} catch (SQLException e) {
			throw new SQLRuntimeException(e);
		}
		return bean;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.thirdi.jdbc.ORMapper#mapRowList(java.sql.ResultSet,
	 * java.lang.Class)
	 */
	@Override
	public <T> List<T> mapRowList(ResultSet rs, Class<T> clazz) {
		return mapRowList(rs,clazz,null);
	}
	
	
	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#toMapList(java.sql.ResultSet)
	 */
	public List<Map<String,?>> toMapList(ResultSet rs){
		return toMapList(rs,DEFAULT_MAPPINGLETTERTYPE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sf.thirdi.jdbc.ORMapper#toMap(java.sql.ResultSet)
	 */
	@Override
	public Map<String, ?> toMap(ResultSet rs) {
		return toMap(rs,DEFAULT_MAPPINGLETTERTYPE);
	}

	private static <T> T instance(Class<T> clazz) {
		try {
			return (T) clazz.newInstance();
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	@SuppressWarnings("unchecked")
	private static boolean isInstance(Class clazz) {
		try {
			clazz.newInstance();
			return true;
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#mapRowList(java.sql.ResultSet, java.lang.Class, net.sf.thirdi.jdbc.BeanDecorater)
	 */
	@Override
	public <T> List<T> mapRowList(ResultSet rs, Class<T> clazz,
			BeanDecorater beandecorater) {
		return mapRowList(rs, clazz, beandecorater, DEFAULT_MAXCOUNT);
	}
	
	private static class DefaultBeanDecorater implements BeanDecorater{
		/* (non-Javadoc)
		 * @see net.sf.thirdi.jdbc.BeanDecorater#decorate(java.lang.Object)
		 */
		@Override
		public <T> T decorate(T bean) {
			return bean;
		}
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#toMap(java.sql.ResultSet, net.sf.thirdi.jdbc.MappingLetterType)
	 */
	@Override
	public Map<String, ?> toMap(ResultSet rs, MappingLetterType type) {
		try {
			
			if (rs.isBeforeFirst())
				rs.next();
			
			//@SuppressWarnings("unchecked")
			Map<String,Object> result = new ConcurrentHashMap<String,Object>();
			ResultSetMetaData rsmd = rs.getMetaData();
			int cols = rsmd.getColumnCount();
			
			for (int i = 1; i <= cols; i++) {
				switch(type){
					case CAPITAL_LETTER:
						result
						.put(rsmd.getColumnName(i).toUpperCase(), rs
								.getObject(i));
						break;
					case SMALL_LETTER:
						result
						.put(rsmd.getColumnName(i).toLowerCase(), rs
								.getObject(i));
						break;
					default:
						result
						.put(rsmd.getColumnName(i), rs
								.getObject(i));
				}
			}
			return result;
		} catch (SQLException e) {
			throw new SQLRuntimeException(e);
		}
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#toMapList(java.sql.ResultSet, net.sf.thirdi.jdbc.MappingLetterType)
	 */
	@Override
	public List<Map<String, ?>> toMapList(ResultSet rs, MappingLetterType type) {
		return toMapList(rs,type,DEFAULT_MAXCOUNT);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#mapRowList(java.sql.ResultSet, java.lang.Class, long)
	 */
	@Override
	public <T> List<T> mapRowList(ResultSet rs, Class<T> clazz, long maxcount) {
		return mapRowList(rs, clazz,null, maxcount);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#mapRowList(java.sql.ResultSet, java.lang.Class, net.sf.thirdi.jdbc.BeanDecorater, long)
	 */
	@Override
	public <T> List<T> mapRowList(ResultSet rs, Class<T> clazz,
			BeanDecorater beandecorater, long maxcount) {
		long count = 0;
		if (beandecorater == null ) beandecorater = ORMapperImpl.beandecorater;
		try {
			List<T> list = new ArrayList<T>();
			while(rs.next()){
				if (count > maxcount) break;
				T bean = mapRow(rs,clazz);
				if (BeanDecorateHandler.class.isAssignableFrom(bean.getClass())){
					((BeanDecorateHandler)bean).afterDecorate();
				}
				list.add(beandecorater.decorate(bean));
				count++;
			}
			return list;
		} catch (SQLException e) {
			throw new SQLRuntimeException(e);
		}
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#toMapList(java.sql.ResultSet, long)
	 */
	@Override
	public List<Map<String, ?>> toMapList(ResultSet rs, long maxcount) {
		return toMapList(rs,DEFAULT_MAPPINGLETTERTYPE,maxcount);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.ORMapper#toMapList(java.sql.ResultSet, net.sf.thirdi.jdbc.MappingLetterType, long)
	 */
	@Override
	public List<Map<String, ?>> toMapList(ResultSet rs, MappingLetterType type,
			long maxcount) {
		long count = 0;
		try {
			List<Map<String, ?>> list = new ArrayList<Map<String, ?>>();
			while(rs.next()){
				if (count > maxcount) break;
				list.add(toMap(rs,type));
				count++;
			}
			return list;
		} catch (SQLException e) {
			throw new SQLRuntimeException(e);
		}
	}

}
