/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.BoolResultType;
import org.mafait.thinknowlogy.CollectionResultType;
import org.mafait.thinknowlogy.CreateAndAssignResultType;
import org.mafait.thinknowlogy.DuplicateResultType;
import org.mafait.thinknowlogy.FileResultType;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.GrammarResultType;
import org.mafait.thinknowlogy.InputOutput;
import org.mafait.thinknowlogy.Item;
import org.mafait.thinknowlogy.JustificationResultType;
import org.mafait.thinknowlogy.SelectionResultType;
import org.mafait.thinknowlogy.ShortResultType;
import org.mafait.thinknowlogy.WordEndingResultType;
import org.mafait.thinknowlogy.WordItem;
import org.mafait.thinknowlogy.WordResultType;
import org.mafait.thinknowlogy.WordTypeResultType;

class List {
    private int highestSentenceNrInList_ = 0;
    private Item activeList_ = null;
    private Item inactiveList_ = null;
    private Item archivedList_ = null;
    private Item replacedList_ = null;
    private Item deletedList_ = null;
    private Item nextListItem_ = null;
    private char listChar_ = (char)63;
    private WordItem myWordItem_ = null;

    private boolean isIncludingThisList(StringBuffer queryListStringBuffer) {
        int index = 0;
        if (queryListStringBuffer != null && queryListStringBuffer.length() > 0) {
            while (index < queryListStringBuffer.length() && queryListStringBuffer.charAt(index) != this.listChar_) {
                index = (short)(index + 1);
            }
            if (index == queryListStringBuffer.length()) {
                return false;
            }
        }
        return true;
    }

    private Item firstDeletedItem() {
        return this.deletedList_;
    }

    private static int highestCurrentSentenceItemNr(int currentSentenceNr, Item searchItem) {
        int highestItemNr = 0;
        while (searchItem != null) {
            int tempItemNr;
            if (searchItem.creationSentenceNr() == currentSentenceNr && (tempItemNr = searchItem.itemNr()) > highestItemNr) {
                highestItemNr = tempItemNr;
            }
            searchItem = searchItem.nextItem;
        }
        return highestItemNr;
    }

    private static int highestFoundSentenceNrInList(int maxSentenceNr, Item searchItem) {
        int highestFoundSentenceNr = 0;
        while (searchItem != null && highestFoundSentenceNr < maxSentenceNr) {
            int tempSentenceNr = searchItem.activeSentenceNr();
            if (tempSentenceNr > highestFoundSentenceNr && tempSentenceNr <= maxSentenceNr) {
                highestFoundSentenceNr = tempSentenceNr;
            }
            if ((tempSentenceNr = searchItem.inactiveSentenceNr()) > highestFoundSentenceNr && tempSentenceNr <= maxSentenceNr) {
                highestFoundSentenceNr = tempSentenceNr;
            }
            if ((tempSentenceNr = searchItem.archivedSentenceNr()) > highestFoundSentenceNr && tempSentenceNr <= maxSentenceNr) {
                highestFoundSentenceNr = tempSentenceNr;
            }
            if ((tempSentenceNr = searchItem.replacedSentenceNr()) > highestFoundSentenceNr && tempSentenceNr <= maxSentenceNr) {
                highestFoundSentenceNr = tempSentenceNr;
            }
            searchItem = searchItem.nextItem;
        }
        return highestFoundSentenceNr;
    }

    private byte decrementItemNrRange(int decrementSentenceNr, int startDecrementItemNr, int decrementOffset, Item searchItem) {
        while (searchItem != null) {
            if (searchItem.creationSentenceNr() == decrementSentenceNr && searchItem.itemNr() >= startDecrementItemNr) {
                if (searchItem.itemNr() <= startDecrementItemNr) {
                    return this.startError(1, "I found an item number equal to the given start item number");
                }
                if (searchItem.decrementItemNr(decrementOffset) != 1) {
                    return this.addError(1, "I failed to decrement the item number of an item with a certain offset");
                }
            }
            searchItem = searchItem.nextItem;
        }
        return 1;
    }

    private byte decrementSentenceNrs(int startSentenceNr, Item searchItem) {
        while (searchItem != null) {
            if (searchItem.activeSentenceNr() >= startSentenceNr) {
                if (searchItem.activeSentenceNr() <= startSentenceNr) {
                    return this.startError(1, "I found an item with an active sentence number equal to the given start sentence number " + startSentenceNr);
                }
                if (searchItem.decrementActiveSentenceNr() != 1) {
                    return this.addError(1, "I failed to decrement the active sentence number of an item");
                }
            }
            if (searchItem.inactiveSentenceNr() >= startSentenceNr) {
                if (searchItem.inactiveSentenceNr() <= startSentenceNr) {
                    return this.startError(1, "I found an item with an inactive sentence number equal to the given start sentence number " + startSentenceNr);
                }
                if (searchItem.decrementInactiveSentenceNr() != 1) {
                    return this.addError(1, "I failed to decrement the inactive sentence number of an item");
                }
            }
            if (searchItem.originalSentenceNr() >= startSentenceNr) {
                if (searchItem.originalSentenceNr() <= startSentenceNr) {
                    return this.startError(1, "I found an item with an original sentence number equal to the given start sentence number " + startSentenceNr);
                }
                if (searchItem.decrementOriginalSentenceNr() != 1) {
                    return this.addError(1, "I failed to decrement the original sentence number of an item");
                }
            }
            if (searchItem.creationSentenceNr() >= startSentenceNr) {
                if (searchItem.creationSentenceNr() <= startSentenceNr) {
                    return this.startError(1, "I found an item with a creation sentence number equal to the given start sentence number " + startSentenceNr);
                }
                if (searchItem.decrementCreationSentenceNr() != 1) {
                    return this.addError(1, "I failed to decrement the creation sentence number of an item");
                }
            }
            if (searchItem.archivedSentenceNr() >= startSentenceNr) {
                if (searchItem.archivedSentenceNr() <= startSentenceNr) {
                    return this.startError(1, "I found an item with an archived sentence number equal to the given start sentence number " + startSentenceNr);
                }
                if (searchItem.decrementArchivedSentenceNr() != 1) {
                    return this.addError(1, "I failed to decrement the archived sentence number of an item");
                }
            }
            if (searchItem.replacedSentenceNr() >= startSentenceNr) {
                if (searchItem.replacedSentenceNr() <= startSentenceNr) {
                    return this.startError(1, "I found an item with a replaced sentence number equal to the given start sentence number " + startSentenceNr);
                }
                if (searchItem.decrementReplacedSentenceNr() != 1) {
                    return this.addError(1, "I failed to decrement the replaced sentence number of an item");
                }
            }
            searchItem = searchItem.nextItem;
        }
        return 1;
    }

    private byte removeItemFromList(Item removeItem) {
        if (removeItem == null) {
            return this.startError(1, "The given remove item is undefined");
        }
        if (removeItem.myList() != this) {
            return this.startError(1, "The given remove item doesn't belong to my list");
        }
        if (removeItem.previousItem == null) {
            switch (removeItem.statusChar()) {
                case '+': {
                    this.activeList_ = removeItem.nextItem;
                    break;
                }
                case '=': {
                    this.inactiveList_ = removeItem.nextItem;
                    break;
                }
                case '$': {
                    this.archivedList_ = removeItem.nextItem;
                    break;
                }
                case '%': {
                    this.replacedList_ = removeItem.nextItem;
                    break;
                }
                case '&': {
                    this.deletedList_ = removeItem.nextItem;
                    break;
                }
                default: {
                    return this.startError(1, "The given remove item has an unknown status character");
                }
            }
            if (removeItem.nextItem != null) {
                removeItem.nextItem.previousItem = null;
            }
        } else {
            removeItem.previousItem.nextItem = removeItem.nextItem;
            if (removeItem.nextItem != null) {
                removeItem.nextItem.previousItem = removeItem.previousItem;
            }
        }
        this.nextListItem_ = removeItem.nextItem;
        removeItem.previousItem = null;
        removeItem.nextItem = null;
        return 1;
    }

    private static void clearQuerySelections(Item searchItem) {
        while (searchItem != null) {
            searchItem.isSelectedByQuery = false;
            searchItem.isSelectedByJustificationQuery = false;
            searchItem = searchItem.nextItem;
        }
    }

    private static void itemQuery(boolean isSelectingOnFind, boolean isReferenceQuery, int querySentenceNr, int queryItemNr, Item queryItem) {
        while (queryItem != null) {
            if (isReferenceQuery && queryItem.hasReferenceItemById(querySentenceNr, queryItemNr) || !isReferenceQuery && (querySentenceNr == 0 && queryItemNr == 0 || querySentenceNr > 0 && queryItemNr == 0 && queryItem.hasSentenceNr(querySentenceNr) || queryItem.itemNr() == queryItemNr && (querySentenceNr == 0 || queryItem.creationSentenceNr() == querySentenceNr))) {
                if (isSelectingOnFind && !queryItem.isSelectedByQuery) {
                    GlobalVariables.hasFoundQuery = true;
                    queryItem.isSelectedByQuery = true;
                }
            } else if (!isSelectingOnFind && queryItem.isSelectedByQuery) {
                queryItem.isSelectedByQuery = false;
            }
            queryItem = queryItem.nextItem;
        }
    }

    private static void listQuery(boolean isSelectingOnFind, Item queryItem) {
        while (queryItem != null) {
            if (isSelectingOnFind) {
                if (!queryItem.isSelectedByQuery) {
                    GlobalVariables.hasFoundQuery = true;
                    queryItem.isSelectedByQuery = true;
                }
            } else if (queryItem.isSelectedByQuery) {
                queryItem.isSelectedByQuery = false;
            }
            queryItem = queryItem.nextItem;
        }
    }

    private static void parameterQuery(boolean isSelectingOnFind, int queryParameter, Item queryItem) {
        while (queryItem != null) {
            if (queryItem.hasParameter(queryParameter)) {
                if (isSelectingOnFind && !queryItem.isSelectedByQuery) {
                    GlobalVariables.hasFoundQuery = true;
                    queryItem.isSelectedByQuery = true;
                }
            } else if (!isSelectingOnFind && queryItem.isSelectedByQuery) {
                queryItem.isSelectedByQuery = false;
            }
            queryItem = queryItem.nextItem;
        }
    }

    private static void wordQuery(boolean isSelectingOnFind, Item queryItem) {
        while (queryItem != null) {
            if (isSelectingOnFind) {
                if (!queryItem.isSelectedByQuery) {
                    GlobalVariables.hasFoundQuery = true;
                    queryItem.isSelectedByQuery = true;
                }
            } else if (queryItem.isSelectedByQuery) {
                queryItem.isSelectedByQuery = false;
            }
            queryItem = queryItem.nextItem;
        }
    }

    private static void wordTypeQuery(boolean isSelectingOnFind, short queryWordTypeNr, Item queryItem) {
        while (queryItem != null) {
            if (queryItem.hasWordType(queryWordTypeNr)) {
                if (isSelectingOnFind && !queryItem.isSelectedByQuery) {
                    GlobalVariables.hasFoundQuery = true;
                    queryItem.isSelectedByQuery = true;
                }
            } else if (!isSelectingOnFind && queryItem.isSelectedByQuery) {
                queryItem.isSelectedByQuery = false;
            }
            queryItem = queryItem.nextItem;
        }
    }

    private byte displayQueryResult(boolean isOnlyDisplayingWords, boolean isOnlyDisplayingWordReferences, boolean isOnlyDisplayingStrings, boolean isReturnQueryToPosition, short promptTypeNr, short queryWordTypeNr, int queryWidth, Item queryItem) {
        while (queryItem != null) {
            if (queryItem.isSelectedByQuery || queryItem.isSelectedByJustificationQuery) {
                if (isOnlyDisplayingWords) {
                    queryItem.displayWords(isReturnQueryToPosition, queryWordTypeNr);
                } else if (isOnlyDisplayingWordReferences) {
                    queryItem.displayWordReferences(isReturnQueryToPosition);
                } else if (isOnlyDisplayingStrings) {
                    queryItem.displayString(isReturnQueryToPosition);
                } else if (InputOutput.writeText(true, promptTypeNr, queryWidth, queryItem.itemToStringBuffer(queryWordTypeNr)) != 1) {
                    return this.addError(1, "I failed to display the info of an active item");
                }
            }
            queryItem = queryItem.nextItem;
        }
        return 1;
    }

    private byte stringQuery(boolean isSelectingOnFind, String wordString, Item queryItem) {
        while (queryItem != null) {
            boolean hasFoundString = false;
            String itemString = queryItem.itemString();
            if (itemString != null) {
                BoolResultType boolResult = this.compareStrings(wordString, itemString);
                if (boolResult.result != 1) {
                    return this.addError(1, "I failed to compare two strings");
                }
                hasFoundString = boolResult.booleanValue;
            }
            if (hasFoundString) {
                if (isSelectingOnFind && !queryItem.isSelectedByQuery) {
                    GlobalVariables.hasFoundQuery = true;
                    queryItem.isSelectedByQuery = true;
                }
            } else if (!isSelectingOnFind && queryItem.isSelectedByQuery) {
                queryItem.isSelectedByQuery = false;
            }
            queryItem = queryItem.nextItem;
        }
        return 1;
    }

    private byte wordReferenceQuery(boolean isSelectingOnFind, boolean isSelectingAttachedJustifications, boolean isSelectingJustificationSpecifications, String wordReferenceNameString, Item queryItem) {
        while (queryItem != null) {
            BoolResultType boolResult = queryItem.findMatchingWordReferenceString(wordReferenceNameString);
            if (boolResult.result != 1) {
                return this.addError(1, "I failed to check the word references");
            }
            if (boolResult.booleanValue) {
                if (queryItem.isSelectedByQuery) {
                    if (isSelectingAttachedJustifications) {
                        queryItem.selectingAttachedJustifications(isSelectingJustificationSpecifications);
                    }
                } else if (isSelectingOnFind) {
                    GlobalVariables.hasFoundQuery = true;
                    queryItem.isSelectedByQuery = true;
                }
            } else if (!isSelectingOnFind && queryItem.isSelectedByQuery) {
                queryItem.isSelectedByQuery = false;
            }
            queryItem = queryItem.nextItem;
        }
        return 1;
    }

    protected List() {
    }

    protected byte addError(int methodLevel, String errorString) {
        InputOutput.displayError(this.listChar_, this.getClass().getName(), this.getClass().getSuperclass().getName(), this.myWordItem_ == null || this.myWordItem_.isAdminWord() ? null : this.myWordItem_.anyWordTypeString(), methodLevel + 1, errorString);
        return GlobalVariables.result;
    }

    protected byte startError(int methodLevel, String errorString) {
        this.addError(methodLevel + 1, errorString);
        GlobalVariables.result = 0;
        return 0;
    }

    protected byte startSystemError(int methodLevel, String errorString) {
        this.addError(methodLevel + 1, errorString);
        GlobalVariables.result = (byte)-1;
        return -1;
    }

    protected BoolResultType addBoolResultError(int methodLevel, String errorString) {
        BoolResultType interpretationResult = new BoolResultType();
        interpretationResult.result = this.addError(methodLevel + 1, errorString);
        return interpretationResult;
    }

    protected BoolResultType startBoolResultError(int methodLevel, String errorString) {
        BoolResultType boolResult = new BoolResultType();
        boolResult.result = this.startError(methodLevel + 1, errorString);
        return boolResult;
    }

    protected CollectionResultType addCollectionResultError(int methodLevel, String errorString) {
        CollectionResultType collectionResult = new CollectionResultType();
        collectionResult.result = this.addError(methodLevel + 1, errorString);
        return collectionResult;
    }

    protected CollectionResultType startCollectionResultError(int methodLevel, String errorString) {
        CollectionResultType collectionResult = new CollectionResultType();
        collectionResult.result = this.startError(methodLevel + 1, errorString);
        return collectionResult;
    }

    protected CollectionResultType startCollectionResultSystemError(int methodLevel, String errorString) {
        CollectionResultType collectionResult = new CollectionResultType();
        collectionResult.result = this.startSystemError(methodLevel + 1, errorString);
        return collectionResult;
    }

    protected CreateAndAssignResultType addCreateAndAssignResultError(int methodLevel, String errorString) {
        CreateAndAssignResultType createAndAssignResult = new CreateAndAssignResultType();
        createAndAssignResult.result = this.addError(methodLevel + 1, errorString);
        return createAndAssignResult;
    }

    protected CreateAndAssignResultType startCreateAndAssignResultError(int methodLevel, String errorString) {
        CreateAndAssignResultType createAndAssignResult = new CreateAndAssignResultType();
        createAndAssignResult.result = this.startError(methodLevel + 1, errorString);
        return createAndAssignResult;
    }

    protected DuplicateResultType addDuplicateResultError(int methodLevel, String errorString) {
        DuplicateResultType duplicateResult = new DuplicateResultType();
        duplicateResult.result = this.addError(methodLevel + 1, errorString);
        return duplicateResult;
    }

    protected DuplicateResultType startDuplicateResultError(int methodLevel, String errorString) {
        DuplicateResultType duplicateResult = new DuplicateResultType();
        duplicateResult.result = this.startError(methodLevel + 1, errorString);
        return duplicateResult;
    }

    protected FileResultType addFileResultError(int methodLevel, String errorString) {
        FileResultType fileResult = new FileResultType();
        fileResult.result = this.addError(methodLevel + 1, errorString);
        return fileResult;
    }

    protected FileResultType startFileResultError(int methodLevel, String errorString) {
        FileResultType fileResult = new FileResultType();
        fileResult.result = this.startError(methodLevel + 1, errorString);
        return fileResult;
    }

    protected GrammarResultType addGrammarResultError(int methodLevel, String errorString) {
        GrammarResultType grammarResult = new GrammarResultType();
        grammarResult.result = this.addError(methodLevel + 1, errorString);
        return grammarResult;
    }

    protected GrammarResultType startGrammarResultError(int methodLevel, String errorString) {
        GrammarResultType grammarResult = new GrammarResultType();
        grammarResult.result = this.startError(methodLevel + 1, errorString);
        return grammarResult;
    }

    protected JustificationResultType addJustificationResultError(int methodLevel, String errorString) {
        JustificationResultType justificationResult = new JustificationResultType();
        justificationResult.result = this.addError(methodLevel + 1, errorString);
        return justificationResult;
    }

    protected JustificationResultType startJustificationResultError(int methodLevel, String errorString) {
        JustificationResultType justificationResult = new JustificationResultType();
        justificationResult.result = this.startError(methodLevel + 1, errorString);
        return justificationResult;
    }

    protected SelectionResultType addSelectionResultError(int methodLevel, String errorString) {
        SelectionResultType selectionResult = new SelectionResultType();
        selectionResult.result = this.addError(methodLevel + 1, errorString);
        return selectionResult;
    }

    protected SelectionResultType startSelectionResultSystemError(int methodLevel, String errorString) {
        SelectionResultType selectionResult = new SelectionResultType();
        selectionResult.result = this.startSystemError(methodLevel + 1, errorString);
        return selectionResult;
    }

    protected ShortResultType startShortResultError(int methodLevel, String errorString) {
        ShortResultType shortResult = new ShortResultType();
        shortResult.result = this.startError(methodLevel + 1, errorString);
        return shortResult;
    }

    protected WordEndingResultType startWordEndingResultError(int methodLevel, String errorString) {
        WordEndingResultType wordEndingResult = new WordEndingResultType();
        wordEndingResult.result = this.startError(methodLevel + 1, errorString);
        return wordEndingResult;
    }

    protected WordResultType addWordResultError(int methodLevel, String errorString) {
        WordResultType wordResult = new WordResultType();
        wordResult.result = this.addError(methodLevel + 1, errorString);
        return wordResult;
    }

    protected WordResultType startWordResultError(int methodLevel, String errorString) {
        WordResultType wordResult = new WordResultType();
        wordResult.result = this.startError(methodLevel + 1, errorString);
        return wordResult;
    }

    protected WordTypeResultType addWordTypeResultError(int methodLevel, String errorString) {
        WordTypeResultType wordTypeResult = new WordTypeResultType();
        wordTypeResult.result = this.addError(methodLevel + 1, errorString);
        return wordTypeResult;
    }

    protected WordTypeResultType startWordTypeResultError(int methodLevel, String errorString) {
        WordTypeResultType wordTypeResult = new WordTypeResultType();
        wordTypeResult.result = this.startError(methodLevel + 1, errorString);
        return wordTypeResult;
    }

    protected boolean isTemporaryList() {
        return false;
    }

    protected void initializeListVariables(char listChar, String classNameString, WordItem myWordItem) {
        this.listChar_ = listChar;
        this.myWordItem_ = myWordItem;
        if (this.myWordItem_ == null) {
            this.startSystemError(1, "The given my word item is undefined");
        }
    }

    protected void deleteTemporaryList() {
        Item searchItem = this.deletedList_;
        if (this.inactiveList_ != null) {
            if (searchItem == null) {
                this.deletedList_ = this.inactiveList_;
            } else {
                searchItem = searchItem.tailOfList();
                searchItem.nextItem = this.inactiveList_;
            }
            this.inactiveList_ = null;
        }
        if (this.activeList_ != null) {
            if (searchItem == null) {
                this.deletedList_ = this.activeList_;
            } else {
                searchItem = searchItem.tailOfList();
                searchItem.nextItem = this.activeList_;
            }
            this.activeList_ = null;
        }
    }

    protected boolean hasActiveItems() {
        return this.activeList_ != null;
    }

    protected boolean isAdminList() {
        return Character.isUpperCase(this.listChar_);
    }

    protected boolean isAssignmentList() {
        return this.listChar_ == 'a';
    }

    protected int highestSentenceNrInList() {
        return this.highestSentenceNrInList_;
    }

    protected char listChar() {
        return this.listChar_;
    }

    protected byte addItemToList(char statusChar, Item newItem) {
        block31: {
            Item searchItem;
            Item previousSearchItem;
            block30: {
                previousSearchItem = null;
                if (newItem == null) {
                    return this.startError(1, "The given new item is undefined");
                }
                if (newItem.myList() != this) {
                    return this.startError(1, "The given new item doesn't belong to my list");
                }
                if (newItem.nextItem != null) {
                    return this.startError(1, "The given new item seems to be a part of a list");
                }
                switch (statusChar) {
                    case '+': {
                        newItem.setActiveSentenceNr();
                        newItem.setActiveStatus();
                        searchItem = this.activeList_;
                        break;
                    }
                    case '=': {
                        newItem.setInactiveSentenceNr();
                        newItem.setInactiveStatus();
                        searchItem = this.inactiveList_;
                        break;
                    }
                    case '$': {
                        newItem.setArchivedSentenceNr();
                        newItem.setArchivedStatus();
                        searchItem = this.archivedList_;
                        break;
                    }
                    case '%': {
                        newItem.setReplacedSentenceNr();
                        newItem.setReplacedStatus();
                        searchItem = this.replacedList_;
                        break;
                    }
                    case '&': {
                        newItem.setDeletedStatus();
                        searchItem = this.deletedList_;
                        break;
                    }
                    default: {
                        return this.startError(1, "The given status character is unknown");
                    }
                }
                int creationSentenceNr = newItem.creationSentenceNr();
                if (statusChar == '&') {
                    while (searchItem != null && (searchItem.creationSentenceNr() > creationSentenceNr || searchItem.creationSentenceNr() == creationSentenceNr && searchItem.itemNr() < newItem.itemNr())) {
                        previousSearchItem = searchItem;
                        searchItem = searchItem.nextItem;
                    }
                } else {
                    if (creationSentenceNr > this.highestSentenceNrInList_) {
                        this.highestSentenceNrInList_ = creationSentenceNr;
                        if (this.myWordItem_ != null) {
                            this.myWordItem_.setHighestSentenceNr(creationSentenceNr);
                        }
                    }
                    while (searchItem != null && !newItem.isSorted(searchItem)) {
                        previousSearchItem = searchItem;
                        searchItem = searchItem.nextItem;
                    }
                }
                if (searchItem != null && searchItem.creationSentenceNr() == creationSentenceNr && searchItem.itemNr() == newItem.itemNr()) {
                    return this.startError(1, "I found another item with the same identification");
                }
                newItem.previousItem = previousSearchItem;
                if (previousSearchItem != null) break block30;
                switch (statusChar) {
                    case '+': {
                        if (this.activeList_ != null) {
                            this.activeList_.previousItem = newItem;
                        }
                        newItem.nextItem = this.activeList_;
                        this.activeList_ = newItem;
                        break block31;
                    }
                    case '=': {
                        if (this.inactiveList_ != null) {
                            this.inactiveList_.previousItem = newItem;
                        }
                        newItem.nextItem = this.inactiveList_;
                        this.inactiveList_ = newItem;
                        break block31;
                    }
                    case '$': {
                        if (this.archivedList_ != null) {
                            this.archivedList_.previousItem = newItem;
                        }
                        newItem.nextItem = this.archivedList_;
                        this.archivedList_ = newItem;
                        break block31;
                    }
                    case '%': {
                        if (this.replacedList_ != null) {
                            this.replacedList_.previousItem = newItem;
                        }
                        newItem.nextItem = this.replacedList_;
                        this.replacedList_ = newItem;
                        break block31;
                    }
                    case '&': {
                        if (this.deletedList_ != null) {
                            this.deletedList_.previousItem = newItem;
                        }
                        newItem.nextItem = this.deletedList_;
                        this.deletedList_ = newItem;
                        break block31;
                    }
                    default: {
                        return this.startError(1, "The given status character is unknown");
                    }
                }
            }
            if (searchItem != null) {
                searchItem.previousItem = newItem;
            }
            newItem.nextItem = previousSearchItem.nextItem;
            previousSearchItem.nextItem = newItem;
        }
        return 1;
    }

    protected byte activateItem(Item activateItem) {
        if (activateItem == null) {
            return this.startError(1, "The given activate item is undefined");
        }
        if (activateItem.statusChar() == '+') {
            return this.startError(1, "The given activate item is already an active item");
        }
        if (this.removeItemFromList(activateItem) != 1) {
            return this.addError(1, "I failed to remove an item from the archive list");
        }
        if (this.addItemToList('+', activateItem) != 1) {
            return this.addError(1, "I failed to add an item to the active list");
        }
        if (this.isAssignmentList() && GlobalVariables.currentAssignmentLevel == 0) {
            GlobalVariables.isAssignmentChanged = true;
        }
        return 1;
    }

    protected byte inactivateItem(Item inactivateItem) {
        if (inactivateItem == null) {
            return this.startError(1, "The given inactivate item is undefined");
        }
        if (inactivateItem.statusChar() == '=') {
            return this.startError(1, "The given inactivate item is already an inactive item");
        }
        if (this.listChar_ != 'R' && this.listChar_ != 'a') {
            return this.startError(1, "Only assignments and read items can be inactived");
        }
        if (this.removeItemFromList(inactivateItem) != 1) {
            return this.addError(1, "I failed to remove an item from the archive list");
        }
        if (this.addItemToList('=', inactivateItem) != 1) {
            return this.addError(1, "I failed to add an item to the inactive list");
        }
        if (this.isAssignmentList() && GlobalVariables.currentAssignmentLevel == 0) {
            GlobalVariables.isAssignmentChanged = true;
        }
        return 1;
    }

    protected byte archiveItem(Item archiveItem) {
        if (archiveItem == null) {
            return this.startError(1, "The given archive item is undefined");
        }
        if (archiveItem.statusChar() == '$') {
            return this.startError(1, "The given archive item is already an archived item");
        }
        if (!this.isAssignmentList()) {
            return this.startError(1, "Only assignments can be archived");
        }
        if (this.removeItemFromList(archiveItem) != 1) {
            return this.addError(1, "I failed to remove an item from a list");
        }
        archiveItem.previousStatusChar = archiveItem.statusChar();
        if (this.addItemToList('$', archiveItem) != 1) {
            return this.addError(1, "I failed to add an item to the archived list");
        }
        if (GlobalVariables.currentAssignmentLevel == 0) {
            GlobalVariables.isAssignmentChanged = true;
        }
        return 1;
    }

    protected byte replaceItem(Item replaceItem) {
        if (replaceItem == null) {
            return this.startError(1, "The given replace item is undefined");
        }
        if (replaceItem.statusChar() == '%') {
            return this.startError(1, "The given replace item is already a replaced item");
        }
        if (this.removeItemFromList(replaceItem) != 1) {
            return this.addError(1, "I failed to remove an item from a list");
        }
        replaceItem.previousStatusChar = replaceItem.statusChar();
        if (this.addItemToList('%', replaceItem) != 1) {
            return this.addError(1, "I failed to add an item to the replaced list");
        }
        return 1;
    }

    protected byte deleteItem(Item deleteItem) {
        if (this.removeItemFromList(deleteItem) != 1) {
            return this.addError(1, "I failed to remove an item from a list");
        }
        deleteItem.previousStatusChar = deleteItem.statusChar();
        if (deleteItem.statusChar() == '&') {
            return this.startError(1, "The given delete item is already a deleted item");
        }
        if (this.addItemToList('&', deleteItem) != 1) {
            return this.addError(1, "I failed to add an item to the deleted list");
        }
        return 1;
    }

    protected byte removeFirstRangeOfDeletedItemsInList() {
        int nDeletedItems = 0;
        Item removeItem = this.deletedList_;
        if (removeItem != null) {
            if (GlobalVariables.nDeletedItems != 0 || GlobalVariables.removeSentenceNr > 0 || GlobalVariables.removeStartItemNr > 0) {
                return this.startError(1, "There is already a range of deleted items");
            }
            int removeSentenceNr = removeItem.creationSentenceNr();
            int removeStartItemNr = removeItem.itemNr();
            do {
                this.deletedList_ = this.deletedList_.nextItem;
                removeItem.checkForUsage();
                removeItem.nextItem = null;
            } while ((removeItem = this.deletedList_) != null && removeItem.creationSentenceNr() == removeSentenceNr && removeItem.itemNr() == removeStartItemNr + ++nDeletedItems);
            GlobalVariables.nDeletedItems = nDeletedItems;
            GlobalVariables.removeSentenceNr = removeSentenceNr;
            GlobalVariables.removeStartItemNr = removeStartItemNr;
        }
        return 1;
    }

    protected Item firstActiveItem() {
        return this.activeList_;
    }

    protected Item firstInactiveItem() {
        return this.inactiveList_;
    }

    protected Item firstArchivedItem() {
        return this.archivedList_;
    }

    protected Item firstReplacedItem() {
        return this.replacedList_;
    }

    protected Item nextListItem() {
        return this.nextListItem_;
    }

    protected WordItem myWordItem() {
        return this.myWordItem_;
    }

    /*
     * Unable to fully structure code
     */
    protected BoolResultType compareStrings(String searchString, String sourceString) {
        hasFoundMatchingString = true;
        searchStringPosition = 0;
        sourceStringPosition = 0;
        boolResult = new BoolResultType();
        if (searchString == null) {
            return this.startBoolResultError(1, "The given search string is undefined");
        }
        if (sourceString == null) {
            return this.startBoolResultError(1, "The given source string is undefined");
        }
        if (searchString != sourceString) ** GOTO lbl36
        return this.startBoolResultError(1, "The given strings are the same string");
lbl-1000:
        // 1 sources

        {
            if (searchString.charAt(searchStringPosition) == '?' || searchString.charAt(searchStringPosition) == sourceString.charAt(sourceStringPosition)) {
                ++searchStringPosition;
                ++sourceStringPosition;
                continue;
            }
            if (searchString.charAt(searchStringPosition) != '*') ** GOTO lbl35
            if (++searchStringPosition < searchString.length()) {
                isStop = false;
                while (!isStop && sourceStringPosition < sourceString.length()) {
                    if (searchString.charAt(searchStringPosition) == sourceString.charAt(sourceStringPosition)) {
                        boolResult = this.compareStrings(searchString.substring(searchStringPosition), sourceString.substring(sourceStringPosition));
                        if (boolResult.result != 1) {
                            return this.addBoolResultError(1, "I failed to compare the remaining strings");
                        }
                        if (hasFoundMatchingString) {
                            isStop = true;
                            ++searchStringPosition;
                        } else {
                            hasFoundMatchingString = true;
                        }
                        ++sourceStringPosition;
                        continue;
                    }
                    ++sourceStringPosition;
                }
            } else {
                sourceStringPosition = sourceString.length();
                continue;
lbl35:
                // 1 sources

                hasFoundMatchingString = false;
            }
lbl36:
            // 5 sources

            ** while (hasFoundMatchingString && searchStringPosition < searchString.length() && sourceStringPosition < sourceString.length())
        }
lbl37:
        // 1 sources

        if (hasFoundMatchingString && sourceStringPosition == sourceString.length()) {
            while (searchStringPosition < searchString.length() && searchString.charAt(searchStringPosition) == '*') {
                ++searchStringPosition;
            }
        }
        if (searchStringPosition < searchString.length() || sourceStringPosition < sourceString.length()) {
            hasFoundMatchingString = false;
        }
        boolResult.booleanValue = hasFoundMatchingString;
        return boolResult;
    }

    protected int highestCurrentSentenceItemNrInList(int currentSentenceNr, int globalHighestItemNr) {
        int tempItemNr;
        int localHighestItemNr = 0;
        Item searchItem = this.firstActiveItem();
        if (searchItem != null) {
            localHighestItemNr = List.highestCurrentSentenceItemNr(currentSentenceNr, searchItem);
        }
        if ((searchItem = this.firstInactiveItem()) != null && (tempItemNr = List.highestCurrentSentenceItemNr(currentSentenceNr, searchItem)) > localHighestItemNr) {
            localHighestItemNr = tempItemNr;
        }
        if ((searchItem = this.firstArchivedItem()) != null && (tempItemNr = List.highestCurrentSentenceItemNr(currentSentenceNr, searchItem)) > localHighestItemNr) {
            localHighestItemNr = tempItemNr;
        }
        if ((searchItem = this.firstReplacedItem()) != null && (tempItemNr = List.highestCurrentSentenceItemNr(currentSentenceNr, searchItem)) > localHighestItemNr) {
            localHighestItemNr = tempItemNr;
        }
        if ((searchItem = this.firstDeletedItem()) != null && (tempItemNr = List.highestCurrentSentenceItemNr(currentSentenceNr, searchItem)) > localHighestItemNr) {
            localHighestItemNr = tempItemNr;
        }
        if (localHighestItemNr >= globalHighestItemNr) {
            return localHighestItemNr;
        }
        return globalHighestItemNr;
    }

    protected int highestFoundSentenceNrInList(boolean isIncludingDeletedItems, int globalHighestFoundSentenceNr, int maxSentenceNr) {
        int tempSentenceNr;
        int localHighestFoundSentenceNr = 0;
        Item searchItem = this.firstActiveItem();
        if (searchItem != null) {
            localHighestFoundSentenceNr = List.highestFoundSentenceNrInList(maxSentenceNr, searchItem);
        }
        if ((searchItem = this.firstInactiveItem()) != null && (tempSentenceNr = List.highestFoundSentenceNrInList(maxSentenceNr, searchItem)) > localHighestFoundSentenceNr) {
            localHighestFoundSentenceNr = tempSentenceNr;
        }
        if ((searchItem = this.firstArchivedItem()) != null && (tempSentenceNr = List.highestFoundSentenceNrInList(maxSentenceNr, searchItem)) > localHighestFoundSentenceNr) {
            localHighestFoundSentenceNr = tempSentenceNr;
        }
        if ((searchItem = this.firstReplacedItem()) != null && (tempSentenceNr = List.highestFoundSentenceNrInList(maxSentenceNr, searchItem)) > localHighestFoundSentenceNr) {
            localHighestFoundSentenceNr = tempSentenceNr;
        }
        if (isIncludingDeletedItems && (searchItem = this.firstDeletedItem()) != null && (tempSentenceNr = List.highestFoundSentenceNrInList(maxSentenceNr, searchItem)) > localHighestFoundSentenceNr) {
            localHighestFoundSentenceNr = tempSentenceNr;
        }
        if (localHighestFoundSentenceNr >= globalHighestFoundSentenceNr) {
            return localHighestFoundSentenceNr;
        }
        return globalHighestFoundSentenceNr;
    }

    protected byte decrementItemNrRangeInList(int decrementSentenceNr, int startDecrementItemNr, int decrementOffset) {
        if (decrementSentenceNr < 0) {
            return this.startError(1, "The given decrement sentence number is undefined");
        }
        if (startDecrementItemNr <= 0) {
            return this.startError(1, "The given start item number is undefined");
        }
        if (decrementOffset <= 0) {
            return this.startError(1, "The given decrement offset is undefined");
        }
        Item searchItem = this.firstActiveItem();
        if (searchItem != null) {
            this.decrementItemNrRange(decrementSentenceNr, startDecrementItemNr, decrementOffset, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstInactiveItem()) != null) {
            this.decrementItemNrRange(decrementSentenceNr, startDecrementItemNr, decrementOffset, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstArchivedItem()) != null) {
            this.decrementItemNrRange(decrementSentenceNr, startDecrementItemNr, decrementOffset, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstReplacedItem()) != null) {
            this.decrementItemNrRange(decrementSentenceNr, startDecrementItemNr, decrementOffset, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstDeletedItem()) != null) {
            this.decrementItemNrRange(decrementSentenceNr, startDecrementItemNr, decrementOffset, searchItem);
        }
        return 1;
    }

    protected byte decrementSentenceNrsInList(int startSentenceNr) {
        Item searchItem;
        if (startSentenceNr <= 0) {
            return this.startError(1, "The given start sentence number is undefined");
        }
        if (this.highestSentenceNrInList_ == startSentenceNr) {
            --this.highestSentenceNrInList_;
        }
        if ((searchItem = this.firstActiveItem()) != null) {
            this.decrementSentenceNrs(startSentenceNr, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstInactiveItem()) != null) {
            this.decrementSentenceNrs(startSentenceNr, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstArchivedItem()) != null) {
            this.decrementSentenceNrs(startSentenceNr, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstReplacedItem()) != null) {
            this.decrementSentenceNrs(startSentenceNr, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstDeletedItem()) != null) {
            this.decrementSentenceNrs(startSentenceNr, searchItem);
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    protected byte deleteSentencesInList(int lowestSentenceNr) {
        isResultOK = GlobalVariables.result == 1;
        searchItem = this.firstActiveItem();
        if (lowestSentenceNr > 0) ** GOTO lbl19
        return this.startError(1, "The given lowest sentence number is undefined");
lbl-1000:
        // 1 sources

        {
            if (searchItem.activeSentenceNr() >= lowestSentenceNr) {
                if (searchItem.creationSentenceNr() >= lowestSentenceNr) {
                    if (this.deleteItem(searchItem) != 1) {
                        return this.addError(1, "I failed to delete an active item");
                    }
                    searchItem = this.nextListItem_;
                    continue;
                }
                if (searchItem.wasInactiveBefore()) {
                    if (this.inactivateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to inactivate an active item");
                    }
                    searchItem = this.nextListItem_;
                    continue;
                }
                searchItem = searchItem.nextItem;
                continue;
            }
            searchItem = searchItem.nextItem;
lbl19:
            // 5 sources

            ** while (searchItem != null)
        }
lbl20:
        // 1 sources

        searchItem = this.firstInactiveItem();
        while (searchItem != null) {
            if (searchItem.inactiveSentenceNr() >= lowestSentenceNr) {
                if (searchItem.creationSentenceNr() >= lowestSentenceNr) {
                    if (this.deleteItem(searchItem) != 1) {
                        return this.addError(1, "I failed to delete an inactive item");
                    }
                } else if (this.activateItem(searchItem) != 1) {
                    return this.addError(1, "I failed to activate an inactive item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstArchivedItem();
        while (searchItem != null) {
            if (searchItem.archivedSentenceNr() >= lowestSentenceNr) {
                if (searchItem.creationSentenceNr() >= lowestSentenceNr) {
                    if (this.deleteItem(searchItem) != 1) {
                        return this.addError(1, "I failed to delete an archived item");
                    }
                } else {
                    searchItem.clearArchivedSentenceNr();
                    if (searchItem.wasActiveBefore()) {
                        if (this.activateItem(searchItem) != 1) {
                            return this.addError(1, "I failed to activate an archived item");
                        }
                    } else {
                        if (!searchItem.wasInactiveBefore()) {
                            return this.startError(1, "I don't know what to do with an archived item that wasn't active before, nor inactive");
                        }
                        if (this.inactivateItem(searchItem) != 1) {
                            return this.addError(1, "I failed to inactivate an archived item");
                        }
                    }
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstReplacedItem();
        while (searchItem != null) {
            if (searchItem.replacedSentenceNr() >= lowestSentenceNr) {
                if (searchItem.creationSentenceNr() >= lowestSentenceNr) {
                    if (this.deleteItem(searchItem) != 1) {
                        return this.addError(1, "I failed to delete a replaced item");
                    }
                } else if (searchItem.wasActiveBefore()) {
                    if (this.activateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to activate a replaced item");
                    }
                } else if (searchItem.wasInactiveBefore()) {
                    if (this.inactivateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to inactivate a replaced item");
                    }
                } else {
                    if (!searchItem.wasArchivedBefore()) {
                        return this.startError(1, "I don't know what to do with a replaced item that wasn't inactive before, nor archived");
                    }
                    if (this.archiveItem(searchItem) != 1) {
                        return this.addError(1, "I failed to archive a replaced item");
                    }
                }
                searchItem = this.nextListItem_;
                continue;
            }
            if (!isResultOK && searchItem.replacedSentenceNr() == lowestSentenceNr - 1) {
                if (this.deleteItem(searchItem) != 1) {
                    return this.addError(1, "I failed to delete a replaced item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        return 1;
    }

    protected byte redoCurrentSentenceInList() {
        Item searchItem = this.firstActiveItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentInactiveSentenceNr()) {
                if (this.inactivateItem(searchItem) != 1) {
                    return this.addError(1, "I failed to inactivate an active item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            if (searchItem.hasCurrentArchivedSentenceNr()) {
                if (this.archiveItem(searchItem) != 1) {
                    return this.addError(1, "I failed to archive an active item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            if (searchItem.hasCurrentReplacedSentenceNr()) {
                if (this.replaceItem(searchItem) != 1) {
                    return this.addError(1, "I failed to replace an active item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstInactiveItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentActiveSentenceNr()) {
                if (this.activateItem(searchItem) != 1) {
                    return this.addError(1, "I failed to activate an inactive item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            if (searchItem.hasCurrentArchivedSentenceNr()) {
                if (this.archiveItem(searchItem) != 1) {
                    return this.addError(1, "I failed to archive an inactive item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstArchivedItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentActiveSentenceNr()) {
                if (this.activateItem(searchItem) != 1) {
                    return this.addError(1, "I failed to activate an archived item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            if (searchItem.hasCurrentInactiveSentenceNr()) {
                if (this.inactivateItem(searchItem) != 1) {
                    return this.addError(1, "I failed to inactivate an archived item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstReplacedItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentActiveSentenceNr()) {
                if (this.activateItem(searchItem) != 1) {
                    return this.addError(1, "I failed to activate a replaced item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            if (searchItem.hasCurrentInactiveSentenceNr()) {
                if (this.inactivateItem(searchItem) != 1) {
                    return this.addError(1, "I failed to inactivate a replaced item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            if (searchItem.hasCurrentArchivedSentenceNr()) {
                if (this.archiveItem(searchItem) != 1) {
                    return this.addError(1, "I failed to archive a replaced item");
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstDeletedItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentCreationSentenceNr()) {
                if (searchItem.wasActiveBefore()) {
                    if (this.activateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to activate a deleted item");
                    }
                } else if (searchItem.wasInactiveBefore()) {
                    if (this.inactivateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to inactivate a deleted item");
                    }
                } else {
                    if (!searchItem.wasArchivedBefore()) {
                        return this.startError(1, "I don't know what to do with a deleted item that wasn't inactive before, nor archived");
                    }
                    if (this.archiveItem(searchItem) != 1) {
                        return this.addError(1, "I failed to inactivate a deleted item");
                    }
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        return 1;
    }

    protected byte undoCurrentSentenceInList() {
        Item searchItem = this.firstActiveItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentActiveSentenceNr()) {
                if (searchItem.hasCurrentCreationSentenceNr()) {
                    if (this.deleteItem(searchItem) != 1) {
                        return this.addError(1, "I failed to delete an active item");
                    }
                } else {
                    if (!searchItem.hasInactiveSentenceNr()) {
                        return this.startError(1, "I don't know what to do with an active item that isn't current, and wasn't inactive");
                    }
                    if (this.inactivateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to inactivate an active item");
                    }
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstInactiveItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentInactiveSentenceNr()) {
                if (searchItem.hasCurrentCreationSentenceNr()) {
                    if (this.deleteItem(searchItem) != 1) {
                        return this.addError(1, "I failed to delete an inactive item");
                    }
                } else {
                    if (!searchItem.hasActiveSentenceNr()) {
                        return this.startError(1, "I don't know what to do with this inactive item isn't current, and wasn't active");
                    }
                    if (this.activateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to activate an inactive item");
                    }
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstArchivedItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentArchivedSentenceNr()) {
                if (searchItem.hasCurrentCreationSentenceNr()) {
                    if (this.deleteItem(searchItem) != 1) {
                        return this.addError(1, "I failed to delete an archived item");
                    }
                } else if (searchItem.wasActiveBefore()) {
                    if (this.activateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to activate an archived item");
                    }
                } else {
                    if (!searchItem.wasInactiveBefore()) {
                        return this.startError(1, "I don't know what to do with this archived item that wasn't inactive before, nor archived");
                    }
                    if (this.inactivateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to inactivate an archived item");
                    }
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstReplacedItem();
        while (searchItem != null) {
            if (searchItem.hasCurrentReplacedSentenceNr()) {
                if (searchItem.wasActiveBefore()) {
                    if (this.activateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to activate a replaced item");
                    }
                } else {
                    if (!searchItem.wasInactiveBefore()) {
                        return this.startError(1, "I don't know what to do with this replaced item that wasn't active before, nor inactive");
                    }
                    if (this.inactivateItem(searchItem) != 1) {
                        return this.addError(1, "I failed to inactivate a replaced item");
                    }
                }
                searchItem = this.nextListItem_;
                continue;
            }
            searchItem = searchItem.nextItem;
        }
        return 1;
    }

    protected void clearQuerySelectionsInList() {
        Item searchItem = this.firstActiveItem();
        if (searchItem != null) {
            List.clearQuerySelections(searchItem);
        }
        if ((searchItem = this.firstInactiveItem()) != null) {
            List.clearQuerySelections(searchItem);
        }
        if ((searchItem = this.firstArchivedItem()) != null) {
            List.clearQuerySelections(searchItem);
        }
        if ((searchItem = this.firstReplacedItem()) != null) {
            List.clearQuerySelections(searchItem);
        }
    }

    protected void countQueryInList() {
        Item searchItem = this.firstActiveItem();
        while (searchItem != null) {
            if (searchItem.isSelectedByQuery) {
                ++GlobalVariables.nActiveQueryItems;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstInactiveItem();
        while (searchItem != null) {
            if (searchItem.isSelectedByQuery) {
                ++GlobalVariables.nInactiveQueryItems;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstArchivedItem();
        while (searchItem != null) {
            if (searchItem.isSelectedByQuery) {
                ++GlobalVariables.nArchivedQueryItems;
            }
            searchItem = searchItem.nextItem;
        }
        searchItem = this.firstReplacedItem();
        while (searchItem != null) {
            if (searchItem.isSelectedByQuery) {
                ++GlobalVariables.nReplacedQueryItems;
            }
            searchItem = searchItem.nextItem;
        }
    }

    protected void itemQueryInList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, boolean isReferenceQuery, int querySentenceNr, int queryItemNr) {
        Item searchItem;
        if (isSelectingActiveItems && (searchItem = this.firstActiveItem()) != null) {
            List.itemQuery(isSelectingOnFind, isReferenceQuery, querySentenceNr, queryItemNr, searchItem);
        }
        if (isSelectingInactiveItems && (searchItem = this.firstInactiveItem()) != null) {
            List.itemQuery(isSelectingOnFind, isReferenceQuery, querySentenceNr, queryItemNr, searchItem);
        }
        if (isSelectingArchivedItems && (searchItem = this.firstArchivedItem()) != null) {
            List.itemQuery(isSelectingOnFind, isReferenceQuery, querySentenceNr, queryItemNr, searchItem);
        }
        if (isSelectingReplacedItems && (searchItem = this.firstReplacedItem()) != null) {
            List.itemQuery(isSelectingOnFind, isReferenceQuery, querySentenceNr, queryItemNr, searchItem);
        }
    }

    protected void listQueryInList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, StringBuffer queryListStringBuffer) {
        boolean isListIncludedInQuery = this.isIncludingThisList(queryListStringBuffer);
        if (isSelectingOnFind || !isListIncludedInQuery) {
            Item searchItem;
            boolean isSelectingOnFindAndListIncluded;
            boolean bl = isSelectingOnFindAndListIncluded = isSelectingOnFind && isListIncludedInQuery;
            if (isSelectingActiveItems && (searchItem = this.firstActiveItem()) != null) {
                List.listQuery(isSelectingOnFindAndListIncluded, searchItem);
            }
            if (isSelectingInactiveItems && (searchItem = this.firstInactiveItem()) != null) {
                List.listQuery(isSelectingOnFindAndListIncluded, searchItem);
            }
            if (isSelectingArchivedItems && (searchItem = this.firstArchivedItem()) != null) {
                List.listQuery(isSelectingOnFindAndListIncluded, searchItem);
            }
            if (isSelectingReplacedItems && (searchItem = this.firstReplacedItem()) != null) {
                List.listQuery(isSelectingOnFindAndListIncluded, searchItem);
            }
        }
    }

    protected void parameterQueryInList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, int queryParameter) {
        Item searchItem;
        if (isSelectingActiveItems && (searchItem = this.firstActiveItem()) != null) {
            List.parameterQuery(isSelectingOnFind, queryParameter, searchItem);
        }
        if (isSelectingInactiveItems && (searchItem = this.firstInactiveItem()) != null) {
            List.parameterQuery(isSelectingOnFind, queryParameter, searchItem);
        }
        if (isSelectingArchivedItems && (searchItem = this.firstArchivedItem()) != null) {
            List.parameterQuery(isSelectingOnFind, queryParameter, searchItem);
        }
        if (isSelectingReplacedItems && (searchItem = this.firstReplacedItem()) != null) {
            List.parameterQuery(isSelectingOnFind, queryParameter, searchItem);
        }
    }

    protected void wordQueryInList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems) {
        Item searchItem;
        if (isSelectingActiveItems && (searchItem = this.firstActiveItem()) != null) {
            List.wordQuery(isSelectingOnFind, searchItem);
        }
        if (isSelectingInactiveItems && (searchItem = this.firstInactiveItem()) != null) {
            List.wordQuery(isSelectingOnFind, searchItem);
        }
        if (isSelectingArchivedItems && (searchItem = this.firstArchivedItem()) != null) {
            List.wordQuery(isSelectingOnFind, searchItem);
        }
        if (isSelectingReplacedItems && (searchItem = this.firstReplacedItem()) != null) {
            List.wordQuery(isSelectingOnFind, searchItem);
        }
    }

    protected void wordTypeQueryInList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, short queryWordTypeNr) {
        Item searchItem;
        if (isSelectingActiveItems && (searchItem = this.firstActiveItem()) != null) {
            List.wordTypeQuery(isSelectingOnFind, queryWordTypeNr, searchItem);
        }
        if (isSelectingInactiveItems && (searchItem = this.firstInactiveItem()) != null) {
            List.wordTypeQuery(isSelectingOnFind, queryWordTypeNr, searchItem);
        }
        if (isSelectingArchivedItems && (searchItem = this.firstArchivedItem()) != null) {
            List.wordTypeQuery(isSelectingOnFind, queryWordTypeNr, searchItem);
        }
        if (isSelectingReplacedItems && (searchItem = this.firstReplacedItem()) != null) {
            List.wordTypeQuery(isSelectingOnFind, queryWordTypeNr, searchItem);
        }
    }

    protected byte displayQueryResultInList(boolean isOnlyDisplayingWords, boolean isOnlyDisplayingWordReferences, boolean isOnlyDisplayingStrings, boolean isReturnQueryToPosition, short promptTypeNr, short queryWordTypeNr, int queryWidth) {
        Item searchItem = this.firstActiveItem();
        if (searchItem != null) {
            this.displayQueryResult(isOnlyDisplayingWords, isOnlyDisplayingWordReferences, isOnlyDisplayingStrings, isReturnQueryToPosition, promptTypeNr, queryWordTypeNr, queryWidth, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstInactiveItem()) != null) {
            this.displayQueryResult(isOnlyDisplayingWords, isOnlyDisplayingWordReferences, isOnlyDisplayingStrings, isReturnQueryToPosition, promptTypeNr, queryWordTypeNr, queryWidth, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstArchivedItem()) != null) {
            this.displayQueryResult(isOnlyDisplayingWords, isOnlyDisplayingWordReferences, isOnlyDisplayingStrings, isReturnQueryToPosition, promptTypeNr, queryWordTypeNr, queryWidth, searchItem);
        }
        if (GlobalVariables.result == 1 && (searchItem = this.firstReplacedItem()) != null) {
            this.displayQueryResult(isOnlyDisplayingWords, isOnlyDisplayingWordReferences, isOnlyDisplayingStrings, isReturnQueryToPosition, promptTypeNr, queryWordTypeNr, queryWidth, searchItem);
        }
        return GlobalVariables.result;
    }

    protected byte stringQueryInList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, String queryString) {
        Item searchItem;
        if (isSelectingActiveItems && (searchItem = this.firstActiveItem()) != null) {
            this.stringQuery(isSelectingOnFind, queryString, searchItem);
        }
        if (GlobalVariables.result == 1 && isSelectingInactiveItems && (searchItem = this.firstInactiveItem()) != null) {
            this.stringQuery(isSelectingOnFind, queryString, searchItem);
        }
        if (GlobalVariables.result == 1 && isSelectingArchivedItems && (searchItem = this.firstArchivedItem()) != null) {
            this.stringQuery(isSelectingOnFind, queryString, searchItem);
        }
        if (GlobalVariables.result == 1 && isSelectingReplacedItems && (searchItem = this.firstReplacedItem()) != null) {
            this.stringQuery(isSelectingOnFind, queryString, searchItem);
        }
        return GlobalVariables.result;
    }

    protected byte wordReferenceQueryInList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, boolean isSelectingAttachedJustifications, boolean isSelectingJustificationSpecifications, String wordReferenceNameString) {
        Item searchItem;
        if (isSelectingActiveItems && (searchItem = this.firstActiveItem()) != null) {
            this.wordReferenceQuery(isSelectingOnFind, isSelectingAttachedJustifications, isSelectingJustificationSpecifications, wordReferenceNameString, searchItem);
        }
        if (GlobalVariables.result == 1 && isSelectingInactiveItems && (searchItem = this.firstInactiveItem()) != null) {
            this.wordReferenceQuery(isSelectingOnFind, isSelectingAttachedJustifications, isSelectingJustificationSpecifications, wordReferenceNameString, searchItem);
        }
        if (GlobalVariables.result == 1 && isSelectingArchivedItems && (searchItem = this.firstArchivedItem()) != null) {
            this.wordReferenceQuery(isSelectingOnFind, isSelectingAttachedJustifications, isSelectingJustificationSpecifications, wordReferenceNameString, searchItem);
        }
        if (GlobalVariables.result == 1 && isSelectingReplacedItems && (searchItem = this.firstReplacedItem()) != null) {
            this.wordReferenceQuery(isSelectingOnFind, isSelectingAttachedJustifications, isSelectingJustificationSpecifications, wordReferenceNameString, searchItem);
        }
        return GlobalVariables.result;
    }
}

