/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.InputOutput;
import org.mafait.thinknowlogy.Item;
import org.mafait.thinknowlogy.List;
import org.mafait.thinknowlogy.ShortResultType;
import org.mafait.thinknowlogy.SpecificationItem;
import org.mafait.thinknowlogy.WordItem;

class JustificationItem
extends Item {
    boolean hasFeminineOrMasculineProperNounEnding_ = false;
    private short justificationTypeNr_;
    private SpecificationItem primarySpecificationItem_ = null;
    private SpecificationItem anotherPrimarySpecificationItem_ = null;
    private SpecificationItem secondarySpecificationItem_ = null;
    private SpecificationItem anotherSecondarySpecificationItem_ = null;
    private JustificationItem attachedJustificationItem_ = null;
    protected boolean hasJustificationBeenWritten = false;
    protected short orderNr = 0;

    private boolean hasJustification(JustificationItem existingJustificationItem) {
        JustificationItem searchJustificationItem = this;
        while (searchJustificationItem != null) {
            if (searchJustificationItem == existingJustificationItem) {
                return true;
            }
            searchJustificationItem = searchJustificationItem.attachedJustificationItem_;
        }
        return false;
    }

    private static boolean isContextSimilarInContextWords(int firstContextNr, int secondContextNr) {
        WordItem currentContextWordItem;
        if (firstContextNr > 0 && secondContextNr > 0 && firstContextNr != secondContextNr && (currentContextWordItem = GlobalVariables.firstContextWordItem) != null) {
            do {
                if (currentContextWordItem.isContextSimilarInWord(firstContextNr, secondContextNr)) continue;
                return false;
            } while ((currentContextWordItem = currentContextWordItem.nextContextWordItem) != null);
        }
        return true;
    }

    private boolean isSameJustificationType(JustificationItem referenceJustificationItem) {
        return referenceJustificationItem != null && this.orderNr == referenceJustificationItem.orderNr && (this.justificationTypeNr_ == referenceJustificationItem.justificationTypeNr() || this.primarySpecificationItem_ == null && referenceJustificationItem.primarySpecificationItem_ == null && this.isReversibleAssumptionOrConclusion() == referenceJustificationItem.isReversibleAssumptionOrConclusion());
    }

    protected JustificationItem(boolean hasFeminineOrMasculineProperNounEnding, short justificationTypeNr, short _orderNr, int originalSentenceNr, SpecificationItem primarySpecificationItem, SpecificationItem anotherPrimarySpecificationItem, SpecificationItem secondarySpecificationItem, SpecificationItem anotherSecondarySpecificationItem, JustificationItem attachedJustificationItem, List myList, WordItem myWordItem) {
        this.initializeItemVariables(originalSentenceNr, 0, 0, 0, myList, myWordItem);
        this.hasFeminineOrMasculineProperNounEnding_ = hasFeminineOrMasculineProperNounEnding;
        this.justificationTypeNr_ = justificationTypeNr;
        this.primarySpecificationItem_ = primarySpecificationItem;
        this.anotherPrimarySpecificationItem_ = anotherPrimarySpecificationItem;
        this.secondarySpecificationItem_ = secondarySpecificationItem;
        this.anotherSecondarySpecificationItem_ = anotherSecondarySpecificationItem;
        this.attachedJustificationItem_ = attachedJustificationItem;
        this.orderNr = _orderNr;
    }

    @Override
    protected void checkForUsage() {
        this.myWordItem().checkJustificationForUsageInWord(this);
    }

    @Override
    protected void selectingJustificationSpecifications() {
        if (this.primarySpecificationItem_ != null) {
            this.primarySpecificationItem_.isSelectedByJustificationQuery = true;
        }
        if (this.anotherPrimarySpecificationItem_ != null) {
            this.anotherPrimarySpecificationItem_.isSelectedByJustificationQuery = true;
        }
        if (this.secondarySpecificationItem_ != null) {
            this.secondarySpecificationItem_.isSelectedByJustificationQuery = true;
        }
        if (this.anotherSecondarySpecificationItem_ != null) {
            this.anotherSecondarySpecificationItem_.isSelectedByJustificationQuery = true;
        }
    }

    @Override
    protected boolean hasWordType(short queryWordTypeNr) {
        return this.justificationTypeNr_ == queryWordTypeNr;
    }

    @Override
    protected boolean hasReferenceItemById(int querySentenceNr, int queryItemNr) {
        return this.primarySpecificationItem_ != null && (querySentenceNr == 0 || this.primarySpecificationItem_.creationSentenceNr() == querySentenceNr) && (queryItemNr == 0 || this.primarySpecificationItem_.itemNr() == queryItemNr) || this.anotherPrimarySpecificationItem_ != null && (querySentenceNr == 0 || this.anotherPrimarySpecificationItem_.creationSentenceNr() == querySentenceNr) && (queryItemNr == 0 || this.anotherPrimarySpecificationItem_.itemNr() == queryItemNr) || this.secondarySpecificationItem_ != null && (querySentenceNr == 0 || this.secondarySpecificationItem_.creationSentenceNr() == querySentenceNr) && (queryItemNr == 0 || this.secondarySpecificationItem_.itemNr() == queryItemNr) || this.anotherSecondarySpecificationItem_ != null && (querySentenceNr == 0 || this.anotherSecondarySpecificationItem_.creationSentenceNr() == querySentenceNr) && (queryItemNr == 0 || this.anotherSecondarySpecificationItem_.itemNr() == queryItemNr) || this.attachedJustificationItem_ != null && (querySentenceNr == 0 || this.attachedJustificationItem_.creationSentenceNr() == querySentenceNr) && (queryItemNr == 0 || this.attachedJustificationItem_.itemNr() == queryItemNr);
    }

    @Override
    protected StringBuffer itemToStringBuffer(short queryWordTypeNr) {
        this.itemBaseToStringBuffer(queryWordTypeNr);
        if (GlobalVariables.queryStringBuffer == null) {
            GlobalVariables.queryStringBuffer = new StringBuffer();
        }
        StringBuffer queryStringBuffer = GlobalVariables.queryStringBuffer;
        if (this.hasFeminineOrMasculineProperNounEnding_) {
            queryStringBuffer.append(",hasFeminineOrMasculineProperNounEnding");
        }
        switch (this.justificationTypeNr_) {
            case 0: {
                queryStringBuffer.append(",isGeneralizationAssumption");
                break;
            }
            case 1: {
                queryStringBuffer.append(",isOppositePossessiveConditionalSpecificationAssumption");
                break;
            }
            case 2: {
                queryStringBuffer.append(",isExclusiveSpecificationSubstitutionAssumption");
                break;
            }
            case 3: {
                queryStringBuffer.append(",isIndirectlyAnsweredQuestionAssumption");
                break;
            }
            case 4: {
                queryStringBuffer.append(",isSuggestiveQuestionAssumption");
                break;
            }
            case 5: {
                queryStringBuffer.append(",isOnlyOptionLeftAssumption");
                break;
            }
            case 6: {
                queryStringBuffer.append(",isReversibleAssumption");
                break;
            }
            case 7: {
                queryStringBuffer.append(",isDefinitionPartOfAssumption");
                break;
            }
            case 8: {
                queryStringBuffer.append(",isNegativeAssumption");
                break;
            }
            case 9: {
                queryStringBuffer.append(",isSpecificationGeneralizationAssumption");
                break;
            }
            case 10: {
                queryStringBuffer.append(",isSpecificationSubstitutionAssumption");
                break;
            }
            case 11: {
                queryStringBuffer.append(",isSpecificationSubstitutionPartOfAssumption");
                break;
            }
            case 12: {
                queryStringBuffer.append(",isUniqueUserRelationAssumption");
                break;
            }
            case 13: {
                queryStringBuffer.append(",isOnlyOptionLeftConclusion");
                break;
            }
            case 14: {
                queryStringBuffer.append(",isReversibleConclusion");
                break;
            }
            case 15: {
                queryStringBuffer.append(",isDefinitionPartOfConclusion");
                break;
            }
            case 16: {
                queryStringBuffer.append(",isNegativeConclusion");
                break;
            }
            case 17: {
                queryStringBuffer.append(",isSpecificationGeneralizationConclusion");
                break;
            }
            case 18: {
                queryStringBuffer.append(",isSpecificationSubstitutionConclusion");
                break;
            }
            case 19: {
                queryStringBuffer.append(",isSpecificationSubstitutionPartOfConclusion");
                break;
            }
            case 20: {
                queryStringBuffer.append(",isUniqueUserRelationConclusion");
                break;
            }
            case 21: {
                queryStringBuffer.append(",isSpecificationSubstitutionQuestion");
                break;
            }
            default: {
                queryStringBuffer.append(",justificationType:" + this.justificationTypeNr_);
            }
        }
        queryStringBuffer.append("@" + this.justificationTypeNr_);
        queryStringBuffer.append(",orderNr:" + this.orderNr);
        if (this.primarySpecificationItem_ != null) {
            queryStringBuffer.append(",primarySpecificationItem[" + this.primarySpecificationItem_.creationSentenceNr() + ',' + this.primarySpecificationItem_.itemNr() + ']');
        }
        if (this.anotherPrimarySpecificationItem_ != null) {
            queryStringBuffer.append(",anotherPrimarySpecificationItem[" + this.anotherPrimarySpecificationItem_.creationSentenceNr() + ',' + this.anotherPrimarySpecificationItem_.itemNr() + ']');
        }
        if (this.secondarySpecificationItem_ != null) {
            queryStringBuffer.append(",secondarySpecificationItem[" + this.secondarySpecificationItem_.creationSentenceNr() + ',' + this.secondarySpecificationItem_.itemNr() + ']');
        }
        if (this.anotherSecondarySpecificationItem_ != null) {
            queryStringBuffer.append(",anotherSecondarySpecificationItem[" + this.anotherSecondarySpecificationItem_.creationSentenceNr() + ',' + this.anotherSecondarySpecificationItem_.itemNr() + ']');
        }
        if (this.attachedJustificationItem_ != null) {
            queryStringBuffer.append(",attachedJustificationItem[" + this.attachedJustificationItem_.creationSentenceNr() + ',' + this.attachedJustificationItem_.itemNr() + ']');
        }
        return queryStringBuffer;
    }

    protected void clearReplacingInfo() {
        if (this.hasCurrentReplacedSentenceNr()) {
            this.clearReplacedSentenceNr();
        }
    }

    protected boolean hasAttachedJustification() {
        return this.attachedJustificationItem_ != null;
    }

    protected boolean hasFeminineOrMasculineProperNounEnding() {
        return this.hasFeminineOrMasculineProperNounEnding_;
    }

    protected boolean hasJustification(SpecificationItem primarySpecificationItem, SpecificationItem anotherPrimarySpecificationItem, SpecificationItem secondarySpecificationItem, SpecificationItem anotherSecondarySpecificationItem) {
        return this.primarySpecificationItem_ == primarySpecificationItem && this.anotherPrimarySpecificationItem_ == anotherPrimarySpecificationItem && this.secondarySpecificationItem_ == secondarySpecificationItem && this.anotherSecondarySpecificationItem_ == anotherSecondarySpecificationItem;
    }

    protected boolean hasJustification(boolean hasFeminineOrMasculineProperNounEnding, SpecificationItem primarySpecificationItem, SpecificationItem anotherPrimarySpecificationItem, SpecificationItem secondarySpecificationItem, SpecificationItem anotherSecondarySpecificationItem) {
        return this.hasFeminineOrMasculineProperNounEnding_ == hasFeminineOrMasculineProperNounEnding && this.primarySpecificationItem_ == primarySpecificationItem && this.anotherPrimarySpecificationItem_ == anotherPrimarySpecificationItem && this.secondarySpecificationItem_ == secondarySpecificationItem && this.anotherSecondarySpecificationItem_ == anotherSecondarySpecificationItem;
    }

    protected boolean hasNonPossessivePrimarySpecification() {
        return this.primarySpecificationItem_ != null && !this.primarySpecificationItem_.isPossessive();
    }

    protected boolean hasPossessivePrimarySpecification() {
        return this.primarySpecificationItem_ != null && this.primarySpecificationItem_.isPossessive();
    }

    protected boolean hasPossessiveSecondarySpecification() {
        return this.secondarySpecificationItem_ != null && this.secondarySpecificationItem_.isPossessive();
    }

    protected boolean isPrimarySpecificationWordSpanishAmbiguous() {
        return this.primarySpecificationItem_ != null && this.primarySpecificationItem_.isSpecificationWordSpanishAmbiguous();
    }

    protected boolean isUpdatedPrimarySpecificationWordSpanishAmbiguous() {
        WordItem updatedPrimarySpecificationWordItem;
        return this.primarySpecificationItem_ != null && (updatedPrimarySpecificationWordItem = this.primarySpecificationItem_.updatedSpecificationItem().specificationWordItem()) != null && updatedPrimarySpecificationWordItem.isNounWordSpanishAmbiguous();
    }

    protected boolean hasAnotherPrimarySpecification() {
        return this.anotherPrimarySpecificationItem_ != null;
    }

    protected boolean isAssumptionJustification() {
        return this.isAssumption(this.justificationTypeNr_);
    }

    protected boolean isConclusionJustification() {
        return this.isConclusion(this.justificationTypeNr_);
    }

    protected boolean isExclusiveSpecificationSubstitutionAssumption() {
        return this.justificationTypeNr_ == 2;
    }

    protected boolean isGeneralizationAssumption() {
        return this.justificationTypeNr_ == 0;
    }

    protected boolean isNegativeAssumptionOrConclusion() {
        return this.justificationTypeNr_ == 8 || this.justificationTypeNr_ == 16;
    }

    protected boolean isReversibleAssumption() {
        return this.justificationTypeNr_ == 6;
    }

    protected boolean isReversibleConclusion() {
        return this.justificationTypeNr_ == 14;
    }

    protected boolean isReversibleAssumptionOrConclusion() {
        return this.justificationTypeNr_ == 6 || this.justificationTypeNr_ == 14;
    }

    protected boolean isQuestionJustification() {
        return this.justificationTypeNr_ == 21;
    }

    protected boolean isSpecificationSubstitutionAssumption() {
        return this.justificationTypeNr_ == 10;
    }

    protected boolean isSuggestiveQuestionAssumption() {
        return this.justificationTypeNr_ == 4;
    }

    protected short justificationAssumptionGrade() {
        boolean hasPossessivePrimarySpecification = false;
        boolean hasPrimaryQuestionSpecification = false;
        if (this.primarySpecificationItem_ != null) {
            if (this.primarySpecificationItem_.isGeneralizationProperNoun() && this.primarySpecificationItem_.isPossessive()) {
                hasPossessivePrimarySpecification = true;
            }
            if (this.primarySpecificationItem_.isQuestion()) {
                hasPrimaryQuestionSpecification = true;
            }
        }
        return this.assumptionGrade(this.anotherPrimarySpecificationItem_ != null, this.hasFeminineOrMasculineProperNounEnding_, hasPossessivePrimarySpecification, hasPrimaryQuestionSpecification, this.justificationTypeNr_);
    }

    protected short justificationTypeNr() {
        return this.justificationTypeNr_;
    }

    protected short updatedJustificationTypeNr(SpecificationItem newSecondarySpecificationItem) {
        if (this.justificationTypeNr_ == 6 && newSecondarySpecificationItem != null && !newSecondarySpecificationItem.isPossessive() && newSecondarySpecificationItem.isUserSpecification()) {
            return newSecondarySpecificationItem.hasAssumptionLevel() ? (short)6 : 14;
        }
        return this.justificationTypeNr_;
    }

    protected short primarySpecificationAssumptionLevel() {
        return this.primarySpecificationItem_ != null ? this.primarySpecificationItem_.assumptionLevel() : (short)0;
    }

    protected int nJustificationContextRelations(int relationContextNr, int nRelationWords) {
        if (relationContextNr > 0) {
            int secondaryRelationContextNr;
            int primaryRelationContextNr;
            if (this.primarySpecificationItem_ != null && (primaryRelationContextNr = this.primarySpecificationItem_.relationContextNr()) > 0) {
                return this.myWordItem().nContextWords(primaryRelationContextNr, this.primarySpecificationItem_.specificationWordItem());
            }
            if (this.secondarySpecificationItem_ != null && (secondaryRelationContextNr = this.secondarySpecificationItem_.relationContextNr()) > 0) {
                if (this.anotherPrimarySpecificationItem_ != null) {
                    return this.myWordItem().nContextWords(secondaryRelationContextNr, this.secondarySpecificationItem_.specificationWordItem());
                }
                if (JustificationItem.isContextSimilarInContextWords(secondaryRelationContextNr, relationContextNr)) {
                    return nRelationWords;
                }
            }
            return 1;
        }
        return 0;
    }

    protected int primarySpecificationCollectionNr() {
        return this.primarySpecificationItem_ != null ? this.primarySpecificationItem_.specificationCollectionNr() : 0;
    }

    protected int secondarySpecificationCollectionNr() {
        return this.secondarySpecificationItem_ != null ? this.secondarySpecificationItem_.specificationCollectionNr() : 0;
    }

    protected byte attachJustification(JustificationItem attachedJustificationItem, SpecificationItem involvedSpecificationItem) {
        if (attachedJustificationItem == null) {
            return this.startError(1, null, "The given attached justification item is undefined");
        }
        if (attachedJustificationItem == this) {
            return this.startError(1, null, "The given attached justification item is the same justification item as me");
        }
        if (involvedSpecificationItem == null) {
            return this.startError(1, null, "The given involved specification item is undefined");
        }
        if (!this.hasCurrentCreationSentenceNr()) {
            return this.startError(1, null, "It isn't allowed to change an older item afterwards");
        }
        if (!attachedJustificationItem.isActiveItem()) {
            return this.startError(1, null, "The given attached justification item isn't active");
        }
        if (this.attachedJustificationItem_ != null) {
            return this.startError(1, null, "I already have an attached justification item");
        }
        if (involvedSpecificationItem.checkJustification(attachedJustificationItem) != 1) {
            return this.addError(1, null, "I failed to check the given attached justification item against the given involved specification item");
        }
        this.attachedJustificationItem_ = attachedJustificationItem;
        return 1;
    }

    protected byte changeAttachedJustification(JustificationItem newAttachedJustificationItem) {
        this.attachedJustificationItem_ = null;
        if (newAttachedJustificationItem != null && !newAttachedJustificationItem.isActiveItem()) {
            return this.startError(1, null, "The given new attached justification item isn't active");
        }
        if (newAttachedJustificationItem == this) {
            return this.startError(1, null, "The given new attached justification item is the same justification item as me");
        }
        if (!this.hasCurrentCreationSentenceNr()) {
            return this.startError(1, null, "It isn't allowed to change an older item afterwards");
        }
        if (newAttachedJustificationItem == null || !newAttachedJustificationItem.hasJustification(this)) {
            this.attachedJustificationItem_ = newAttachedJustificationItem;
        }
        return 1;
    }

    protected byte changePrimarySpecification(SpecificationItem replacingSpecificationItem) {
        if (replacingSpecificationItem == null) {
            return this.startError(1, null, "The given replacing specification item is undefined");
        }
        if (replacingSpecificationItem.isReplacedOrDeletedItem()) {
            return this.startError(1, null, "The given replacing specification item is replaced or deleted");
        }
        if (!this.hasCurrentCreationSentenceNr()) {
            return this.startError(1, null, "It isn't allowed to change an older item afterwards");
        }
        this.primarySpecificationItem_ = replacingSpecificationItem;
        return 1;
    }

    protected byte changeSecondarySpecification(SpecificationItem replacingSpecificationItem) {
        if (replacingSpecificationItem == null) {
            return this.startError(1, null, "The given replacing specification item is undefined");
        }
        if (replacingSpecificationItem.isReplacedOrDeletedItem()) {
            return this.startError(1, null, "The given replacing specification item is replaced or deleted");
        }
        if (!this.hasCurrentCreationSentenceNr()) {
            return this.startError(1, null, "It isn't allowed to change an older item afterwards");
        }
        this.secondarySpecificationItem_ = replacingSpecificationItem;
        return 1;
    }

    protected byte checkSpecifications(boolean isIncludingReplacedSpecifications) {
        if (this.primarySpecificationItem_ != null) {
            if (isIncludingReplacedSpecifications && this.primarySpecificationItem_.isReplacedItem()) {
                if (this.myWordItem().replaceOrDeleteJustification(this) != 1) {
                    return this.startError(1, null, "I failed to replace or delete an unreferenced justification item with a replaced primary specification");
                }
            } else if (this.primarySpecificationItem_.isDeletedItem() && InputOutput.writeDiacriticalText((short)7, "\nI found a deleted primary specification item:\n\tSpecificationItem: " + this.primarySpecificationItem_.itemToStringBuffer((short)0) + ";\n\tJustificationItem: " + this.itemToStringBuffer((short)0) + ".\n") != 1) {
                return this.startError(1, null, "I failed to write an interface warning");
            }
        }
        if (this.anotherPrimarySpecificationItem_ != null && (this.anotherPrimarySpecificationItem_.isDeletedItem() || isIncludingReplacedSpecifications && this.anotherPrimarySpecificationItem_.isReplacedItem()) && InputOutput.writeDiacriticalText((short)7, "\nI found a replaced or deleted another primary specification item:\n\tSpecificationItem: " + this.anotherPrimarySpecificationItem_.itemToStringBuffer((short)0) + ";\n\tJustificationItem: " + this.itemToStringBuffer((short)0) + ".\n") != 1) {
            return this.startError(1, null, "I failed to write an interface warning");
        }
        if (this.secondarySpecificationItem_ != null) {
            if (isIncludingReplacedSpecifications && this.secondarySpecificationItem_.isReplacedItem()) {
                if (this.myWordItem().replaceOrDeleteJustification(this) != 1) {
                    return this.startError(1, null, "I failed to replace or delete an unreferenced justification item with a replaced secondary specification");
                }
            } else if (this.secondarySpecificationItem_.isDeletedItem() && InputOutput.writeDiacriticalText((short)7, "\nI found a deleted secondary specification item:\n\tSpecificationItem: " + this.secondarySpecificationItem_.itemToStringBuffer((short)0) + ";\n\tJustificationItem: " + this.itemToStringBuffer((short)0) + ".\n") != 1) {
                return this.startError(1, null, "I failed to write an interface warning");
            }
        }
        if (this.anotherSecondarySpecificationItem_ != null && (this.anotherSecondarySpecificationItem_.isDeletedItem() || isIncludingReplacedSpecifications && this.anotherSecondarySpecificationItem_.isReplacedItem()) && InputOutput.writeDiacriticalText((short)7, "\nI found a replaced or deleted another secondary specification item:\n\tSpecificationItem: " + this.anotherSecondarySpecificationItem_.itemToStringBuffer((short)0) + ";\n\tJustificationItem: " + this.itemToStringBuffer((short)0) + ".\n") != 1) {
            return this.startError(1, null, "I failed to write an interface warning");
        }
        return 1;
    }

    protected JustificationItem attachedJustificationItem() {
        return this.attachedJustificationItem_;
    }

    protected JustificationItem attachedPredecessorOfOldJustificationItem(JustificationItem obsoleteJustificationItem) {
        JustificationItem searchJustificationItem = this;
        while (searchJustificationItem != null) {
            if (searchJustificationItem.attachedJustificationItem_ == obsoleteJustificationItem) {
                return searchJustificationItem;
            }
            searchJustificationItem = searchJustificationItem.attachedJustificationItem_;
        }
        return null;
    }

    protected JustificationItem nextJustificationItem() {
        return (JustificationItem)this.nextItem;
    }

    protected JustificationItem nextJustificationItemWithSameTypeAndOrderNr() {
        JustificationItem searchJustificationItem = this.attachedJustificationItem_;
        while (searchJustificationItem != null) {
            if (this.isSameJustificationType(searchJustificationItem)) {
                return searchJustificationItem;
            }
            searchJustificationItem = searchJustificationItem.attachedJustificationItem_;
        }
        return null;
    }

    protected JustificationItem nextJustificationItemWithDifferentTypeOrOrderNr(JustificationItem firstJustificationItem) {
        JustificationItem nextTypeJustificationItem = this.attachedJustificationItem_;
        if (firstJustificationItem != null) {
            while (true) {
                if (nextTypeJustificationItem != null && this.isSameJustificationType(nextTypeJustificationItem)) {
                    nextTypeJustificationItem = nextTypeJustificationItem.attachedJustificationItem_;
                    continue;
                }
                if (nextTypeJustificationItem != null) {
                    JustificationItem usedTypeJustificationItem = firstJustificationItem;
                    while (usedTypeJustificationItem != null && !usedTypeJustificationItem.isSameJustificationType(nextTypeJustificationItem)) {
                        usedTypeJustificationItem = usedTypeJustificationItem.attachedJustificationItem_;
                    }
                    if (usedTypeJustificationItem == nextTypeJustificationItem) {
                        return nextTypeJustificationItem;
                    }
                }
                if (nextTypeJustificationItem == null || (nextTypeJustificationItem = nextTypeJustificationItem.attachedJustificationItem_) == null) break;
            }
        }
        return null;
    }

    protected JustificationItem obsoleteSpanishJustificationItem(SpecificationItem primarySpecificationItem, SpecificationItem secondarySpecificationItem) {
        if (this.primarySpecificationItem_ != null && this.primarySpecificationItem_.isSelfGeneratedQuestion() || this.primarySpecificationItem_ == primarySpecificationItem && secondarySpecificationItem != null && this.secondarySpecificationItem_ != null && this.secondarySpecificationItem_.isSelfGenerated() && this.secondarySpecificationItem_.generalizationWordItem() == secondarySpecificationItem.generalizationWordItem()) {
            return this;
        }
        if (this.attachedJustificationItem_ != null) {
            return this.attachedJustificationItem_.obsoleteSpanishJustificationItem(primarySpecificationItem, secondarySpecificationItem);
        }
        return null;
    }

    protected JustificationItem primarySpecificationWithoutRelationContextJustificationItem(WordItem primarySpecificationWordItem) {
        if (primarySpecificationWordItem != null) {
            if (this.primarySpecificationItem_ != null && (this.primarySpecificationItem_.isReplacedItem() || !this.primarySpecificationItem_.hasRelationContext() && this.primarySpecificationItem_.specificationWordItem() == primarySpecificationWordItem)) {
                return this;
            }
            if (this.attachedJustificationItem_ != null) {
                return this.attachedJustificationItem_.primarySpecificationWithoutRelationContextJustificationItem(primarySpecificationWordItem);
            }
        }
        return null;
    }

    protected SpecificationItem primarySpecificationItem() {
        return this.primarySpecificationItem_;
    }

    protected SpecificationItem anotherPrimarySpecificationItem() {
        return this.anotherPrimarySpecificationItem_;
    }

    protected SpecificationItem secondarySpecificationItem() {
        return this.secondarySpecificationItem_;
    }

    protected SpecificationItem anotherSecondarySpecificationItem() {
        return this.anotherSecondarySpecificationItem_;
    }

    protected SpecificationItem updatedPrimarySpecificationItem() {
        return this.primarySpecificationItem_ != null ? this.primarySpecificationItem_.updatedSpecificationItem() : null;
    }

    protected SpecificationItem updatedSecondarySpecificationItem() {
        return this.secondarySpecificationItem_ != null ? this.secondarySpecificationItem_.updatedSpecificationItem() : null;
    }

    protected WordItem generalizationWordItem() {
        return this.myWordItem();
    }

    protected WordItem primarySpecificationWordItem() {
        return this.primarySpecificationItem_ != null ? this.primarySpecificationItem_.specificationWordItem() : null;
    }

    protected WordItem secondaryGeneralizationWordItem() {
        return this.secondarySpecificationItem_ != null ? this.secondarySpecificationItem_.generalizationWordItem() : null;
    }

    protected ShortResultType getCombinedAssumptionLevel() {
        int assumptionLevel = 0;
        ShortResultType shortResult = new ShortResultType();
        if (this.primarySpecificationItem_ != null) {
            assumptionLevel += this.primarySpecificationItem_.assumptionLevel();
        }
        if (this.anotherPrimarySpecificationItem_ != null) {
            assumptionLevel += this.anotherPrimarySpecificationItem_.assumptionLevel();
        }
        if (this.secondarySpecificationItem_ != null) {
            assumptionLevel += this.secondarySpecificationItem_.assumptionLevel();
        }
        if (this.anotherSecondarySpecificationItem_ != null) {
            assumptionLevel += this.anotherSecondarySpecificationItem_.assumptionLevel();
        }
        if (assumptionLevel < Short.MAX_VALUE) {
            shortResult.shortValue = (short)assumptionLevel;
        } else {
            shortResult.result = this.startSystemError(1, null, "Assumption level overflow");
        }
        return shortResult;
    }
}

