/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.BoolResultType;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.Item;
import org.mafait.thinknowlogy.List;
import org.mafait.thinknowlogy.WordItem;

class GeneralizationItem
extends Item {
    private boolean isLanguageWord_ = false;
    private boolean isRelation_ = false;
    private short languageNr_ = 0;
    private short specificationWordTypeNr_ = 0;
    private short generalizationWordTypeNr_ = 0;
    private WordItem generalizationWordItem_;

    private boolean isNoun() {
        return this.generalizationWordTypeNr_ == 11 || this.generalizationWordTypeNr_ == 12;
    }

    protected GeneralizationItem(boolean isLanguageWord, boolean isRelation, short languageNr, short specificationWordTypeNr, short generalizationWordTypeNr, WordItem generalizationWordItem, List myList, WordItem myWordItem) {
        this.initializeItemVariables(0, 0, 0, 0, myList, myWordItem);
        this.isLanguageWord_ = isLanguageWord;
        this.isRelation_ = isRelation;
        this.languageNr_ = languageNr;
        this.specificationWordTypeNr_ = specificationWordTypeNr;
        this.generalizationWordTypeNr_ = generalizationWordTypeNr;
        this.generalizationWordItem_ = generalizationWordItem;
        if (this.generalizationWordItem_ == null) {
            this.startSystemError(1, null, null, "The given generalization word item is undefined");
        }
    }

    @Override
    protected void displayWordReferences(boolean isReturnQueryToPosition) {
        String wordString;
        if (GlobalVariables.queryStringBuffer == null) {
            GlobalVariables.queryStringBuffer = new StringBuffer();
        }
        if (this.generalizationWordItem_ != null && (wordString = this.generalizationWordItem_.wordTypeString(true, this.generalizationWordTypeNr_)) != null) {
            if (GlobalVariables.hasFoundQuery) {
                GlobalVariables.queryStringBuffer.append(isReturnQueryToPosition ? "\n" : ", ");
            }
            if (!this.isActiveItem()) {
                GlobalVariables.queryStringBuffer.append(this.statusChar());
            }
            GlobalVariables.hasFoundQuery = true;
            GlobalVariables.queryStringBuffer.append(wordString);
        }
    }

    @Override
    protected boolean hasReferenceItemById(int querySentenceNr, int queryItemNr) {
        return this.generalizationWordItem_ == null ? false : !(querySentenceNr != 0 && this.generalizationWordItem_.creationSentenceNr() != querySentenceNr || queryItemNr != 0 && this.generalizationWordItem_.itemNr() != queryItemNr);
    }

    @Override
    protected boolean hasWordType(short queryWordTypeNr) {
        return this.specificationWordTypeNr_ == queryWordTypeNr || this.generalizationWordTypeNr_ == queryWordTypeNr;
    }

    @Override
    protected StringBuffer itemToStringBuffer(short queryWordTypeNr) {
        WordItem thisWordItem = this.myWordItem();
        String generalizationWordTypeString = thisWordItem.wordTypeNameString(this.generalizationWordTypeNr_);
        String languageNameString = thisWordItem.languageNameString(this.languageNr_);
        String specificationWordTypeString = thisWordItem.wordTypeNameString(this.specificationWordTypeNr_);
        this.itemBaseToStringBuffer(queryWordTypeNr);
        if (GlobalVariables.queryStringBuffer == null) {
            GlobalVariables.queryStringBuffer = new StringBuffer();
        }
        StringBuffer queryStringBuffer = GlobalVariables.queryStringBuffer;
        if (this.isLanguageWord_) {
            queryStringBuffer.append(",isLanguageWord");
        }
        if (this.isRelation_) {
            queryStringBuffer.append(",isRelation");
        }
        if (this.languageNr_ > 0) {
            queryStringBuffer.append("," + (languageNameString == null ? "languageNr:" + this.languageNr_ : "language:" + languageNameString));
        }
        queryStringBuffer.append(",specificationWordType:" + (specificationWordTypeString == null ? "" : specificationWordTypeString) + "@" + this.specificationWordTypeNr_);
        queryStringBuffer.append(",generalizationWordType:" + (generalizationWordTypeString == null ? "" : generalizationWordTypeString) + "@" + this.generalizationWordTypeNr_);
        if (this.generalizationWordItem_ != null) {
            queryStringBuffer.append(",generalizationWordItem[" + this.generalizationWordItem_.creationSentenceNr() + ',' + this.generalizationWordItem_.itemNr() + ']');
            String wordString = this.generalizationWordItem_.wordTypeString(true, this.generalizationWordTypeNr_);
            if (wordString != null) {
                queryStringBuffer.append(String.valueOf('`') + wordString + '`');
            }
        }
        return queryStringBuffer;
    }

    @Override
    protected BoolResultType findMatchingWordReferenceString(String queryString) {
        if (this.generalizationWordItem_ != null) {
            return this.generalizationWordItem_.findMatchingWordReferenceString(queryString);
        }
        return new BoolResultType();
    }

    protected boolean isRelation() {
        return this.isRelation_;
    }

    protected GeneralizationItem generalizationItem(boolean isIncludingThisItem, boolean isOnlySelectingCurrentLanguage, boolean isOnlySelectingNoun, boolean isRelation) {
        short currentLanguageNr = GlobalVariables.currentLanguageNr;
        GeneralizationItem searchGeneralizationItem = isIncludingThisItem ? this : this.nextGeneralizationItem();
        while (searchGeneralizationItem != null) {
            if (!(searchGeneralizationItem.isRelation_ != isRelation || isOnlySelectingCurrentLanguage && searchGeneralizationItem.languageNr_ != currentLanguageNr || isOnlySelectingNoun && !searchGeneralizationItem.isNoun())) {
                return searchGeneralizationItem;
            }
            searchGeneralizationItem = searchGeneralizationItem.nextGeneralizationItem();
        }
        return null;
    }

    protected GeneralizationItem nextGeneralizationItem() {
        return (GeneralizationItem)this.nextItem;
    }

    protected GeneralizationItem nextNounSpecificationGeneralizationItem() {
        return this.generalizationItem(false, false, true, false);
    }

    protected GeneralizationItem nextSpecificationGeneralizationItem() {
        return this.generalizationItem(false, false, false, false);
    }

    protected GeneralizationItem nextRelationGeneralizationItem() {
        return this.generalizationItem(false, false, false, true);
    }

    protected WordItem generalizationWordItem() {
        return this.generalizationWordItem_;
    }
}

