/*
 * Decompiled with CFR 0.152.
 */
package thesaurusex;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class Util {
    public static final String SHIFT_JIS_CODE = "Windows-31J";
    private static boolean KANA_KEY_CHECK = true;

    public static void setShiftJisOuput() {
        try {
            PrintStream printStream = new PrintStream((OutputStream)System.out, true, SHIFT_JIS_CODE);
            System.setOut(printStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
    }

    public static void setUTF8Ouput() {
        try {
            PrintStream printStream = new PrintStream((OutputStream)System.out, true, "UTF-8");
            System.setOut(printStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
    }

    static boolean isKana(char c) {
        return '\u3041' <= c && c <= '\u30f6';
    }

    static boolean isKana(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Util.isKana(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String dropKanaPar(String string) {
        return string.replace("\u3010", "").replace("\u3011", "");
    }

    static void setKanaKeyCheck(boolean bl) {
        KANA_KEY_CHECK = bl;
    }

    static String makeKeys(String string, String string2) {
        string = Util.dropKanaPar(string);
        string2 = Util.dropKanaPar(string2);
        String string3 = KANA_KEY_CHECK ? (Util.isKana(string2) ? "\u304b\u306a" : "\u8868\u8a18") : "\u304b\u306a";
        return "<key type=\"\u8868\u8a18\">" + string + "</key><key type=\"" + string3 + "\">" + string2 + "</key>";
    }

    static String makeKeys(String string) {
        String string2;
        String string3;
        if (!string.contains("(") && !string.contains("\uff5e")) {
            return "";
        }
        if (string.equals("606(\u308d\u304f\u307e\u308b\u308d\u304f)\u53f7")) {
            return Util.makeKeys("606\u53f7", "\u308d\u304f\u307e\u308b\u308d\u304f\u53f7");
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(' && n >= 0) {
                int n2 = string.indexOf(41, i + 1);
                if (n2 < 0) {
                    return null;
                }
                boolean bl = true;
                for (int j = i + 1; j < n2; ++j) {
                    if (Util.isKana(string.charAt(j))) continue;
                    bl = false;
                    break;
                }
                stringBuilder.append(string.substring(n, i));
                String string4 = string.substring(i + 1, n2);
                if (bl) {
                    stringBuilder2.append(string4);
                } else {
                    stringBuilder.append(string4);
                    stringBuilder2.append(string.substring(n, i));
                    stringBuilder2.append(string4);
                }
                n = -1;
                i = n2;
                continue;
            }
            if (c <= '\u00ff') {
                stringBuilder2.append(c);
                stringBuilder.append(c);
                continue;
            }
            if (Util.isKana(c)) {
                if (n >= 0) {
                    String string5 = string.substring(n, i);
                    stringBuilder2.append(string5);
                    stringBuilder.append(string5);
                    n = -1;
                }
                stringBuilder2.append(c);
                stringBuilder.append(c);
                continue;
            }
            if (n >= 0) continue;
            n = i;
        }
        if (n >= 0) {
            String string6 = string.substring(n);
            stringBuilder2.append(string6);
            stringBuilder.append(string6);
        }
        if ((string3 = stringBuilder.toString().replace("\uff5e", "")).equals(string2 = stringBuilder2.toString().replace("\uff5e", ""))) {
            if (string.equals(string3)) {
                return "";
            }
            return "<key type=\"\u8868\u8a18\">" + string3 + "</key>";
        }
        return Util.makeKeys(string3, string2);
    }

    private static void test(String string) {
        System.out.println(string + "\t" + Util.makeKeys(string));
    }

    public static void main(String[] stringArray) {
        Util.test("\u8a00\u8449\u8cbb(\u3064\u3044)\u3048");
        Util.test("\u8a00\u8449\u306b\u89d2(\u304b\u3069)\u304c\u3042\u308b");
        Util.test("\u697d(\u3089\u304f)");
        Util.test("\u5584\u60aa(\u3088\u3057\u3042\u3057)\u3010\u8868\u73fe\u8a9e\u53e5\u3011");
    }
}

