/*
 * Decompiled with CFR 0.152.
 */
package thesaurusex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thesaurusex.MakeBodyHtml;
import thesaurusex.MultiTreeMap;
import thesaurusex.Util;

public class MakeIndexHtml {
    private static final Pattern H3 = Pattern.compile("<h3 id=\"([^\"]+)\">[^ ]+ ([^<]+)");
    private static final Pattern P_LINE = Pattern.compile("<p>([0-9]+) (.+)</p>");
    private final MultiTreeMap<String, IndexInfo> indexMap = new MultiTreeMap();
    private final String outputFile;
    private final String bodyFile;
    private final int maxRef;
    private static final Pattern KANA_KANJI = Pattern.compile(">([^\u3010<>]+)\u3010([^\u3011]+)\u3011<");
    private final HashMap<String, String> kanjiKanaMap = new HashMap();
    private static final String KNOWN_KEY_START = "\u3010";
    private static final String KNOWN_KEY_END = "\u3011";
    private final TreeMap<String, Integer> manyRefs = new TreeMap();

    private MakeIndexHtml(String[] stringArray) {
        this.outputFile = stringArray[0];
        this.bodyFile = stringArray[1];
        this.maxRef = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 10000;
    }

    private void parseOutput() throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(new File(this.outputFile));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string = bufferedReader.readLine()) != null && !string.contains(MakeBodyHtml.NIHONGO_SAKUIN_START)) {
        }
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = KANA_KANJI.matcher(string);
            if (!matcher.find() || matcher.group(1).equals(matcher.group(2))) continue;
            this.kanjiKanaMap.put(matcher.group(2), matcher.group(1));
        }
        System.err.println("loaded " + this.kanjiKanaMap.size() + " kanji-kana entries");
        bufferedReader.close();
    }

    private void addWord(LinkedList<String> linkedList, String string) {
        if (string.isEmpty()) {
            return;
        }
        if (string.contains("(") && !string.contains(")")) {
            string = string + ")";
        } else if (!string.contains("(") && string.endsWith(")")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("))")) {
            string = string.substring(0, string.length() - 1);
        }
        linkedList.add(string);
    }

    private LinkedList<String> splitLine(String string) {
        String[] stringArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : stringArray = string.split(" +|\uff1b|;|\\[|\\]|\u2192|\u21d4|\u25cf|\u300c|\u300d|\u3008|\u3009|\u300a|\u300b|\u3002")) {
            int n;
            int n2 = string2.indexOf(40);
            if (n2 >= 0 && (n = string2.indexOf(41, n2 + 1)) > 0) {
                String string3;
                if (n < string2.length() - 1 && string2.charAt(n + 1) == ')') {
                    ++n;
                }
                if (!Util.isKana(string3 = string2.substring(n2 + 1, n))) {
                    for (String string4 : string2.substring(0, n2).split("\u30fb")) {
                        this.addWord(linkedList, string4);
                    }
                    for (String string4 : string3.split("\u30fb")) {
                        this.addWord(linkedList, string4);
                    }
                    if (n >= string2.length()) continue;
                    for (String string4 : string2.substring(n + 1).split("\u30fb")) {
                        this.addWord(linkedList, string4);
                    }
                    continue;
                }
            }
            for (String string5 : string2.split("\u30fb")) {
                linkedList.add(string5);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    private void parseBody() throws Exception {
        CharSequence charSequence;
        String string;
        FileInputStream fileInputStream = new FileInputStream(new File(this.bodyFile));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            if (++n % 10000 == 0) {
                if (n % 100000 == 0) {
                    System.err.print(Integer.toString(n / 100000));
                } else {
                    System.err.print(".");
                }
            }
            if (((Matcher)(object = H3.matcher(string))).find()) {
                string2 = ((Matcher)object).group(1);
                string3 = ((Matcher)object).group(2);
                continue;
            }
            object = P_LINE.matcher(string);
            if (!((Matcher)object).find()) continue;
            string4 = ((Matcher)object).group(1);
            String object2 = ((Matcher)object).group(2);
            if (object2.startsWith("\u25cf")) continue;
            charSequence = object2.replace("<b>", "").replace("</b>", "");
            charSequence = ((String)charSequence).replaceAll("<a [^<]+?</a>", "");
            charSequence = ((String)charSequence).replaceAll("\\([0-9]+\\)", "");
            charSequence = ((String)charSequence).replaceAll("\\([\uff10-\uff19]+\\)", "");
            charSequence = ((String)charSequence).replace("(\u304b\u3089\u7d9a\u304f)", "");
            charSequence = ((String)charSequence).replace("(\u3078\u7d9a\u304f)", "");
            for (String string5 : this.splitLine((String)charSequence)) {
                void var12_16;
                String string6;
                int n2;
                if (string5.isEmpty() || string5.startsWith(KNOWN_KEY_START) && (n2 = string5.indexOf(KNOWN_KEY_END)) > 0 && (string6 = string5.substring(n2 + 1)).isEmpty() || var12_16.length() > 30) continue;
                LinkedList linkedList = this.indexMap.getWithoutNull((String)var12_16);
                if (linkedList.size() < this.maxRef) {
                    boolean bl = false;
                    for (IndexInfo indexInfo : linkedList) {
                        if (!indexInfo.h3key.equals(string2) || !indexInfo.paraIdx.equals(string4)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    IndexInfo indexInfo = new IndexInfo(string2, string3, string4, object2);
                    this.indexMap.put((String)var12_16, indexInfo);
                    continue;
                }
                Integer n3 = this.manyRefs.get(var12_16);
                if (n3 == null) {
                    this.manyRefs.put((String)var12_16, linkedList.size() + 1);
                    continue;
                }
                this.manyRefs.put((String)var12_16, n3 + 1);
            }
        }
        bufferedReader.close();
        System.err.println();
        for (Map.Entry entry : this.manyRefs.entrySet()) {
            System.err.println((String)entry.getKey() + "\t" + entry.getValue());
        }
        n = 0;
        System.out.println("<html><body>");
        for (String string7 : this.indexMap.keySet()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("<dt>");
            ((StringBuilder)charSequence).append(string7);
            String string8 = this.kanjiKanaMap.get(string7);
            if (string8 != null) {
                ((StringBuilder)charSequence).append(KNOWN_KEY_START);
                ((StringBuilder)charSequence).append(string8);
                ((StringBuilder)charSequence).append(KNOWN_KEY_END);
            }
            ((StringBuilder)charSequence).append("</dt>");
            if (string8 == null) {
                ((StringBuilder)charSequence).append(Util.makeKeys(string7));
            }
            ((StringBuilder)charSequence).append("<dd>");
            LinkedList linkedList = this.indexMap.getList(string7);
            if (linkedList.size() >= 100) {
                ((StringBuilder)charSequence).append("<p>\u51fa\u73fe\u56de\u6570: ");
                ((StringBuilder)charSequence).append(linkedList.size());
                ((StringBuilder)charSequence).append("</p>\r\n");
            }
            for (IndexInfo indexInfo : linkedList) {
                ((StringBuilder)charSequence).append("<p>- <a href=\"body.html#");
                ((StringBuilder)charSequence).append(indexInfo.h3key);
                ((StringBuilder)charSequence).append("\">");
                ((StringBuilder)charSequence).append(indexInfo.h3title);
                ((StringBuilder)charSequence).append("</a> ");
                ((StringBuilder)charSequence).append(indexInfo.paraIdx);
                ((StringBuilder)charSequence).append(": ");
                ((StringBuilder)charSequence).append(indexInfo.line.replace("\"#", "\"body.html#"));
                ((StringBuilder)charSequence).append("</p>\r\n");
            }
            ((StringBuilder)charSequence).append("</dd>");
            System.out.println(((StringBuilder)charSequence).toString());
            if (++n % 10000 != 0) continue;
            if (n % 100000 == 0) {
                System.err.print(Integer.toString(n / 100000));
                continue;
            }
            System.err.print(".");
        }
        System.out.println("</body></html>");
        System.err.println();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("java thesaurusex.MakeIndexHtml output.txt body.html [maxRef]");
            System.exit(1);
        }
        MakeIndexHtml makeIndexHtml = new MakeIndexHtml(stringArray);
        try {
            Util.setShiftJisOuput();
            makeIndexHtml.parseOutput();
            makeIndexHtml.parseBody();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class IndexInfo {
        private final String h3key;
        private final String h3title;
        private final String paraIdx;
        private final String line;

        IndexInfo(String string, String string2, String string3, String string4) {
            this.h3key = string;
            this.h3title = string2;
            this.paraIdx = string3;
            this.line = string4;
        }
    }
}

