/*
 * Decompiled with CFR 0.152.
 */
package thesaurusex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thesaurusex.Util;

public class MakeBodyHtml {
    static String NIHONGO_SAKUIN_START = "<1F09><0001><1F41><0160>\u65e5\u672c\u8a9e\u7d22\u5f15<1F61><1F0A>";
    private static String PART_START = "<1F09><0002><1F0A>";
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final String BR = "<br>";
    private static final Pattern CATREF;

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        Character c2 = zenhanMap.get(Character.valueOf(c));
        if (c2 != null) {
            return c2.charValue();
        }
        System.err.println("PROGRAM ERROR: unknown zen2han: <" + c + ">");
        System.exit(1);
        return '#';
    }

    private String ep2html(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                String string2 = string.substring(i + 1, i + 5);
                if (string2.equals("1F04")) {
                    bl = false;
                } else if (string2.equals("1F05")) {
                    bl = true;
                } else if (string2.equals("1FE0")) {
                    stringBuilder.append("<b>");
                } else if (string2.equals("1FE1")) {
                    stringBuilder.append("</b>");
                } else if (string2.equals("1F0A")) {
                    stringBuilder.append(BR);
                } else if (string2.equals("1F42")) {
                    stringBuilder.append("<a>");
                } else if (string2.equals("1F62")) {
                    stringBuilder.append("</a>");
                    bl2 = true;
                }
                i += 5;
                continue;
            }
            if (bl2) {
                if (c != ']') continue;
                bl2 = false;
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(MakeBodyHtml.zen2han(c));
        }
        String string3 = stringBuilder.toString();
        if (string3.length() > BR.length() && string3.endsWith(BR)) {
            return string3.substring(0, string3.length() - BR.length());
        }
        return string3;
    }

    private String fixHrefOfH23(String string, String string2) {
        return string.replace("<a>", "<a href=\"#" + string2 + "\">");
    }

    private String makeHxKey(String string) {
        int n = string.indexOf(32);
        if (n > 0) {
            int n2 = string.indexOf(60, n + 1);
            String string2 = n2 > 0 ? string.substring(n + 1, n2) : string.substring(n + 1);
            String string3 = Util.makeKeys(string2);
            if (!string3.isEmpty()) {
                return string3;
            }
            return "<key type=\"\u8868\u8a18\">" + string2 + "</key>";
        }
        return string;
    }

    private String fixHref(String string) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = CATREF.matcher(string);
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuilder.append(string.substring(n, matcher.start()));
            }
            stringBuilder.append("<a href=\"#");
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("\">");
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("</a>");
            String string2 = matcher.group(3);
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    private void parse(String[] stringArray) throws Exception {
        String string;
        InputStream inputStream = stringArray.length > 0 && !stringArray[0].equals("-") ? new FileInputStream(new File(stringArray[0])) : System.in;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "Windows-31J"));
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        String string2 = "";
        String string3 = "";
        System.out.println("<html><body>");
        while ((string = bufferedReader.readLine()) != null) {
            if (string.isEmpty()) continue;
            if (string.startsWith("[")) {
                int n4 = string.indexOf(93);
                if (n4 < 0) {
                    System.err.println("*** INVALID LINE: " + string);
                    System.exit(1);
                }
                string = string.substring(n4 + 1);
            }
            if (string.equals(PART_START)) {
                bl = true;
                continue;
            }
            if (string.equals(NIHONGO_SAKUIN_START)) break;
            String string4 = this.ep2html(string);
            if (string4.matches("^[IVX]+ .+")) {
                string2 = Integer.toString(++n);
                System.out.println("<h1 id=\"" + string2 + "\">" + string4 + "</h1>");
                System.out.println(this.makeHxKey(string4));
                bl2 = true;
                continue;
            }
            if (bl) {
                String string5;
                bl = false;
                if (string4.length() > 4 && string4.charAt(4) == ' ') {
                    string3 = string4.substring(0, 4);
                    int n5 = Integer.parseInt(string3);
                    if (n5 % 100 == 0) {
                        System.err.print(n5 + " ");
                    }
                    string5 = this.fixHrefOfH23(string4, string2);
                    System.out.println("<h2 id=\"" + string3 + "\">" + string5 + "</h2>");
                    System.out.println(this.makeHxKey(string5));
                    bl2 = true;
                    continue;
                }
                if (string4.length() > 7 && string4.charAt(4) == '.' && string4.charAt(7) == ' ') {
                    String string6 = string4.substring(0, 7);
                    string5 = this.fixHrefOfH23(string4, string3);
                    System.out.println("<h3 id=\"" + string6 + "\">" + string5 + "</h3>");
                    System.out.println(this.makeHxKey(string5));
                    bl2 = false;
                    n2 = 0;
                    continue;
                }
                System.out.println(this.fixHref(string4));
                continue;
            }
            if (!bl2) {
                System.out.println("<p>" + ++n2 + " " + this.fixHref(string4) + "</p>");
                if (n3 >= n2) continue;
                n3 = n2;
                continue;
            }
            if (n <= 0) continue;
            System.out.println("<p>" + this.fixHref(string4) + "</p>");
        }
        System.out.println("</body></html>");
        System.err.println();
    }

    public static void main(String[] stringArray) {
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        try {
            Util.setShiftJisOuput();
            Util.setKanaKeyCheck(false);
            makeBodyHtml.parse(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\u30fc'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        CATREF = Pattern.compile("<a>([0-9]{4}(\\.[0-9]{2})?)( [^<]+)?</a>");
    }
}

