<?php
/********************************************************************************
 * mgallery
 * http://tgallery.sourceforge.jp
 * 
 * require PEAR::HTTP::Requst
 *
 * $Id: MixiSite.class.php,v 1.4 2005/09/24 16:53:43 junneko Exp $
 ********************************************************************************/

require_once 'HTTP/Request.php';

class MixiSite {

	function MixiSite(){
	
		$this->_httpRequest = & new HTTP_Request();
	
	}

	function setLoginCookie($cookies){
		$_SESSION['mixi']['cookies'] = $cookies;	
	}
	function login( $account, $password ){

		$url = "http://mixi.jp/login.pl";
		$params = array( "email"=>$account,"password"=>$password,
		                 "next_url"=>"/home.pl");
		$ret = $this->sendRequest($url,HTTP_REQUEST_METHOD_POST,$params);

		if( PEAR::isError( $ret )){
			return $ret;
		}
		// TODO junneko ޤʤ
		$cookies = $this->_httpRequest->getResponseCookies();
		
		if( ! is_array($cookies)){
			return false;
		}
		$bfSession = $bfStamp = true;
		foreach( $cookies as $cookie ){
			if( $cookie['name'] == 'BF_SESSION')
				$bfSession =  true;
			if( $cookie['name'] == 'BF_STAMP' )
				$bfStamp = true;
		}
		
		if( $bfSession && $bfStamp ){  
			$_SESSION['mixi']['cookies'] = $cookies;
			return true;
		}
		
		return false;
	}
	
	function getAlbumImages($userId){

		if( ! $this->isLogin()){
			return PEAR::raiseError("login error");
		}
		
		if( is_array( $_SESSION['mixi']['album'.$userId] )){
			return $_SESSION['mixi']['album'.$userId];
		}		
		
		$req = & $this->_httpRequest;
		
		$url = 'http://mixi.jp/list_album.pl?id='. $userId;
		$res = $this->sendRequest( $url, HTTP_REQUEST_METHOD_GET, null );
		if( PEAR::isError( $res )){
			return $res;
		}
		
		$regs = array();
		preg_match_all('/<a HREF="(view_album\.pl\?id=[0-9]+&mode=photo)">̿<\/a>/', $res, $regs );
		
		if( ! is_array( $regs[1] )){
			return array();
		}

		$arr = array();
		foreach( $regs[1] as $albumurl ){
			for($page=1;;$page++){
				$url = "http://mixi.jp/".$albumurl."&page=".$page;
			
				$res = $this->sendRequest( $url, HTTP_REQUEST_METHOD_GET, null );
				if( PEAR::isError( $res )){
					return $res;
				}
				$regs = array();
				preg_match_all('/(http:\/\/img[0-9]+\.mixi\.jp\/[^\')>]+s\.jpg)/', $res, $regs);

				if( ! is_array($regs[0])){
					break;
				}
				for($i=0;$i<count($regs[0]);$i++){
					$arr[] = $regs[0][$i];
				}
				if( preg_match('/ɽ/',$res)){
					continue;
				}
				break;
			}
		}
		
		$arr = array_unique($arr);
		$result = array();
		foreach( $arr as $row ){
			
			$regs = array();
			preg_match( '/([0-9]+)_([0-9]+)s\.jpg$/', $row, $regs );
			$link = 'http://mixi.jp/view_album_photo.pl?album_id='.$regs[1].'&number='.$regs[2];

			$result[] = array( 'link'=>$link, 
                                'urlimg'=>preg_replace( '/s\.jpg$/', '.jpg', $row ), 'urlimgs'=>$row );
		}
		
		$_SESSION['mixi']['album'.$userId] = $result;
		
		return $result;
	}
	
	function getFriendIdFromAlbumId($albumId){
	
		if( ! $this->isLogin()){
			return PEAR::raiseError("login error");
		}

		$url = 'http://mixi.jp/view_album.pl?id='. $albumId;
		$res = $this->sendRequest( $url, HTTP_REQUEST_METHOD_GET, null );
		if( PEAR::isError( $res )){
			return $res;
		}
	
	    if( preg_match( '/<a HREF="show_friend\.pl\?id=([0-9]+)"/',$res, $regs )){
	    	return $regs[1];
	    }
	    
	    return PEAR::raiseError('not found friendid');
	}
	
	function logout(){
		$_SESSION['mixi'] = null;
	}
	function isLogin(){
//print_r2($_SESSION);
		if( ! is_array($_SESSION['mixi']['cookies'])){
			return false;
		}
		return true;
	}
	
	function sendRequest($url,$method,$params){

			$req = & $this->_httpRequest;
			$req->setMethod($method);
			$req->setURL($url);
			$req->clearPostData();
			
			
			if( (!is_null($params)) && is_array( $params )){
				foreach( $params as $k=>$v ){
					$req->addPostData( $k, $v );
				}
			}
			
			$cookies = $_SESSION['mixi']['cookies'];
			if( is_array( $cookies )){
				foreach ($cookies as $cookie) {
					$req->addCookie($cookie['name'], $cookie['value']);
				}
			}
			$ret = $req->sendRequest();
			if( PEAR::isError( $ret )){
				return $ret;
			}
			
			return $req->getResponseBody();	
	}
}

?>