/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.banana;

import java.awt.Frame;
import java.io.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 *
 * @author t-nishioka
 */
public class StringParser implements IAreaParser {


	//文字コード
	final String  CHAR_SET_UTF8="UTF-8" ;
	final String  CHAR_SET_EUCJP="EUC_JP" ;
	final String  CHAR_SET_SHIFTJIS="Shift-JIS" ;

	String _text = "";
	File _file = null;
	Frame _frame = null;
	String _getBeginText = "";
	String _getEndText = "";
	String _charset = "";

	public StringParser(String target,String targetEnd,File f){


			target=target.replace(".", "\\.");
			target=target.replace("^", "\\^");
			target=target.replace("$", "\\$");
			target=target.replace("[", "\\[");
			target=target.replace("]", "\\]");
			target=target.replace("*", "\\*");
			target=target.replace("+", "\\+");
			target=target.replace("?", "\\?");
			target=target.replace("|", "\\|");
			target=target.replace("(", "\\(");
			target=target.replace(")", "\\)");

			targetEnd=targetEnd.replace(".", "\\.");
			targetEnd=targetEnd.replace("^", "\\^");
			targetEnd=targetEnd.replace("$", "\\$");
			targetEnd=targetEnd.replace("[", "\\[");
			targetEnd=targetEnd.replace("]", "\\]");
			targetEnd=targetEnd.replace("*", "\\*");
			targetEnd=targetEnd.replace("+", "\\+");
			targetEnd=targetEnd.replace("?", "\\?");
			targetEnd=targetEnd.replace("|", "\\|");
			targetEnd=targetEnd.replace("(", "\\(");
			targetEnd=targetEnd.replace(")", "\\)");

		_getBeginText = target;
		_getEndText=targetEnd;
		_file=f;
	}


	@Override
	public void Parse( ) throws FileNotFoundException, IOException {

		String textFile = "";
		String s;
		FileReader f;

		//文字コードが指定されていない場合はUTF8に指定
		if( _charset==null || _charset.equals("")){
			_charset=CHAR_SET_UTF8;
		}

		//ファイルを文字コード指定で1行ずつ内容読み込み
		BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(_file),_charset));
		 while ((s = br.readLine()) != null) {
			textFile += s+System.getProperty("line.separator");	//プラットフォームに適した改行コード
		}
		br.close();

		//範囲取得パターンを作成
		//Pattern pattern = Pattern.compile("<!\\-\\-i\\-Infomation\\[\\-\\->((.|\n|\r\n)*)<!\\-\\-\\]i\\-Infomation\\-\\->",Pattern.UNIX_LINES);
		String regexPattern= _getBeginText+"(.*)" +_getEndText;

		//取得した文字を設定
		Pattern pattern = Pattern.compile(regexPattern,Pattern.DOTALL );
		Matcher m =pattern.matcher(textFile) ;
		if( m.find()){
			_text = m.group(1);
		}
	}

	@Override
	public String getArea() {
		return _text;
	}


	@Override
	public void setInCharset(String charset) {
			_charset=charset;
	}

}

