#pragma once

#include	"Document/Document.h"
#include	"NodePropertyWnd.h"
#include	"LinkPropertyWnd.h"
#include	"OutputXmlWnd.h"

using namespace icubic;
using namespace document;

class CPropertiesToolBar : public CMFCToolBar
{
public:
	virtual void OnUpdateCmdUI(CFrameWnd* /*pTarget*/, BOOL bDisableIfNoHndler)
	{
		CMFCToolBar::OnUpdateCmdUI((CFrameWnd*) GetOwner(), bDisableIfNoHndler);
	}

	virtual BOOL AllowShowOnList() const { return FALSE; }
};
/**************************************************************************************************
"CPropertiesWnd" class 
**************************************************************************************************/
class CPropertiesWnd : public CDockablePane , public ICallback
{

// member variable
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;
	unsigned int				m_item_id;
	
	CPropertiesToolBar			m_wndToolBar;
	CNodePropertyWnd			m_node_property;
	CLinkPropertyWnd			m_link_property;

// private functions
private:
//=================================================================================================
void cb_call Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		);
//=================================================================================================
void AdjustLayout();
//=================================================================================================
void SetVSDotNetLook(BOOL bSet);

// public functions
public:
//=================================================================================================
CPropertiesWnd();
//=================================================================================================
virtual 
~CPropertiesWnd();

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnExpandAllProperties();
	afx_msg void OnUpdateExpandAllProperties(CCmdUI* pCmdUI);
	afx_msg void OnSortProperties();
	afx_msg void OnUpdateSortProperties(CCmdUI* pCmdUI);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
};

