
#pragma once

#include "Document/Document.h"

using namespace icubic;
using namespace document;

/**************************************************************************************************
"CParserCtrlView" class 
**************************************************************************************************/
class CParserCtrlView : public CTreeCtrl , public ICallback
{
// member variable
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;
	HTREEITEM					m_dragitem;
	int							m_insertflag;
	CImageList*					m_dragimage;
	CImageList					m_imagelist;
	
// private functions
private:	
//=================================================================================================
void cb_call Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		);
//=================================================================================================
HTREEITEM CParserCtrlView::SearchItem
		(
		HTREEITEM		hitem , 
		unsigned int	lparam
		);
//=================================================================================================
void CParserCtrlView::UpdateItem
		(
		HTREEITEM				hitem , 
		treedata::iTreeNode&	node
		);
//=================================================================================================
void CParserCtrlView::UpdateItems();
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanNewGroup
		(
		HTREEITEM	hitem
		);
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanNewParser
		(
		HTREEITEM	hitem
		);
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanRename
		(
		HTREEITEM	hitem
		);
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanDeleteItem
		(
		HTREEITEM	hitem
		);
//=================================================================================================
iParserDoc CParserCtrlView::CanSetStart
		(
		HTREEITEM	hitem
		);
//=================================================================================================
bool CParserCtrlView::CanInsert
		(
		HTREEITEM				htgt , 
		HTREEITEM				hsrc , 
		int						flag ,		//!< [in] 0 : child , 1:up , 2: down
		treedata::iTreeNode*	p	= 0 , 
		treedata::iTreeNode*	c	= 0 , 
		int*					insertpos	= 0
		);
//=================================================================================================
void CParserCtrlView::Insert
		(
		HTREEITEM	hparent , 
		HTREEITEM	hitem , 
		int			flag
		);
//=================================================================================================
treedata::iTreeNode CParserCtrlView::IsParser
		(
		HTREEITEM	hitem
		);
//=================================================================================================
void CParserCtrlView::OpenParserEdit();

// public functions
public:
//=================================================================================================
bool CParserCtrlView::CanNewGroup();
//=================================================================================================
bool CParserCtrlView::CanNewParser();
//=================================================================================================
bool CParserCtrlView::CanRename();
//=================================================================================================
bool CParserCtrlView::CanDeleteItem();
//=================================================================================================
bool CParserCtrlView::CanSetStart();
//=================================================================================================
void CParserCtrlView::NewGroup();
//=================================================================================================
void CParserCtrlView::NewParser();
//=================================================================================================
void CParserCtrlView::Rename();
//=================================================================================================
void CParserCtrlView::DeleteItem();
//=================================================================================================
void CParserCtrlView::SetStart();
//=================================================================================================
iItem CParserCtrlView::CanCopy();
//=================================================================================================
bool CParserCtrlView::Copy();
//=================================================================================================
iItem CParserCtrlView::CanPaste();
//=================================================================================================
bool CParserCtrlView::Paste();

// MFC functions
public:
	CParserCtrlView();
	virtual 
	~CParserCtrlView();

// oeverride functions
protected:
	virtual 
	BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual 
	BOOL PreCreateWindow(CREATESTRUCT& cs);

// message map
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTvnItemexpanded(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTvnEndlabeledit(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTvnBeginlabeledit(NMHDR *pNMHDR, LRESULT *pResult);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnTvnBegindrag(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnCancelMode();
	afx_msg void OnContextMenu(CWnd* /*pWnd*/, CPoint /*point*/);
	afx_msg void OnNMRClick(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNewFolder();
	afx_msg void OnNewFolderUpdate(CCmdUI* pCmdUI);
	afx_msg void OnNewParser();
	afx_msg void OnNewParserUpdate(CCmdUI* pCmdUI);
	afx_msg void OnRename();
	afx_msg void OnRenameUpdate(CCmdUI* pCmdUI);
	afx_msg void OnDelete();
	afx_msg void OnDeleteUpdate(CCmdUI* pCmdUI);
	afx_msg void OnSetStart();
	afx_msg void OnSetStartUpdate(CCmdUI* pCmdUI);
	afx_msg void OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnDestroy();

	afx_msg BOOL OnEditDeleteEx(UINT nID);
	afx_msg void OnUpdateEditDelete(CCmdUI *pCmdUI);
	afx_msg BOOL OnEditCut(UINT nID);
	afx_msg void OnUpdateEditCut(CCmdUI *pCmdUI);
	afx_msg BOOL OnEditCopy(UINT nID);
	afx_msg void OnUpdateEditCopy(CCmdUI *pCmdUI);
	afx_msg BOOL OnEditPaste(UINT nID);
	afx_msg void OnUpdateEditPaste(CCmdUI *pCmdUI);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
};
