
// ParseEditFrm.cpp : CParseEditFrame NX̎
//

#include "stdafx.h"
#include "Texml.h"

#include "ParseEditFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


/**************************************************************************************************
"CParseEditFrame" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map

IMPLEMENT_DYNCREATE(CParseEditFrame, CMDIChildWndEx)

BEGIN_MESSAGE_MAP(CParseEditFrame, CMDIChildWndEx)
	ON_COMMAND(ID_FILE_CLOSE, &CParseEditFrame::OnFileClose)
	ON_WM_SETFOCUS()
	ON_WM_CREATE()
	ON_WM_MDIACTIVATE()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call CParseEditFrame::Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::ModifyTreeItem )
		UpdateTitle();
	else if( type == ICallback::DeleteTreeItem )
	{
		if( false == m_document->SearchTreeId( m_item_id ) )
			SendMessage(WM_CLOSE);
	}
	else if( type == ICallback::New 
	     ||  type == ICallback::Load )
	{
		SendMessage(WM_CLOSE);
	}
	else if( type == ICallback::Redo
	      || type == ICallback::Undo )
	{
		if( false == m_document->SearchTreeId( m_item_id ) )
			SendMessage(WM_CLOSE);
		else
			UpdateTitle();
	}
}
//=================================================================================================
void cb_call CParseEditFrame::UpdateTitle()
{
	iItem	item = (iItem)m_document->SearchTreeId( m_item_id );
	if( item == true && item->m_type == IItem::Parser )
	{
		iParserDoc	parser = (iParserDoc)item;
		SetWindowText( parser->GetName().c_str() );
	}
	else
	{
		SetWindowText( _T("---") );
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CParseEditFrame::CParseEditFrame() : 
		m_item_id( 0 )
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
}
//=================================================================================================
CParseEditFrame::~CParseEditFrame()
{
}
//=================================================================================================
unsigned int CParseEditFrame::GetTargetItemId()
{
	return m_wndView.GetTargetItemId();
}
//=================================================================================================
void CParseEditFrame::Initialize
		(
		unsigned int	item_id
		)
{
	m_item_id	= item_id;
	UpdateTitle();
	m_wndView.Initialize( item_id );
}
//=================================================================================================
#ifdef _DEBUG
void CParseEditFrame::AssertValid() const
{
	CMDIChildWndEx::AssertValid();
}
void CParseEditFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWndEx::Dump(dc);
}
#endif //_DEBUG
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override functions
//=================================================================================================
BOOL CParseEditFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIChildWndEx::PreCreateWindow(cs) )
		return FALSE;

	cs.style &= ~(LONG)FWS_ADDTOTITLE;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}
//=================================================================================================
BOOL CParseEditFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	// r[ɍŏɃR}h@^܂B
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;
	
	// ȊȌꍇ́Ȁs܂B
	return CMDIChildWndEx::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
void CParseEditFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
	__super::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);

	m_document->Callback
			( 
			ICallback::SetPropertyItem , 
			m_wndView.GetPropertyItem() , 
			(void*)&ICallback::SetPropertyItemParam( m_wndView.GetParserId() , m_wndView.GetPropertyId() ) 
			);
}
//=================================================================================================
int CParseEditFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWndEx::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// t[̃NCAg̈Ŝ߂r[쐬܂B
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW, 
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("view create error.\n");
		return -1;
	}

	return 0;
}
//=================================================================================================
void CParseEditFrame::OnSetFocus(CWnd* pOldWnd) 
{
	CMDIChildWndEx::OnSetFocus(pOldWnd);
	m_wndView.SetFocus();
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC command handler
//=================================================================================================
void CParseEditFrame::OnFileClose() 
{
	SendMessage(WM_CLOSE);
}



