#pragma once

#include	"OutputXmlCtrlWnd.h"

/**************************************************************************************************
"COutputXmlToolBar" class 
**************************************************************************************************/
class COutputXmlToolBar : public CMFCToolBar
{
	virtual void OnUpdateCmdUI(CFrameWnd* pTarget , BOOL bDisableIfNoHndler)
	{
		CMFCToolBar::OnUpdateCmdUI((CFrameWnd*) GetOwner(), bDisableIfNoHndler);
	}
	virtual BOOL AllowShowOnList() const { return FALSE; }
};
/**************************************************************************************************
"COutputXmlWnd" class 
**************************************************************************************************/
class COutputXmlWnd : public CDockablePane , public ICallback
{
	DECLARE_DYNAMIC(COutputXmlWnd)

// variable member
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;

	COutputXmlToolBar	m_toolbar;
	COutputXmlCtrlWnd	m_xmlwnd;

// private functions
private:
//=================================================================================================
void cb_call COutputXmlWnd::Callback
		(
		ICallback::Type	type , 
		object&			obj , 
		void*			param
		);
//=================================================================================================
void COutputXmlWnd::Show();
//=================================================================================================
void AdjustLayout();
//=================================================================================================
void COutputXmlWnd::OnChangeVisualStyle();

// public functions
public:
	COutputXmlWnd();
	virtual ~COutputXmlWnd();

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnExpandAll();
	afx_msg void OnExpandAllUpdate(CCmdUI* pCmdUI);
	afx_msg void OnCollapseAll();
	afx_msg void OnCollapseAllUpdate(CCmdUI* pCmdUI);
};


