/*************************************************************************************************/
/*!
   	@file		ComBase.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne
#define		cb_comcall	STDMETHODCALLTYPE


#define		cb_combase_begin()								\
protected:													\
HRESULT cb_comcall QueryInterface							\
		(													\
		REFIID	riid,										\
		void**	object										\
		)													\
{

#define		cb_combase_interface( t_guid , t_interface )	\
	if( IsEqualIID( riid , t_guid ) )						\
	{														\
		AddRef();											\
		*object	= static_cast<t_interface*>(this);			\
		return S_OK;										\
	}

#define		cb_combase_end( t_super_class )					\
	return t_super_class::QueryInterface( riid , object );	\
}															\
ULONG cb_comcall AddRef()									\
{															\
	return t_super_class::AddRef();							\
}															\
ULONG cb_comcall Release()									\
{															\
	return t_super_class::Release();						\
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ComBase" class 
**************************************************************************************************/
cb_align( 4 )
class ComBase : public IUnknown
{
// variable member
private:
	LONG		m_count;
	
// private functions
private:

// "IUnknown" interface functions
public:
//=================================================================================================
virtual
HRESULT cb_comcall QueryInterface
		(
		REFIID	riid, 
		void**	object
		)
{
	if( IsEqualIID(riid, IID_IUnknown) )
	{
		AddRef();
		*object	= static_cast<IUnknown*>(this);
		return S_OK;
	}
	return E_NOINTERFACE;
}
//=================================================================================================
virtual
ULONG cb_comcall AddRef()
{
	return cb_atomic_increment( &m_count );
}
//=================================================================================================
virtual
ULONG cb_comcall Release()
{
	LONG	r = cb_atomic_decrement( &m_count );
	if( r == 0 )
		delete this;
	return r;
}
// public functions
public:
//=================================================================================================
ComBase() : m_count( 1 )
{
}
//=================================================================================================
virtual
~ComBase()
{
}

};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
