#!/usr/bin/env ruby
#
#=remoteTestLink UnitTest
#
# Author::    garyo  (mailto:garyohosu@gmail.com)
# Copyright:: Copyright (c) 2008 garyo
# License::   GPL

$LOAD_PATH << File.dirname(__FILE__) + '/..'
#require 'rubygems'
#require 'TestLinkClient'
require '../TestLinkClient.rb'


require 'test/unit'

ServerURL="http://133.100.20.144/testlink_18RC1"
Dev_key="413a5f43341a85076591f166501740ec"

#remoteTestLink̃eXg
class Test_remoteTestLink < Test::Unit::TestCase

  def setup
    @rtl = TestLinkClient.new(ServerURL,Dev_key)
  end

  # tltestcase:: setPassStatus
  # tlsummary:: pݒ
  # tlsteps:: eXgP[X pݒ
  # tlexpectedresults:: ɏI邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_setPassStatus()
    @rtl.reportTCResultByTCName("setPassStatus","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "p" "sayHello"`
    msg="[{\"message\"=>\"Success!\", \"status\"=>true"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("setPassStatus","Test_remoteTestLink","p")
  end


  # tltestcase:: setFalseStatus
  # tlsummary:: fݒ
  # tlsteps:: eXgP[X fݒ
  # tlexpectedresults:: ɏI邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_setFalseStatus()
    @rtl.reportTCResultByTCName("setFalseStatus","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "f" "sayHello"`
    msg="[{\"message\"=>\"Success!\", \"status\"=>true"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("setFalseStatus","Test_remoteTestLink","p")
  end
  
  # tltestcase:: setBlockStatus
  # tlsummary:: bݒ
  # tlsteps:: eXgP[X bݒ
  # tlexpectedresults:: ɏI邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_setBlockStatus()
    @rtl.reportTCResultByTCName("setBlockStatus","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "b" "sayHello"`
    msg="[{\"message\"=>\"Success!\", \"status\"=>true"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("setBlockStatus","Test_remoteTestLink","p")
  end

  # tltestcase:: setPassStatusWithTestSuite
  # tlsummary:: pݒ eXgXC[gt
  # tlsteps:: eXgP[X pݒ
  # tlexpectedresults:: ɏI邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_setPassStatusWithTestSuite()
    @rtl.reportTCResultByTCName("setPassStatusWithTestSuite","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "p" "sayHello" "Test_TestLinkClient"`
    msg="[{\"message\"=>\"Success!\", \"status\"=>true"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("setPassStatusWithTestSuite","Test_remoteTestLink","p")
  end

  # tltestcase:: setPassStatusWithTestSuiteAndNotes
  # tlsummary:: Rgݒ eXgXC[gt
  # tlsteps:: Rgݒ
  # tlexpectedresults:: ɏI邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_setPassStatusWithTestSuiteAndNotes()
    @rtl.reportTCResultByTCName("setPassStatusWithTestSuiteAndNotes","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "p" "sayHello" "Test_TestLinkClient" -c "note message"`
    msg="[{\"message\"=>\"Success!\", \"status\"=>true"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("setPassStatusWithTestSuiteAndNotes","Test_remoteTestLink","p")
  end

  # tltestcase:: wrongTestCaseName
  # tlsummary:: eXgP[Xs
  # tlsteps:: ݂ȂeXgP[Xݒ
  # tlexpectedresults:: G[ɂȂ邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_wrongTestCaseName()
    @rtl.reportTCResultByTCName("wrongTestCaseName","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "p" "sayHello1" "Test_TestLinkClient"`
    msg="[{\"message\"=>\"The Test Case ID (tcid) provided does not exist!\", \"code\"=>5000}]\n"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("wrongTestCaseName","Test_remoteTestLink","p")
  end

  # tltestcase:: wrongTestSuiteName
  # tlsummary:: eXgXC[gs
  # tlsteps:: ݂ȂeXgXC[gݒ
  # tlexpectedresults:: G[ɂȂ邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_wrongTestSuiteName()
    @rtl.reportTCResultByTCName("wrongTestSuiteName","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "p" "sayHello" "Test_TestLinkClient1"`
    msg="[{\"message\"=>\"The Test Case ID (tcid) provided does not exist!\", \"code\"=>5000}]\n"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("wrongTestSuiteName","Test_remoteTestLink","p")
  end

  # tltestcase:: wrongStatus
  # tlsummary:: Xe[^Xs
  # tlsteps:: ݂ȂXe[^Xݒ
  # tlexpectedresults:: G[ɂȂ邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_wrongStatus()
    @rtl.reportTCResultByTCName("wrongStatus","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "x" "sayHello" "Test_TestLinkClient"`
    msg="[{\"message\"=>\"The status (status) provided is not valid!\", \"code\"=>6000}]\n"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("wrongStatus","Test_remoteTestLink","p")
  end

  # tltestcase:: setPassStatusWithTestSuiteAndNotes
  # tlsummary:: Rgݒ eXgXC[gȂ
  # tlsteps:: Rgݒ
  # tlexpectedresults:: ɏI邱
  # tlkeyword:: API
  # tlnotes:: remoteTestLink
  def test_setPassStatusAndNotes()
    @rtl.reportTCResultByTCName("setPassStatusAndNotes","Test_remoteTestLink","f")

    res = `ruby ../remoteTestLink.rb #{ServerURL} #{Dev_key} "p" "sayHello" -c "note message"`
    msg="[{\"message\"=>\"Success!\", \"status\"=>true"
    assert_equal(msg,res[0..msg.size-1])

    @rtl.reportTCResultByTCName("setPassStatusAndNotes","Test_remoteTestLink","p")
  end

end
