#!/usr/bin/env ruby 

require 'rubygems'
require 'TestLinkClient'
require 'optparse'

Version="0.02"

def putsHelp
  puts "USAGE #{File::basename($0)} serverURL dev_key status(p or f or b) testcase_name [testsuite_name]"
  puts "-v:Version -h:help"
end


notes=nil
OptionParser.new {|opt|
  opt.on('-c [OPTION]') {|v| notes = v }
  opt.on('-v') {|v| puts Version;exit(0)}
  opt.on('-h') {|v| putsHelp;exit(0)}
  opt.parse!(ARGV)
}

SERVER_URL = 0
DEV_KEY = 1
TESTCASE_STATUS = 2
TESTCASE_NAME = 3
TESTSUITE_NAME = 4

if ARGV.size == TESTCASE_NAME + 1 or ARGV.size == TESTSUITE_NAME + 1 then

  client = TestLinkClient.new(ARGV[SERVER_URL],ARGV[DEV_KEY])
  pid = client.getProjectID
  tpid = client.getTestPlanID(pid)
  bid = client.getBuildID(tpid)

  if ARGV.size == TESTSUITE_NAME + 1 then
    ret = client.reportTCResultByTCName(ARGV[TESTCASE_NAME],ARGV[TESTSUITE_NAME],ARGV[TESTCASE_STATUS],notes)
  else
    ret = client.reportTCResultByTCName(ARGV[TESTCASE_NAME],nil,ARGV[TESTCASE_STATUS],notes)
  end
  p ret
  if ret[0]["status"] == true then
    exit(0)
  else
    exit(1)
  end
else
  putsHelp
  exit(2)
end
