#
#=RubyToXML UnitTest
#
# Author::    garyo  (mailto:garyohosu@gmail.com)
# Copyright:: Copyright (c) 2007 garyo
# License::   GPL
$LOAD_PATH << File.dirname(__FILE__) + '/..'
require 'test/unit'
require '../rubytoxml'
require 'FileUtils'

#RubyToXML̃eXg
class Test_RubyToXML < Test::Unit::TestCase

	def setup
		@obj = RubyToXML.new
	end

	# tltestcase:: ǂݍ݃t@CmF
	# tlsummary:: t@Cǂݍ
	# tlsteps:: t@Cw肵t@Cǂݍ
	# tlexpectedresults:: t@Cݒ肳邱
	# tlkeyword:: FILE
	# tlnotes:: t@C֘A
	def test_load_file_title()
    tf="testfile.txt"
    open(tf,"w"){|f|
      f.puts "test"
    }
    @obj.load_file(tf)
    assert_equal(tf,@obj.filename)
    FileUtils.rm([tf]) 
	end

	# tltestcase:: ǂݍ݃t@CmF
	# tlsummary:: t@Cǂݍ
	# tlsteps:: t@Cw肵t@Cǂݍ
	# tlexpectedresults:: ǂݍ񂾃t@C̒l
	# tlkeyword:: FILE
	# tlnotes:: t@C֘A
	def test_load_file()
    tf="testfile.txt"
    tt="test\ntest2"
    open(tf,"w"){|f|
      f.puts tt
    }
    @obj.load_file(tf)
    assert_equal(tt,@obj.file.chop)
    FileUtils.rm([tf]) 
	end

	# tltestcase:: eXgP[XϊmFP
	# tlsummary:: eXgP[Xǂ݂
	# tlsteps:: ϊeLXg^
	# tlexpectedresults:: eXgP[XԂ邱
	# tlkeyword:: CONVERT
	# tlnotes:: ϊ֘A
	def test_convert_1()
    a=[]

    a[0]="tltestcase1"
    a[1]="tlsummary1"
    a[2]="tlsteps1"
    a[3]="tlexpectedresults1"
    a[4]="tlkeyword1"
    a[5]="tlnotes1"

    pf="::"

    testString="# tltestcase#{pf} #{a[0]}\n# tlsummary#{pf} #{a[1]}\n# tlsteps#{pf}  #{a[2]}\n# tlexpectedresults#{pf} #{a[3]}\n# tlkeyword#{pf} #{a[4]}\n# tlnotes#{pf} #{a[5]}\n"
    bb=@obj.convert(testString)

    if bb then
      bb.each{|b|
        a.each_with_index{|c,i|
          assert_equal(c,b.getdata(i))
        }
      }
    end
  end

	# tltestcase:: eXgP[XϊmFPO
	# tlsummary:: eXgP[Xǂ݂
	# tlsteps:: ϊeLXg^
	# tlexpectedresults:: eXgP[XԂ邱
	# tlkeyword:: CONVERT
	# tlnotes:: ϊ֘A
	def test_convert_n()

    n=10

    testString=""
    aa=[]
    n.times{|i|
      a=[]

      a[0]="tltestcase#{i}"
      a[1]="tlsummary#{i}"
      a[2]="tlsteps#{i}"
      a[3]="tlexpectedresults#{i}"
      a[4]="tlkeyword#{i}"
      a[5]="tlnotes#{i}"

      pf="::"

    testString += "# tltestcase#{pf} #{a[0]}\n# tlsummary#{pf} #{a[1]}\n# tlsteps#{pf}  #{a[2]}\n# tlexpectedresults#{pf} #{a[3]}\n# tlkeyword#{pf} #{a[4]}\n# tlnotes#{pf} #{a[5]}\n"
      aa << a
    }
    bb=@obj.convert(testString)

    aabb=aa.zip(bb)

    aabb.each{|a,b|
      a.each_with_index{|c,i|
        assert_equal(c,b.getdata(i))
      }
    }
  end
  
	# tltestcase:: t@CϊmF
	# tlsummary:: t@Cϊ邱
	# tlsteps:: ϊt@Cݒ
	# tlexpectedresults:: t@CϊEۑ邱
	# tlkeyword:: FILE
	# tlnotes:: t@C֘A
	def test_conv_name_file()
    @obj.main("test_rubytoxml.rb")
    r = FileTest.exist? "test_rubytoxml.xml"
    assert(r)
    FileUtils.rm(["test_rubytoxml.xml"]) 
  end  

	# tltestcase:: t@CϊmF
	# tlsummary:: t@Cϊ邱
	# tlsteps:: ϊt@Cݒ
	# tlexpectedresults:: t@CϊEۑ邱
	# tlkeyword:: FILE
	# tlnotes:: t@C֘A
	def test_conv_file()
    @obj.main("sample.rb")
    r = FileTest.exist? "sample.xml"
    assert(r)

    open("sample.xml"){|f1|
      open("sample_comp.xml"){|f2|
        assert_equal(f1.gets,f2.gets)
      }
    }
    FileUtils.rm(["sample.xml"]) 
  end  

end
